/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies attribute-based criteria for including or excluding endpoints from a segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeDimension implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeDimension.Builder, AttributeDimension> {
    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeType").getter(getter(AttributeDimension::attributeTypeAsString))
            .setter(setter(Builder::attributeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeType").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(AttributeDimension::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_TYPE_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeType;

    private final List<String> values;

    private AttributeDimension(BuilderImpl builder) {
        this.attributeType = builder.attributeType;
        this.values = builder.values;
    }

    /**
     * <p>
     * The type of segment dimension to use. Valid values are:
     * <ul>
     * <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
     * <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
     * <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li>
     * <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the
     * segment.</li>
     * <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li>
     * <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is
     * ignored in this comparison.</li>
     * <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the
     * segment.</li>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The type of segment dimension to use. Valid values are:
     *         <ul>
     *         <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
     *         <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
     *         <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li>
     *         <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the
     *         segment.</li>
     *         <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the
     *         segment.</li>
     *         <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment.
     *         Time is ignored in this comparison.</li>
     *         <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in
     *         the segment.</li>
     * @see AttributeType
     */
    public final AttributeType attributeType() {
        return AttributeType.fromValue(attributeType);
    }

    /**
     * <p>
     * The type of segment dimension to use. Valid values are:
     * <ul>
     * <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
     * <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
     * <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li>
     * <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the
     * segment.</li>
     * <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li>
     * <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is
     * ignored in this comparison.</li>
     * <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the
     * segment.</li>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attributeType}
     * will return {@link AttributeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeTypeAsString}.
     * </p>
     * 
     * @return The type of segment dimension to use. Valid values are:
     *         <ul>
     *         <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
     *         <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
     *         <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li>
     *         <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the
     *         segment.</li>
     *         <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the
     *         segment.</li>
     *         <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment.
     *         Time is ignored in this comparison.</li>
     *         <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in
     *         the segment.</li>
     * @see AttributeType
     */
    public final String attributeTypeAsString() {
        return attributeType;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria values to use for the segment dimension. Depending on the value of the AttributeType property,
     * endpoints are included or excluded from the segment if their attribute values match the criteria values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The criteria values to use for the segment dimension. Depending on the value of the AttributeType
     *         property, endpoints are included or excluded from the segment if their attribute values match the
     *         criteria values.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDimension)) {
            return false;
        }
        AttributeDimension other = (AttributeDimension) obj;
        return Objects.equals(attributeTypeAsString(), other.attributeTypeAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeDimension").add("AttributeType", attributeTypeAsString())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeType":
            return Optional.ofNullable(clazz.cast(attributeTypeAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeDimension, T> g) {
        return obj -> g.apply((AttributeDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeDimension> {
        /**
         * <p>
         * The type of segment dimension to use. Valid values are:
         * <ul>
         * <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
         * <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
         * <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li>
         * <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the
         * segment.</li>
         * <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the
         * segment.</li>
         * <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time
         * is ignored in this comparison.</li>
         * <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the
         * segment.</li>
         * </p>
         * 
         * @param attributeType
         *        The type of segment dimension to use. Valid values are:
         *        <ul>
         *        <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
         *        <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
         *        <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the
         *        segment.</li>
         *        <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in
         *        the segment.</li>
         *        <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in
         *        the segment.</li>
         *        <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment.
         *        Time is ignored in this comparison.</li>
         *        <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included
         *        in the segment.</li>
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder attributeType(String attributeType);

        /**
         * <p>
         * The type of segment dimension to use. Valid values are:
         * <ul>
         * <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
         * <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
         * <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the segment.</li>
         * <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the
         * segment.</li>
         * <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the
         * segment.</li>
         * <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time
         * is ignored in this comparison.</li>
         * <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the
         * segment.</li>
         * </p>
         * 
         * @param attributeType
         *        The type of segment dimension to use. Valid values are:
         *        <ul>
         *        <li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li>
         *        <li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li>
         *        <li>CONTAINS - endpoints that have attributes' substrings match the values are included in the
         *        segment.</li>
         *        <li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in
         *        the segment.</li>
         *        <li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in
         *        the segment.</li>
         *        <li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment.
         *        Time is ignored in this comparison.</li>
         *        <li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included
         *        in the segment.</li>
         * @see AttributeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeType
         */
        Builder attributeType(AttributeType attributeType);

        /**
         * <p>
         * The criteria values to use for the segment dimension. Depending on the value of the AttributeType property,
         * endpoints are included or excluded from the segment if their attribute values match the criteria values.
         * </p>
         * 
         * @param values
         *        The criteria values to use for the segment dimension. Depending on the value of the AttributeType
         *        property, endpoints are included or excluded from the segment if their attribute values match the
         *        criteria values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The criteria values to use for the segment dimension. Depending on the value of the AttributeType property,
         * endpoints are included or excluded from the segment if their attribute values match the criteria values.
         * </p>
         * 
         * @param values
         *        The criteria values to use for the segment dimension. Depending on the value of the AttributeType
         *        property, endpoints are included or excluded from the segment if their attribute values match the
         *        criteria values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String attributeType;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeDimension model) {
            attributeType(model.attributeType);
            values(model.values);
        }

        public final String getAttributeType() {
            return attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(AttributeType attributeType) {
            this.attributeType(attributeType == null ? null : attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOf__stringCopier.copy(values);
        }

        @Override
        public AttributeDimension build() {
            return new AttributeDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
