/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEventStreamResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteEventStreamResponse.Builder, DeleteEventStreamResponse> {
    private static final SdkField<EventStream> EVENT_STREAM_FIELD = SdkField
            .<EventStream> builder(MarshallingType.SDK_POJO)
            .memberName("EventStream")
            .getter(getter(DeleteEventStreamResponse::eventStream))
            .setter(setter(Builder::eventStream))
            .constructor(EventStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStream").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_STREAM_FIELD));

    private final EventStream eventStream;

    private DeleteEventStreamResponse(BuilderImpl builder) {
        super(builder);
        this.eventStream = builder.eventStream;
    }

    /**
     * Returns the value of the EventStream property for this object.
     * 
     * @return The value of the EventStream property for this object.
     */
    public final EventStream eventStream() {
        return eventStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventStreamResponse)) {
            return false;
        }
        DeleteEventStreamResponse other = (DeleteEventStreamResponse) obj;
        return Objects.equals(eventStream(), other.eventStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEventStreamResponse").add("EventStream", eventStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventStream":
            return Optional.ofNullable(clazz.cast(eventStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEventStreamResponse, T> g) {
        return obj -> g.apply((DeleteEventStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEventStreamResponse> {
        /**
         * Sets the value of the EventStream property for this object.
         *
         * @param eventStream
         *        The new value for the EventStream property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStream(EventStream eventStream);

        /**
         * Sets the value of the EventStream property for this object.
         *
         * This is a convenience that creates an instance of the {@link EventStream.Builder} avoiding the need to create
         * one manually via {@link EventStream#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventStream.Builder#build()} is called immediately and its result
         * is passed to {@link #eventStream(EventStream)}.
         * 
         * @param eventStream
         *        a consumer that will call methods on {@link EventStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventStream(EventStream)
         */
        default Builder eventStream(Consumer<EventStream.Builder> eventStream) {
            return eventStream(EventStream.builder().applyMutation(eventStream).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private EventStream eventStream;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventStreamResponse model) {
            super(model);
            eventStream(model.eventStream);
        }

        public final EventStream.Builder getEventStream() {
            return eventStream != null ? eventStream.toBuilder() : null;
        }

        @Override
        public final Builder eventStream(EventStream eventStream) {
            this.eventStream = eventStream;
            return this;
        }

        public final void setEventStream(EventStream.BuilderImpl eventStream) {
            this.eventStream = eventStream != null ? eventStream.build() : null;
        }

        @Override
        public DeleteEventStreamResponse build() {
            return new DeleteEventStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
