/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationDateRangeKpiRequest extends PinpointRequest implements
        ToCopyableBuilder<GetApplicationDateRangeKpiRequest.Builder, GetApplicationDateRangeKpiRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(GetApplicationDateRangeKpiRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(GetApplicationDateRangeKpiRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("end-time").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> KPI_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KpiName").getter(getter(GetApplicationDateRangeKpiRequest::kpiName)).setter(setter(Builder::kpiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("kpi-name").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetApplicationDateRangeKpiRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<String> PAGE_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageSize").getter(getter(GetApplicationDateRangeKpiRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page-size").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(GetApplicationDateRangeKpiRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("start-time").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            END_TIME_FIELD, KPI_NAME_FIELD, NEXT_TOKEN_FIELD, PAGE_SIZE_FIELD, START_TIME_FIELD));

    private final String applicationId;

    private final Instant endTime;

    private final String kpiName;

    private final String nextToken;

    private final String pageSize;

    private final Instant startTime;

    private GetApplicationDateRangeKpiRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.endTime = builder.endTime;
        this.kpiName = builder.kpiName;
        this.nextToken = builder.nextToken;
        this.pageSize = builder.pageSize;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The last date and time to retrieve data for, as part of an inclusive date range that filters the query results.
     * This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example:
     * 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.
     * </p>
     * 
     * @return The last date and time to retrieve data for, as part of an inclusive date range that filters the query
     *         results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for
     *         example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for. This
     * value describes the associated metric and consists of two or more terms, which are comprised of lowercase
     * alphanumeric characters, separated by a hyphen. Examples are email-open-rate and successful-delivery-rate. For a
     * list of valid values, see the <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint
     * Developer Guide</a>.
     * </p>
     * 
     * @return The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data
     *         for. This value describes the associated metric and consists of two or more terms, which are comprised of
     *         lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and
     *         successful-delivery-rate. For a list of valid values, see the <a
     *         href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
     *         Pinpoint Developer Guide</a>.
     */
    public final String kpiName() {
        return kpiName;
    }

    /**
     * <p>
     * The string that specifies which page of results to return in a paginated response. This parameter is not
     * supported for application, campaign, and journey metrics.
     * </p>
     * 
     * @return The string that specifies which page of results to return in a paginated response. This parameter is not
     *         supported for application, campaign, and journey metrics.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of a paginated response. This parameter is not supported for
     * application, campaign, and journey metrics.
     * </p>
     * 
     * @return The maximum number of items to include in each page of a paginated response. This parameter is not
     *         supported for application, campaign, and journey metrics.
     */
    public final String pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The first date and time to retrieve data for, as part of an inclusive date range that filters the query results.
     * This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for example:
     * 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days from the current
     * day.
     * </p>
     * 
     * @return The first date and time to retrieve data for, as part of an inclusive date range that filters the query
     *         results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for
     *         example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days
     *         from the current day.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(kpiName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationDateRangeKpiRequest)) {
            return false;
        }
        GetApplicationDateRangeKpiRequest other = (GetApplicationDateRangeKpiRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(kpiName(), other.kpiName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(pageSize(), other.pageSize()) && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationDateRangeKpiRequest").add("ApplicationId", applicationId())
                .add("EndTime", endTime()).add("KpiName", kpiName()).add("NextToken", nextToken()).add("PageSize", pageSize())
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "KpiName":
            return Optional.ofNullable(clazz.cast(kpiName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationDateRangeKpiRequest, T> g) {
        return obj -> g.apply((GetApplicationDateRangeKpiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetApplicationDateRangeKpiRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The last date and time to retrieve data for, as part of an inclusive date range that filters the query
         * results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for
         * example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.
         * </p>
         * 
         * @param endTime
         *        The last date and time to retrieve data for, as part of an inclusive date range that filters the query
         *        results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC),
         *        for example: 2019-07-26T20:00:00Z for 8:00 PM UTC July 26, 2019.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data for.
         * This value describes the associated metric and consists of two or more terms, which are comprised of
         * lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and
         * successful-delivery-rate. For a list of valid values, see the <a
         * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
         * Pinpoint Developer Guide</a>.
         * </p>
         * 
         * @param kpiName
         *        The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, to retrieve data
         *        for. This value describes the associated metric and consists of two or more terms, which are comprised
         *        of lowercase alphanumeric characters, separated by a hyphen. Examples are email-open-rate and
         *        successful-delivery-rate. For a list of valid values, see the <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html"
         *        >Amazon Pinpoint Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kpiName(String kpiName);

        /**
         * <p>
         * The string that specifies which page of results to return in a paginated response. This parameter is not
         * supported for application, campaign, and journey metrics.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies which page of results to return in a paginated response. This parameter is
         *        not supported for application, campaign, and journey metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to include in each page of a paginated response. This parameter is not supported
         * for application, campaign, and journey metrics.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of items to include in each page of a paginated response. This parameter is not
         *        supported for application, campaign, and journey metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(String pageSize);

        /**
         * <p>
         * The first date and time to retrieve data for, as part of an inclusive date range that filters the query
         * results. This value should be in extended ISO 8601 format and use Coordinated Universal Time (UTC), for
         * example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be fewer than 90 days
         * from the current day.
         * </p>
         * 
         * @param startTime
         *        The first date and time to retrieve data for, as part of an inclusive date range that filters the
         *        query results. This value should be in extended ISO 8601 format and use Coordinated Universal Time
         *        (UTC), for example: 2019-07-19T20:00:00Z for 8:00 PM UTC July 19, 2019. This value should also be
         *        fewer than 90 days from the current day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private Instant endTime;

        private String kpiName;

        private String nextToken;

        private String pageSize;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationDateRangeKpiRequest model) {
            super(model);
            applicationId(model.applicationId);
            endTime(model.endTime);
            kpiName(model.kpiName);
            nextToken(model.nextToken);
            pageSize(model.pageSize);
            startTime(model.startTime);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getKpiName() {
            return kpiName;
        }

        @Override
        public final Builder kpiName(String kpiName) {
            this.kpiName = kpiName;
            return this;
        }

        public final void setKpiName(String kpiName) {
            this.kpiName = kpiName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationDateRangeKpiRequest build() {
            return new GetApplicationDateRangeKpiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
