/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a campaign treatment. A <i>treatment</i> is a variation of a campaign that's used for A/B
 * testing of a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TreatmentResource implements SdkPojo, Serializable,
        ToCopyableBuilder<TreatmentResource.Builder, TreatmentResource> {
    private static final SdkField<CustomDeliveryConfiguration> CUSTOM_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<CustomDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CustomDeliveryConfiguration")
            .getter(getter(TreatmentResource::customDeliveryConfiguration))
            .setter(setter(Builder::customDeliveryConfiguration))
            .constructor(CustomDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDeliveryConfiguration")
                    .build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(TreatmentResource::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<MessageConfiguration> builder(MarshallingType.SDK_POJO).memberName("MessageConfiguration")
            .getter(getter(TreatmentResource::messageConfiguration)).setter(setter(Builder::messageConfiguration))
            .constructor(MessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(TreatmentResource::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<Integer> SIZE_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizePercent").getter(getter(TreatmentResource::sizePercent)).setter(setter(Builder::sizePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizePercent").build()).build();

    private static final SdkField<CampaignState> STATE_FIELD = SdkField.<CampaignState> builder(MarshallingType.SDK_POJO)
            .memberName("State").getter(getter(TreatmentResource::state)).setter(setter(Builder::state))
            .constructor(CampaignState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("TemplateConfiguration")
            .getter(getter(TreatmentResource::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(TemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build())
            .build();

    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentDescription").getter(getter(TreatmentResource::treatmentDescription))
            .setter(setter(Builder::treatmentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build())
            .build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentName").getter(getter(TreatmentResource::treatmentName)).setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_DELIVERY_CONFIGURATION_FIELD, ID_FIELD, MESSAGE_CONFIGURATION_FIELD, SCHEDULE_FIELD, SIZE_PERCENT_FIELD,
            STATE_FIELD, TEMPLATE_CONFIGURATION_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final CustomDeliveryConfiguration customDeliveryConfiguration;

    private final String id;

    private final MessageConfiguration messageConfiguration;

    private final Schedule schedule;

    private final Integer sizePercent;

    private final CampaignState state;

    private final TemplateConfiguration templateConfiguration;

    private final String treatmentDescription;

    private final String treatmentName;

    private TreatmentResource(BuilderImpl builder) {
        this.customDeliveryConfiguration = builder.customDeliveryConfiguration;
        this.id = builder.id;
        this.messageConfiguration = builder.messageConfiguration;
        this.schedule = builder.schedule;
        this.sizePercent = builder.sizePercent;
        this.state = builder.state;
        this.templateConfiguration = builder.templateConfiguration;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
    }

    /**
     * <p>
     * The delivery configuration settings for sending the treatment through a custom channel. This object is required
     * if the MessageConfiguration object for the treatment specifies a CustomMessage object.
     * </p>
     * 
     * @return The delivery configuration settings for sending the treatment through a custom channel. This object is
     *         required if the MessageConfiguration object for the treatment specifies a CustomMessage object.
     */
    public final CustomDeliveryConfiguration customDeliveryConfiguration() {
        return customDeliveryConfiguration;
    }

    /**
     * <p>
     * The unique identifier for the treatment.
     * </p>
     * 
     * @return The unique identifier for the treatment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The message configuration settings for the treatment.
     * </p>
     * 
     * @return The message configuration settings for the treatment.
     */
    public final MessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * <p>
     * The schedule settings for the treatment.
     * </p>
     * 
     * @return The schedule settings for the treatment.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The allocated percentage of users (segment members) that the treatment is sent to.
     * </p>
     * 
     * @return The allocated percentage of users (segment members) that the treatment is sent to.
     */
    public final Integer sizePercent() {
        return sizePercent;
    }

    /**
     * <p>
     * The current status of the treatment.
     * </p>
     * 
     * @return The current status of the treatment.
     */
    public final CampaignState state() {
        return state;
    }

    /**
     * <p>
     * The message template to use for the treatment.
     * </p>
     * 
     * @return The message template to use for the treatment.
     */
    public final TemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The custom description of the treatment.
     * </p>
     * 
     * @return The custom description of the treatment.
     */
    public final String treatmentDescription() {
        return treatmentDescription;
    }

    /**
     * <p>
     * The custom name of the treatment.
     * </p>
     * 
     * @return The custom name of the treatment.
     */
    public final String treatmentName() {
        return treatmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(sizePercent());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreatmentResource)) {
            return false;
        }
        TreatmentResource other = (TreatmentResource) obj;
        return Objects.equals(customDeliveryConfiguration(), other.customDeliveryConfiguration())
                && Objects.equals(id(), other.id()) && Objects.equals(messageConfiguration(), other.messageConfiguration())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(sizePercent(), other.sizePercent())
                && Objects.equals(state(), other.state())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(treatmentDescription(), other.treatmentDescription())
                && Objects.equals(treatmentName(), other.treatmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TreatmentResource").add("CustomDeliveryConfiguration", customDeliveryConfiguration())
                .add("Id", id()).add("MessageConfiguration", messageConfiguration()).add("Schedule", schedule())
                .add("SizePercent", sizePercent()).add("State", state()).add("TemplateConfiguration", templateConfiguration())
                .add("TreatmentDescription", treatmentDescription()).add("TreatmentName", treatmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(customDeliveryConfiguration()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "SizePercent":
            return Optional.ofNullable(clazz.cast(sizePercent()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "TemplateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "TreatmentDescription":
            return Optional.ofNullable(clazz.cast(treatmentDescription()));
        case "TreatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TreatmentResource, T> g) {
        return obj -> g.apply((TreatmentResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TreatmentResource> {
        /**
         * <p>
         * The delivery configuration settings for sending the treatment through a custom channel. This object is
         * required if the MessageConfiguration object for the treatment specifies a CustomMessage object.
         * </p>
         * 
         * @param customDeliveryConfiguration
         *        The delivery configuration settings for sending the treatment through a custom channel. This object is
         *        required if the MessageConfiguration object for the treatment specifies a CustomMessage object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration);

        /**
         * <p>
         * The delivery configuration settings for sending the treatment through a custom channel. This object is
         * required if the MessageConfiguration object for the treatment specifies a CustomMessage object.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomDeliveryConfiguration.Builder} avoiding
         * the need to create one manually via {@link CustomDeliveryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #customDeliveryConfiguration(CustomDeliveryConfiguration)}.
         * 
         * @param customDeliveryConfiguration
         *        a consumer that will call methods on {@link CustomDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDeliveryConfiguration(CustomDeliveryConfiguration)
         */
        default Builder customDeliveryConfiguration(Consumer<CustomDeliveryConfiguration.Builder> customDeliveryConfiguration) {
            return customDeliveryConfiguration(CustomDeliveryConfiguration.builder().applyMutation(customDeliveryConfiguration)
                    .build());
        }

        /**
         * <p>
         * The unique identifier for the treatment.
         * </p>
         * 
         * @param id
         *        The unique identifier for the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The message configuration settings for the treatment.
         * </p>
         * 
         * @param messageConfiguration
         *        The message configuration settings for the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(MessageConfiguration messageConfiguration);

        /**
         * <p>
         * The message configuration settings for the treatment.
         * </p>
         * This is a convenience that creates an instance of the {@link MessageConfiguration.Builder} avoiding the need
         * to create one manually via {@link MessageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #messageConfiguration(MessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link MessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(MessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(MessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * <p>
         * The schedule settings for the treatment.
         * </p>
         * 
         * @param schedule
         *        The schedule settings for the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule settings for the treatment.
         * </p>
         * This is a convenience that creates an instance of the {@link Schedule.Builder} avoiding the need to create
         * one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The allocated percentage of users (segment members) that the treatment is sent to.
         * </p>
         * 
         * @param sizePercent
         *        The allocated percentage of users (segment members) that the treatment is sent to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizePercent(Integer sizePercent);

        /**
         * <p>
         * The current status of the treatment.
         * </p>
         * 
         * @param state
         *        The current status of the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(CampaignState state);

        /**
         * <p>
         * The current status of the treatment.
         * </p>
         * This is a convenience that creates an instance of the {@link CampaignState.Builder} avoiding the need to
         * create one manually via {@link CampaignState#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(CampaignState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link CampaignState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(CampaignState)
         */
        default Builder state(Consumer<CampaignState.Builder> state) {
            return state(CampaignState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The message template to use for the treatment.
         * </p>
         * 
         * @param templateConfiguration
         *        The message template to use for the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(TemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The message template to use for the treatment.
         * </p>
         * This is a convenience that creates an instance of the {@link TemplateConfiguration.Builder} avoiding the need
         * to create one manually via {@link TemplateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #templateConfiguration(TemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link TemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(TemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(TemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The custom description of the treatment.
         * </p>
         * 
         * @param treatmentDescription
         *        The custom description of the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentDescription(String treatmentDescription);

        /**
         * <p>
         * The custom name of the treatment.
         * </p>
         * 
         * @param treatmentName
         *        The custom name of the treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);
    }

    static final class BuilderImpl implements Builder {
        private CustomDeliveryConfiguration customDeliveryConfiguration;

        private String id;

        private MessageConfiguration messageConfiguration;

        private Schedule schedule;

        private Integer sizePercent;

        private CampaignState state;

        private TemplateConfiguration templateConfiguration;

        private String treatmentDescription;

        private String treatmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(TreatmentResource model) {
            customDeliveryConfiguration(model.customDeliveryConfiguration);
            id(model.id);
            messageConfiguration(model.messageConfiguration);
            schedule(model.schedule);
            sizePercent(model.sizePercent);
            state(model.state);
            templateConfiguration(model.templateConfiguration);
            treatmentDescription(model.treatmentDescription);
            treatmentName(model.treatmentName);
        }

        public final CustomDeliveryConfiguration.Builder getCustomDeliveryConfiguration() {
            return customDeliveryConfiguration != null ? customDeliveryConfiguration.toBuilder() : null;
        }

        public final void setCustomDeliveryConfiguration(CustomDeliveryConfiguration.BuilderImpl customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration != null ? customDeliveryConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        @Transient
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Integer getSizePercent() {
            return sizePercent;
        }

        public final void setSizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
        }

        @Override
        @Transient
        public final Builder sizePercent(Integer sizePercent) {
            this.sizePercent = sizePercent;
            return this;
        }

        public final CampaignState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(CampaignState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        @Transient
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTreatmentDescription() {
            return treatmentDescription;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        @Override
        @Transient
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        @Transient
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        @Override
        public TreatmentResource build() {
            return new TreatmentResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
