/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyOtpMessageRequest extends PinpointRequest implements
        ToCopyableBuilder<VerifyOtpMessageRequest.Builder, VerifyOtpMessageRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(VerifyOtpMessageRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<VerifyOTPMessageRequestParameters> VERIFY_OTP_MESSAGE_REQUEST_PARAMETERS_FIELD = SdkField
            .<VerifyOTPMessageRequestParameters> builder(MarshallingType.SDK_POJO)
            .memberName("VerifyOTPMessageRequestParameters")
            .getter(getter(VerifyOtpMessageRequest::verifyOTPMessageRequestParameters))
            .setter(setter(Builder::verifyOTPMessageRequestParameters))
            .constructor(VerifyOTPMessageRequestParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyOTPMessageRequestParameters")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            VERIFY_OTP_MESSAGE_REQUEST_PARAMETERS_FIELD));

    private final String applicationId;

    private final VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters;

    private VerifyOtpMessageRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.verifyOTPMessageRequestParameters = builder.verifyOTPMessageRequestParameters;
    }

    /**
     * <p>
     * The unique ID of your Amazon Pinpoint application.
     * </p>
     * 
     * @return The unique ID of your Amazon Pinpoint application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the VerifyOTPMessageRequestParameters property for this object.
     * 
     * @return The value of the VerifyOTPMessageRequestParameters property for this object.
     */
    public final VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters() {
        return verifyOTPMessageRequestParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(verifyOTPMessageRequestParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyOtpMessageRequest)) {
            return false;
        }
        VerifyOtpMessageRequest other = (VerifyOtpMessageRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(verifyOTPMessageRequestParameters(), other.verifyOTPMessageRequestParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyOtpMessageRequest").add("ApplicationId", applicationId())
                .add("VerifyOTPMessageRequestParameters", verifyOTPMessageRequestParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "VerifyOTPMessageRequestParameters":
            return Optional.ofNullable(clazz.cast(verifyOTPMessageRequestParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyOtpMessageRequest, T> g) {
        return obj -> g.apply((VerifyOtpMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, VerifyOtpMessageRequest> {
        /**
         * <p>
         * The unique ID of your Amazon Pinpoint application.
         * </p>
         * 
         * @param applicationId
         *        The unique ID of your Amazon Pinpoint application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the VerifyOTPMessageRequestParameters property for this object.
         *
         * @param verifyOTPMessageRequestParameters
         *        The new value for the VerifyOTPMessageRequestParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters);

        /**
         * Sets the value of the VerifyOTPMessageRequestParameters property for this object.
         *
         * This is a convenience that creates an instance of the {@link VerifyOTPMessageRequestParameters.Builder}
         * avoiding the need to create one manually via {@link VerifyOTPMessageRequestParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link VerifyOTPMessageRequestParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #verifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters)}.
         * 
         * @param verifyOTPMessageRequestParameters
         *        a consumer that will call methods on {@link VerifyOTPMessageRequestParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters)
         */
        default Builder verifyOTPMessageRequestParameters(
                Consumer<VerifyOTPMessageRequestParameters.Builder> verifyOTPMessageRequestParameters) {
            return verifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters.builder()
                    .applyMutation(verifyOTPMessageRequestParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyOtpMessageRequest model) {
            super(model);
            applicationId(model.applicationId);
            verifyOTPMessageRequestParameters(model.verifyOTPMessageRequestParameters);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final VerifyOTPMessageRequestParameters.Builder getVerifyOTPMessageRequestParameters() {
            return verifyOTPMessageRequestParameters != null ? verifyOTPMessageRequestParameters.toBuilder() : null;
        }

        public final void setVerifyOTPMessageRequestParameters(
                VerifyOTPMessageRequestParameters.BuilderImpl verifyOTPMessageRequestParameters) {
            this.verifyOTPMessageRequestParameters = verifyOTPMessageRequestParameters != null ? verifyOTPMessageRequestParameters
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder verifyOTPMessageRequestParameters(VerifyOTPMessageRequestParameters verifyOTPMessageRequestParameters) {
            this.verifyOTPMessageRequestParameters = verifyOTPMessageRequestParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyOtpMessageRequest build() {
            return new VerifyOtpMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
