/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a wait activity in a journey. This type of activity waits for a certain amount of time or
 * until a specific date and time before moving participants to the next activity in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaitActivity implements SdkPojo, Serializable, ToCopyableBuilder<WaitActivity.Builder, WaitActivity> {
    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextActivity").getter(getter(WaitActivity::nextActivity)).setter(setter(Builder::nextActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()).build();

    private static final SdkField<WaitTime> WAIT_TIME_FIELD = SdkField.<WaitTime> builder(MarshallingType.SDK_POJO)
            .memberName("WaitTime").getter(getter(WaitActivity::waitTime)).setter(setter(Builder::waitTime))
            .constructor(WaitTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_ACTIVITY_FIELD,
            WAIT_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nextActivity;

    private final WaitTime waitTime;

    private WaitActivity(BuilderImpl builder) {
        this.nextActivity = builder.nextActivity;
        this.waitTime = builder.waitTime;
    }

    /**
     * <p>
     * The unique identifier for the next activity to perform, after performing the wait activity.
     * </p>
     * 
     * @return The unique identifier for the next activity to perform, after performing the wait activity.
     */
    public final String nextActivity() {
        return nextActivity;
    }

    /**
     * <p>
     * The amount of time to wait or the date and time when the activity moves participants to the next activity in the
     * journey.
     * </p>
     * 
     * @return The amount of time to wait or the date and time when the activity moves participants to the next activity
     *         in the journey.
     */
    public final WaitTime waitTime() {
        return waitTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextActivity());
        hashCode = 31 * hashCode + Objects.hashCode(waitTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaitActivity)) {
            return false;
        }
        WaitActivity other = (WaitActivity) obj;
        return Objects.equals(nextActivity(), other.nextActivity()) && Objects.equals(waitTime(), other.waitTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaitActivity").add("NextActivity", nextActivity()).add("WaitTime", waitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextActivity":
            return Optional.ofNullable(clazz.cast(nextActivity()));
        case "WaitTime":
            return Optional.ofNullable(clazz.cast(waitTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WaitActivity, T> g) {
        return obj -> g.apply((WaitActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaitActivity> {
        /**
         * <p>
         * The unique identifier for the next activity to perform, after performing the wait activity.
         * </p>
         * 
         * @param nextActivity
         *        The unique identifier for the next activity to perform, after performing the wait activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextActivity(String nextActivity);

        /**
         * <p>
         * The amount of time to wait or the date and time when the activity moves participants to the next activity in
         * the journey.
         * </p>
         * 
         * @param waitTime
         *        The amount of time to wait or the date and time when the activity moves participants to the next
         *        activity in the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitTime(WaitTime waitTime);

        /**
         * <p>
         * The amount of time to wait or the date and time when the activity moves participants to the next activity in
         * the journey.
         * </p>
         * This is a convenience method that creates an instance of the {@link WaitTime.Builder} avoiding the need to
         * create one manually via {@link WaitTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link WaitTime.Builder#build()} is called immediately and its result is
         * passed to {@link #waitTime(WaitTime)}.
         * 
         * @param waitTime
         *        a consumer that will call methods on {@link WaitTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitTime(WaitTime)
         */
        default Builder waitTime(Consumer<WaitTime.Builder> waitTime) {
            return waitTime(WaitTime.builder().applyMutation(waitTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String nextActivity;

        private WaitTime waitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WaitActivity model) {
            nextActivity(model.nextActivity);
            waitTime(model.waitTime);
        }

        public final String getNextActivity() {
            return nextActivity;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        public final WaitTime.Builder getWaitTime() {
            return waitTime != null ? waitTime.toBuilder() : null;
        }

        public final void setWaitTime(WaitTime.BuilderImpl waitTime) {
            this.waitTime = waitTime != null ? waitTime.build() : null;
        }

        @Override
        public final Builder waitTime(WaitTime waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        @Override
        public WaitActivity build() {
            return new WaitActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
