/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInAppTemplateResponse extends PinpointResponse implements
        ToCopyableBuilder<GetInAppTemplateResponse.Builder, GetInAppTemplateResponse> {
    private static final SdkField<InAppTemplateResponse> IN_APP_TEMPLATE_RESPONSE_FIELD = SdkField
            .<InAppTemplateResponse> builder(MarshallingType.SDK_POJO)
            .memberName("InAppTemplateResponse")
            .getter(getter(GetInAppTemplateResponse::inAppTemplateResponse))
            .setter(setter(Builder::inAppTemplateResponse))
            .constructor(InAppTemplateResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppTemplateResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IN_APP_TEMPLATE_RESPONSE_FIELD));

    private final InAppTemplateResponse inAppTemplateResponse;

    private GetInAppTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.inAppTemplateResponse = builder.inAppTemplateResponse;
    }

    /**
     * Returns the value of the InAppTemplateResponse property for this object.
     * 
     * @return The value of the InAppTemplateResponse property for this object.
     */
    public final InAppTemplateResponse inAppTemplateResponse() {
        return inAppTemplateResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inAppTemplateResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInAppTemplateResponse)) {
            return false;
        }
        GetInAppTemplateResponse other = (GetInAppTemplateResponse) obj;
        return Objects.equals(inAppTemplateResponse(), other.inAppTemplateResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInAppTemplateResponse").add("InAppTemplateResponse", inAppTemplateResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InAppTemplateResponse":
            return Optional.ofNullable(clazz.cast(inAppTemplateResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInAppTemplateResponse, T> g) {
        return obj -> g.apply((GetInAppTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInAppTemplateResponse> {
        /**
         * Sets the value of the InAppTemplateResponse property for this object.
         *
         * @param inAppTemplateResponse
         *        The new value for the InAppTemplateResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppTemplateResponse(InAppTemplateResponse inAppTemplateResponse);

        /**
         * Sets the value of the InAppTemplateResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InAppTemplateResponse.Builder} avoiding
         * the need to create one manually via {@link InAppTemplateResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link InAppTemplateResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #inAppTemplateResponse(InAppTemplateResponse)}.
         * 
         * @param inAppTemplateResponse
         *        a consumer that will call methods on {@link InAppTemplateResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inAppTemplateResponse(InAppTemplateResponse)
         */
        default Builder inAppTemplateResponse(Consumer<InAppTemplateResponse.Builder> inAppTemplateResponse) {
            return inAppTemplateResponse(InAppTemplateResponse.builder().applyMutation(inAppTemplateResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private InAppTemplateResponse inAppTemplateResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInAppTemplateResponse model) {
            super(model);
            inAppTemplateResponse(model.inAppTemplateResponse);
        }

        public final InAppTemplateResponse.Builder getInAppTemplateResponse() {
            return inAppTemplateResponse != null ? inAppTemplateResponse.toBuilder() : null;
        }

        public final void setInAppTemplateResponse(InAppTemplateResponse.BuilderImpl inAppTemplateResponse) {
            this.inAppTemplateResponse = inAppTemplateResponse != null ? inAppTemplateResponse.build() : null;
        }

        @Override
        public final Builder inAppTemplateResponse(InAppTemplateResponse inAppTemplateResponse) {
            this.inAppTemplateResponse = inAppTemplateResponse;
            return this;
        }

        @Override
        public GetInAppTemplateResponse build() {
            return new GetInAppTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
