/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberValidateRequest extends PinpointRequest implements
        ToCopyableBuilder<PhoneNumberValidateRequest.Builder, PhoneNumberValidateRequest> {
    private static final SdkField<NumberValidateRequest> NUMBER_VALIDATE_REQUEST_FIELD = SdkField
            .<NumberValidateRequest> builder(MarshallingType.SDK_POJO)
            .memberName("NumberValidateRequest")
            .getter(getter(PhoneNumberValidateRequest::numberValidateRequest))
            .setter(setter(Builder::numberValidateRequest))
            .constructor(NumberValidateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValidateRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NUMBER_VALIDATE_REQUEST_FIELD));

    private final NumberValidateRequest numberValidateRequest;

    private PhoneNumberValidateRequest(BuilderImpl builder) {
        super(builder);
        this.numberValidateRequest = builder.numberValidateRequest;
    }

    /**
     * Returns the value of the NumberValidateRequest property for this object.
     * 
     * @return The value of the NumberValidateRequest property for this object.
     */
    public final NumberValidateRequest numberValidateRequest() {
        return numberValidateRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(numberValidateRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberValidateRequest)) {
            return false;
        }
        PhoneNumberValidateRequest other = (PhoneNumberValidateRequest) obj;
        return Objects.equals(numberValidateRequest(), other.numberValidateRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumberValidateRequest").add("NumberValidateRequest", numberValidateRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberValidateRequest":
            return Optional.ofNullable(clazz.cast(numberValidateRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberValidateRequest, T> g) {
        return obj -> g.apply((PhoneNumberValidateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, PhoneNumberValidateRequest> {
        /**
         * Sets the value of the NumberValidateRequest property for this object.
         *
         * @param numberValidateRequest
         *        The new value for the NumberValidateRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValidateRequest(NumberValidateRequest numberValidateRequest);

        /**
         * Sets the value of the NumberValidateRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NumberValidateRequest.Builder} avoiding
         * the need to create one manually via {@link NumberValidateRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link NumberValidateRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #numberValidateRequest(NumberValidateRequest)}.
         * 
         * @param numberValidateRequest
         *        a consumer that will call methods on {@link NumberValidateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberValidateRequest(NumberValidateRequest)
         */
        default Builder numberValidateRequest(Consumer<NumberValidateRequest.Builder> numberValidateRequest) {
            return numberValidateRequest(NumberValidateRequest.builder().applyMutation(numberValidateRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private NumberValidateRequest numberValidateRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberValidateRequest model) {
            super(model);
            numberValidateRequest(model.numberValidateRequest);
        }

        public final NumberValidateRequest.Builder getNumberValidateRequest() {
            return numberValidateRequest != null ? numberValidateRequest.toBuilder() : null;
        }

        public final void setNumberValidateRequest(NumberValidateRequest.BuilderImpl numberValidateRequest) {
            this.numberValidateRequest = numberValidateRequest != null ? numberValidateRequest.build() : null;
        }

        @Override
        public final Builder numberValidateRequest(NumberValidateRequest numberValidateRequest) {
            this.numberValidateRequest = numberValidateRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PhoneNumberValidateRequest build() {
            return new PhoneNumberValidateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
