/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the properties and attributes of an endpoint that's associated with an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<PublicEndpoint.Builder, PublicEndpoint> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(PublicEndpoint::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<Map<String, List<String>>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(PublicEndpoint::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelType").getter(getter(PublicEndpoint::channelTypeAsString)).setter(setter(Builder::channelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()).build();

    private static final SdkField<EndpointDemographic> DEMOGRAPHIC_FIELD = SdkField
            .<EndpointDemographic> builder(MarshallingType.SDK_POJO).memberName("Demographic")
            .getter(getter(PublicEndpoint::demographic)).setter(setter(Builder::demographic))
            .constructor(EndpointDemographic::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Demographic").build()).build();

    private static final SdkField<String> EFFECTIVE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveDate").getter(getter(PublicEndpoint::effectiveDate)).setter(setter(Builder::effectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").build()).build();

    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointStatus").getter(getter(PublicEndpoint::endpointStatus)).setter(setter(Builder::endpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()).build();

    private static final SdkField<EndpointLocation> LOCATION_FIELD = SdkField
            .<EndpointLocation> builder(MarshallingType.SDK_POJO).memberName("Location").getter(getter(PublicEndpoint::location))
            .setter(setter(Builder::location)).constructor(EndpointLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<Map<String, Double>> METRICS_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .memberName("Metrics")
            .getter(getter(PublicEndpoint::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OPT_OUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("OptOut")
            .getter(getter(PublicEndpoint::optOut)).setter(setter(Builder::optOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptOut").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(PublicEndpoint::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<EndpointUser> USER_FIELD = SdkField.<EndpointUser> builder(MarshallingType.SDK_POJO)
            .memberName("User").getter(getter(PublicEndpoint::user)).setter(setter(Builder::user))
            .constructor(EndpointUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            ATTRIBUTES_FIELD, CHANNEL_TYPE_FIELD, DEMOGRAPHIC_FIELD, EFFECTIVE_DATE_FIELD, ENDPOINT_STATUS_FIELD, LOCATION_FIELD,
            METRICS_FIELD, OPT_OUT_FIELD, REQUEST_ID_FIELD, USER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String address;

    private final Map<String, List<String>> attributes;

    private final String channelType;

    private final EndpointDemographic demographic;

    private final String effectiveDate;

    private final String endpointStatus;

    private final EndpointLocation location;

    private final Map<String, Double> metrics;

    private final String optOut;

    private final String requestId;

    private final EndpointUser user;

    private PublicEndpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.attributes = builder.attributes;
        this.channelType = builder.channelType;
        this.demographic = builder.demographic;
        this.effectiveDate = builder.effectiveDate;
        this.endpointStatus = builder.endpointStatus;
        this.location = builder.location;
        this.metrics = builder.metrics;
        this.optOut = builder.optOut;
        this.requestId = builder.requestId;
        this.user = builder.user;
    }

    /**
     * <p>
     * The unique identifier for the recipient, such as a device token, email address, or mobile phone number.
     * </p>
     * 
     * @return The unique identifier for the recipient, such as a device token, email address, or mobile phone number.
     */
    public final String address() {
        return address;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more custom attributes that describe the endpoint by associating a name with an array of values. You can
     * use these attributes as filter criteria when you create segments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return One or more custom attributes that describe the endpoint by associating a name with an array of values.
     *         You can use these attributes as filter criteria when you create segments.
     */
    public final Map<String, List<String>> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The channel that's used when sending messages or push notifications to the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The channel that's used when sending messages or push notifications to the endpoint.
     * @see ChannelType
     */
    public final ChannelType channelType() {
        return ChannelType.fromValue(channelType);
    }

    /**
     * <p>
     * The channel that's used when sending messages or push notifications to the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The channel that's used when sending messages or push notifications to the endpoint.
     * @see ChannelType
     */
    public final String channelTypeAsString() {
        return channelType;
    }

    /**
     * <p>
     * The demographic information for the endpoint, such as the time zone and platform.
     * </p>
     * 
     * @return The demographic information for the endpoint, such as the time zone and platform.
     */
    public final EndpointDemographic demographic() {
        return demographic;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when the endpoint was last updated.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when the endpoint was last updated.
     */
    public final String effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are
     * sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
     * </p>
     * <p>
     * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing
     * endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the
     * same address specified by the Address property.
     * </p>
     * 
     * @return Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE,
     *         messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p>
     *         <p>
     *         Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing
     *         endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that
     *         has the same address specified by the Address property.
     */
    public final String endpointStatus() {
        return endpointStatus;
    }

    /**
     * <p>
     * The geographic information for the endpoint.
     * </p>
     * 
     * @return The geographic information for the endpoint.
     */
    public final EndpointLocation location() {
        return location;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
     */
    public final Map<String, Double> metrics() {
        return metrics;
    }

    /**
     * <p>
     * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push
     * notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any messages
     * or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and push
     * notifications.
     * </p>
     * 
     * @return Specifies whether the user who's associated with the endpoint has opted out of receiving messages and
     *         push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive
     *         any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all
     *         messages and push notifications.
     */
    public final String optOut() {
        return optOut;
    }

    /**
     * <p>
     * A unique identifier that's generated each time the endpoint is updated.
     * </p>
     * 
     * @return A unique identifier that's generated each time the endpoint is updated.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated with
     * the endpoint.
     * </p>
     * 
     * @return One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated
     *         with the endpoint.
     */
    public final EndpointUser user() {
        return user;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(demographic());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatus());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(optOut());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(user());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicEndpoint)) {
            return false;
        }
        PublicEndpoint other = (PublicEndpoint) obj;
        return Objects.equals(address(), other.address()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(channelTypeAsString(), other.channelTypeAsString())
                && Objects.equals(demographic(), other.demographic()) && Objects.equals(effectiveDate(), other.effectiveDate())
                && Objects.equals(endpointStatus(), other.endpointStatus()) && Objects.equals(location(), other.location())
                && hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(optOut(), other.optOut()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(user(), other.user());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicEndpoint").add("Address", address())
                .add("Attributes", hasAttributes() ? attributes() : null).add("ChannelType", channelTypeAsString())
                .add("Demographic", demographic()).add("EffectiveDate", effectiveDate()).add("EndpointStatus", endpointStatus())
                .add("Location", location()).add("Metrics", hasMetrics() ? metrics() : null).add("OptOut", optOut())
                .add("RequestId", requestId()).add("User", user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ChannelType":
            return Optional.ofNullable(clazz.cast(channelTypeAsString()));
        case "Demographic":
            return Optional.ofNullable(clazz.cast(demographic()));
        case "EffectiveDate":
            return Optional.ofNullable(clazz.cast(effectiveDate()));
        case "EndpointStatus":
            return Optional.ofNullable(clazz.cast(endpointStatus()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "OptOut":
            return Optional.ofNullable(clazz.cast(optOut()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicEndpoint, T> g) {
        return obj -> g.apply((PublicEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicEndpoint> {
        /**
         * <p>
         * The unique identifier for the recipient, such as a device token, email address, or mobile phone number.
         * </p>
         * 
         * @param address
         *        The unique identifier for the recipient, such as a device token, email address, or mobile phone
         *        number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * One or more custom attributes that describe the endpoint by associating a name with an array of values. You
         * can use these attributes as filter criteria when you create segments.
         * </p>
         * 
         * @param attributes
         *        One or more custom attributes that describe the endpoint by associating a name with an array of
         *        values. You can use these attributes as filter criteria when you create segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, ? extends Collection<String>> attributes);

        /**
         * <p>
         * The channel that's used when sending messages or push notifications to the endpoint.
         * </p>
         * 
         * @param channelType
         *        The channel that's used when sending messages or push notifications to the endpoint.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(String channelType);

        /**
         * <p>
         * The channel that's used when sending messages or push notifications to the endpoint.
         * </p>
         * 
         * @param channelType
         *        The channel that's used when sending messages or push notifications to the endpoint.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(ChannelType channelType);

        /**
         * <p>
         * The demographic information for the endpoint, such as the time zone and platform.
         * </p>
         * 
         * @param demographic
         *        The demographic information for the endpoint, such as the time zone and platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder demographic(EndpointDemographic demographic);

        /**
         * <p>
         * The demographic information for the endpoint, such as the time zone and platform.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointDemographic.Builder} avoiding the
         * need to create one manually via {@link EndpointDemographic#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointDemographic.Builder#build()} is called immediately and
         * its result is passed to {@link #demographic(EndpointDemographic)}.
         * 
         * @param demographic
         *        a consumer that will call methods on {@link EndpointDemographic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #demographic(EndpointDemographic)
         */
        default Builder demographic(Consumer<EndpointDemographic.Builder> demographic) {
            return demographic(EndpointDemographic.builder().applyMutation(demographic).build());
        }

        /**
         * <p>
         * The date and time, in ISO 8601 format, when the endpoint was last updated.
         * </p>
         * 
         * @param effectiveDate
         *        The date and time, in ISO 8601 format, when the endpoint was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(String effectiveDate);

        /**
         * <p>
         * Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages
         * are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.
         * </p>
         * <p>
         * Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing
         * endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has
         * the same address specified by the Address property.
         * </p>
         * 
         * @param endpointStatus
         *        Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE,
         *        messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p>
         *        <p>
         *        Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an
         *        existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another
         *        endpoint that has the same address specified by the Address property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * The geographic information for the endpoint.
         * </p>
         * 
         * @param location
         *        The geographic information for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(EndpointLocation location);

        /**
         * <p>
         * The geographic information for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointLocation.Builder} avoiding the
         * need to create one manually via {@link EndpointLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(EndpointLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link EndpointLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(EndpointLocation)
         */
        default Builder location(Consumer<EndpointLocation.Builder> location) {
            return location(EndpointLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
         * </p>
         * 
         * @param metrics
         *        One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, Double> metrics);

        /**
         * <p>
         * Specifies whether the user who's associated with the endpoint has opted out of receiving messages and push
         * notifications from you. Possible values are: ALL, the user has opted out and doesn't want to receive any
         * messages or push notifications; and, NONE, the user hasn't opted out and wants to receive all messages and
         * push notifications.
         * </p>
         * 
         * @param optOut
         *        Specifies whether the user who's associated with the endpoint has opted out of receiving messages and
         *        push notifications from you. Possible values are: ALL, the user has opted out and doesn't want to
         *        receive any messages or push notifications; and, NONE, the user hasn't opted out and wants to receive
         *        all messages and push notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optOut(String optOut);

        /**
         * <p>
         * A unique identifier that's generated each time the endpoint is updated.
         * </p>
         * 
         * @param requestId
         *        A unique identifier that's generated each time the endpoint is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated
         * with the endpoint.
         * </p>
         * 
         * @param user
         *        One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's
         *        associated with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(EndpointUser user);

        /**
         * <p>
         * One or more custom user attributes that your app reports to Amazon Pinpoint for the user who's associated
         * with the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointUser.Builder} avoiding the need
         * to create one manually via {@link EndpointUser#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointUser.Builder#build()} is called immediately and its
         * result is passed to {@link #user(EndpointUser)}.
         * 
         * @param user
         *        a consumer that will call methods on {@link EndpointUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #user(EndpointUser)
         */
        default Builder user(Consumer<EndpointUser.Builder> user) {
            return user(EndpointUser.builder().applyMutation(user).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private Map<String, List<String>> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String channelType;

        private EndpointDemographic demographic;

        private String effectiveDate;

        private String endpointStatus;

        private EndpointLocation location;

        private Map<String, Double> metrics = DefaultSdkAutoConstructMap.getInstance();

        private String optOut;

        private String requestId;

        private EndpointUser user;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicEndpoint model) {
            address(model.address);
            attributes(model.attributes);
            channelType(model.channelType);
            demographic(model.demographic);
            effectiveDate(model.effectiveDate);
            endpointStatus(model.endpointStatus);
            location(model.location);
            metrics(model.metrics);
            optOut(model.optOut);
            requestId(model.requestId);
            user(model.user);
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, ? extends Collection<String>> attributes) {
            this.attributes = MapOfListOf__stringCopier.copy(attributes);
            return this;
        }

        public final String getChannelType() {
            return channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final EndpointDemographic.Builder getDemographic() {
            return demographic != null ? demographic.toBuilder() : null;
        }

        public final void setDemographic(EndpointDemographic.BuilderImpl demographic) {
            this.demographic = demographic != null ? demographic.build() : null;
        }

        @Override
        public final Builder demographic(EndpointDemographic demographic) {
            this.demographic = demographic;
            return this;
        }

        public final String getEffectiveDate() {
            return effectiveDate;
        }

        public final void setEffectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        public final EndpointLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(EndpointLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(EndpointLocation location) {
            this.location = location;
            return this;
        }

        public final Map<String, Double> getMetrics() {
            if (metrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
            return this;
        }

        public final String getOptOut() {
            return optOut;
        }

        public final void setOptOut(String optOut) {
            this.optOut = optOut;
        }

        @Override
        public final Builder optOut(String optOut) {
            this.optOut = optOut;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final EndpointUser.Builder getUser() {
            return user != null ? user.toBuilder() : null;
        }

        public final void setUser(EndpointUser.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(EndpointUser user) {
            this.user = user;
            return this;
        }

        @Override
        public PublicEndpoint build() {
            return new PublicEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
