/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the results of a query that retrieved the data for a standard engagement metric that applies to a journey,
 * and provides information about that query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyDateRangeKpiResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyDateRangeKpiResponse.Builder, JourneyDateRangeKpiResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(JourneyDateRangeKpiResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(JourneyDateRangeKpiResponse::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JourneyId").getter(getter(JourneyDateRangeKpiResponse::journeyId)).setter(setter(Builder::journeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyId").build()).build();

    private static final SdkField<String> KPI_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KpiName").getter(getter(JourneyDateRangeKpiResponse::kpiName)).setter(setter(Builder::kpiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KpiName").build()).build();

    private static final SdkField<BaseKpiResult> KPI_RESULT_FIELD = SdkField.<BaseKpiResult> builder(MarshallingType.SDK_POJO)
            .memberName("KpiResult").getter(getter(JourneyDateRangeKpiResponse::kpiResult)).setter(setter(Builder::kpiResult))
            .constructor(BaseKpiResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KpiResult").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(JourneyDateRangeKpiResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(JourneyDateRangeKpiResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            END_TIME_FIELD, JOURNEY_ID_FIELD, KPI_NAME_FIELD, KPI_RESULT_FIELD, NEXT_TOKEN_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final Instant endTime;

    private final String journeyId;

    private final String kpiName;

    private final BaseKpiResult kpiResult;

    private final String nextToken;

    private final Instant startTime;

    private JourneyDateRangeKpiResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.endTime = builder.endTime;
        this.journeyId = builder.journeyId;
        this.kpiName = builder.kpiName;
        this.kpiResult = builder.kpiResult;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The unique identifier for the application that the metric applies to.
     * </p>
     * 
     * @return The unique identifier for the application that the metric applies to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The last date and time of the date range that was used to filter the query results, in extended ISO 8601 format.
     * The date range is inclusive.
     * </p>
     * 
     * @return The last date and time of the date range that was used to filter the query results, in extended ISO 8601
     *         format. The date range is inclusive.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The unique identifier for the journey that the metric applies to.
     * </p>
     * 
     * @return The unique identifier for the journey that the metric applies to.
     */
    public final String journeyId() {
        return journeyId;
    }

    /**
     * <p>
     * The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, that the data was retrieved
     * for. This value describes the associated metric and consists of two or more terms, which are comprised of
     * lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see the <a
     * href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint
     * Developer Guide</a>.
     * </p>
     * 
     * @return The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, that the data was
     *         retrieved for. This value describes the associated metric and consists of two or more terms, which are
     *         comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see
     *         the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">
     *         Amazon Pinpoint Developer Guide</a>.
     */
    public final String kpiName() {
        return kpiName;
    }

    /**
     * <p>
     * An array of objects that contains the results of the query. Each object contains the value for the metric and
     * metadata about that value.
     * </p>
     * 
     * @return An array of objects that contains the results of the query. Each object contains the value for the metric
     *         and metadata about that value.
     */
    public final BaseKpiResult kpiResult() {
        return kpiResult;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null for the Journey Engagement Metrics resource because the resource returns all results in a single page.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null for the Journey Engagement Metrics resource because the resource returns all results in a
     *         single page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The first date and time of the date range that was used to filter the query results, in extended ISO 8601 format.
     * The date range is inclusive.
     * </p>
     * 
     * @return The first date and time of the date range that was used to filter the query results, in extended ISO 8601
     *         format. The date range is inclusive.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(kpiName());
        hashCode = 31 * hashCode + Objects.hashCode(kpiResult());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyDateRangeKpiResponse)) {
            return false;
        }
        JourneyDateRangeKpiResponse other = (JourneyDateRangeKpiResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(journeyId(), other.journeyId()) && Objects.equals(kpiName(), other.kpiName())
                && Objects.equals(kpiResult(), other.kpiResult()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneyDateRangeKpiResponse").add("ApplicationId", applicationId()).add("EndTime", endTime())
                .add("JourneyId", journeyId()).add("KpiName", kpiName()).add("KpiResult", kpiResult())
                .add("NextToken", nextToken()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "JourneyId":
            return Optional.ofNullable(clazz.cast(journeyId()));
        case "KpiName":
            return Optional.ofNullable(clazz.cast(kpiName()));
        case "KpiResult":
            return Optional.ofNullable(clazz.cast(kpiResult()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyDateRangeKpiResponse, T> g) {
        return obj -> g.apply((JourneyDateRangeKpiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyDateRangeKpiResponse> {
        /**
         * <p>
         * The unique identifier for the application that the metric applies to.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the metric applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The last date and time of the date range that was used to filter the query results, in extended ISO 8601
         * format. The date range is inclusive.
         * </p>
         * 
         * @param endTime
         *        The last date and time of the date range that was used to filter the query results, in extended ISO
         *        8601 format. The date range is inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The unique identifier for the journey that the metric applies to.
         * </p>
         * 
         * @param journeyId
         *        The unique identifier for the journey that the metric applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyId(String journeyId);

        /**
         * <p>
         * The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, that the data was
         * retrieved for. This value describes the associated metric and consists of two or more terms, which are
         * comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see the
         * <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon
         * Pinpoint Developer Guide</a>.
         * </p>
         * 
         * @param kpiName
         *        The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, that the data
         *        was retrieved for. This value describes the associated metric and consists of two or more terms, which
         *        are comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible
         *        values, see the <a
         *        href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html"
         *        >Amazon Pinpoint Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kpiName(String kpiName);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the value for the metric and
         * metadata about that value.
         * </p>
         * 
         * @param kpiResult
         *        An array of objects that contains the results of the query. Each object contains the value for the
         *        metric and metadata about that value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kpiResult(BaseKpiResult kpiResult);

        /**
         * <p>
         * An array of objects that contains the results of the query. Each object contains the value for the metric and
         * metadata about that value.
         * </p>
         * This is a convenience method that creates an instance of the {@link BaseKpiResult.Builder} avoiding the need
         * to create one manually via {@link BaseKpiResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link BaseKpiResult.Builder#build()} is called immediately and its
         * result is passed to {@link #kpiResult(BaseKpiResult)}.
         * 
         * @param kpiResult
         *        a consumer that will call methods on {@link BaseKpiResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kpiResult(BaseKpiResult)
         */
        default Builder kpiResult(Consumer<BaseKpiResult.Builder> kpiResult) {
            return kpiResult(BaseKpiResult.builder().applyMutation(kpiResult).build());
        }

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null for the Journey Engagement Metrics resource because the resource returns all results in a single
         * page.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null for the Journey Engagement Metrics resource because the resource returns all
         *        results in a single page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The first date and time of the date range that was used to filter the query results, in extended ISO 8601
         * format. The date range is inclusive.
         * </p>
         * 
         * @param startTime
         *        The first date and time of the date range that was used to filter the query results, in extended ISO
         *        8601 format. The date range is inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private Instant endTime;

        private String journeyId;

        private String kpiName;

        private BaseKpiResult kpiResult;

        private String nextToken;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyDateRangeKpiResponse model) {
            applicationId(model.applicationId);
            endTime(model.endTime);
            journeyId(model.journeyId);
            kpiName(model.kpiName);
            kpiResult(model.kpiResult);
            nextToken(model.nextToken);
            startTime(model.startTime);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getJourneyId() {
            return journeyId;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final String getKpiName() {
            return kpiName;
        }

        public final void setKpiName(String kpiName) {
            this.kpiName = kpiName;
        }

        @Override
        public final Builder kpiName(String kpiName) {
            this.kpiName = kpiName;
            return this;
        }

        public final BaseKpiResult.Builder getKpiResult() {
            return kpiResult != null ? kpiResult.toBuilder() : null;
        }

        public final void setKpiResult(BaseKpiResult.BuilderImpl kpiResult) {
            this.kpiResult = kpiResult != null ? kpiResult.build() : null;
        }

        @Override
        public final Builder kpiResult(BaseKpiResult kpiResult) {
            this.kpiResult = kpiResult;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public JourneyDateRangeKpiResponse build() {
            return new JourneyDateRangeKpiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
