/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a condition to evaluate for an activity path in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiConditionalBranch implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiConditionalBranch.Builder, MultiConditionalBranch> {
    private static final SdkField<SimpleCondition> CONDITION_FIELD = SdkField.<SimpleCondition> builder(MarshallingType.SDK_POJO)
            .memberName("Condition").getter(getter(MultiConditionalBranch::condition)).setter(setter(Builder::condition))
            .constructor(SimpleCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextActivity").getter(getter(MultiConditionalBranch::nextActivity))
            .setter(setter(Builder::nextActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD,
            NEXT_ACTIVITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final SimpleCondition condition;

    private final String nextActivity;

    private MultiConditionalBranch(BuilderImpl builder) {
        this.condition = builder.condition;
        this.nextActivity = builder.nextActivity;
    }

    /**
     * <p>
     * The condition to evaluate for the activity path.
     * </p>
     * 
     * @return The condition to evaluate for the activity path.
     */
    public final SimpleCondition condition() {
        return condition;
    }

    /**
     * <p>
     * The unique identifier for the next activity to perform, after completing the activity for the path.
     * </p>
     * 
     * @return The unique identifier for the next activity to perform, after completing the activity for the path.
     */
    public final String nextActivity() {
        return nextActivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(nextActivity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiConditionalBranch)) {
            return false;
        }
        MultiConditionalBranch other = (MultiConditionalBranch) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(nextActivity(), other.nextActivity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiConditionalBranch").add("Condition", condition()).add("NextActivity", nextActivity())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "NextActivity":
            return Optional.ofNullable(clazz.cast(nextActivity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiConditionalBranch, T> g) {
        return obj -> g.apply((MultiConditionalBranch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiConditionalBranch> {
        /**
         * <p>
         * The condition to evaluate for the activity path.
         * </p>
         * 
         * @param condition
         *        The condition to evaluate for the activity path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(SimpleCondition condition);

        /**
         * <p>
         * The condition to evaluate for the activity path.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimpleCondition.Builder} avoiding the
         * need to create one manually via {@link SimpleCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #condition(SimpleCondition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link SimpleCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(SimpleCondition)
         */
        default Builder condition(Consumer<SimpleCondition.Builder> condition) {
            return condition(SimpleCondition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * The unique identifier for the next activity to perform, after completing the activity for the path.
         * </p>
         * 
         * @param nextActivity
         *        The unique identifier for the next activity to perform, after completing the activity for the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextActivity(String nextActivity);
    }

    static final class BuilderImpl implements Builder {
        private SimpleCondition condition;

        private String nextActivity;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiConditionalBranch model) {
            condition(model.condition);
            nextActivity(model.nextActivity);
        }

        public final SimpleCondition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(SimpleCondition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(SimpleCondition condition) {
            this.condition = condition;
            return this;
        }

        public final String getNextActivity() {
            return nextActivity;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        @Override
        public MultiConditionalBranch build() {
            return new MultiConditionalBranch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
