/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVoiceTemplateRequest extends PinpointRequest implements
        ToCopyableBuilder<CreateVoiceTemplateRequest.Builder, CreateVoiceTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(CreateVoiceTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()).build();

    private static final SdkField<VoiceTemplateRequest> VOICE_TEMPLATE_REQUEST_FIELD = SdkField
            .<VoiceTemplateRequest> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceTemplateRequest")
            .getter(getter(CreateVoiceTemplateRequest::voiceTemplateRequest))
            .setter(setter(Builder::voiceTemplateRequest))
            .constructor(VoiceTemplateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceTemplateRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            VOICE_TEMPLATE_REQUEST_FIELD));

    private final String templateName;

    private final VoiceTemplateRequest voiceTemplateRequest;

    private CreateVoiceTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.voiceTemplateRequest = builder.voiceTemplateRequest;
    }

    /**
     * <p>
     * The name of the message template. A template name must start with an alphanumeric character and can contain a
     * maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-).
     * Template names are case sensitive.
     * </p>
     * 
     * @return The name of the message template. A template name must start with an alphanumeric character and can
     *         contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or
     *         hyphens (-). Template names are case sensitive.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * Returns the value of the VoiceTemplateRequest property for this object.
     * 
     * @return The value of the VoiceTemplateRequest property for this object.
     */
    public final VoiceTemplateRequest voiceTemplateRequest() {
        return voiceTemplateRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(voiceTemplateRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVoiceTemplateRequest)) {
            return false;
        }
        CreateVoiceTemplateRequest other = (CreateVoiceTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName())
                && Objects.equals(voiceTemplateRequest(), other.voiceTemplateRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVoiceTemplateRequest").add("TemplateName", templateName())
                .add("VoiceTemplateRequest", voiceTemplateRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "VoiceTemplateRequest":
            return Optional.ofNullable(clazz.cast(voiceTemplateRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVoiceTemplateRequest, T> g) {
        return obj -> g.apply((CreateVoiceTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVoiceTemplateRequest> {
        /**
         * <p>
         * The name of the message template. A template name must start with an alphanumeric character and can contain a
         * maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-).
         * Template names are case sensitive.
         * </p>
         * 
         * @param templateName
         *        The name of the message template. A template name must start with an alphanumeric character and can
         *        contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_),
         *        or hyphens (-). Template names are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * Sets the value of the VoiceTemplateRequest property for this object.
         *
         * @param voiceTemplateRequest
         *        The new value for the VoiceTemplateRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceTemplateRequest(VoiceTemplateRequest voiceTemplateRequest);

        /**
         * Sets the value of the VoiceTemplateRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VoiceTemplateRequest.Builder} avoiding
         * the need to create one manually via {@link VoiceTemplateRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link VoiceTemplateRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #voiceTemplateRequest(VoiceTemplateRequest)}.
         * 
         * @param voiceTemplateRequest
         *        a consumer that will call methods on {@link VoiceTemplateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceTemplateRequest(VoiceTemplateRequest)
         */
        default Builder voiceTemplateRequest(Consumer<VoiceTemplateRequest.Builder> voiceTemplateRequest) {
            return voiceTemplateRequest(VoiceTemplateRequest.builder().applyMutation(voiceTemplateRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String templateName;

        private VoiceTemplateRequest voiceTemplateRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVoiceTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            voiceTemplateRequest(model.voiceTemplateRequest);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final VoiceTemplateRequest.Builder getVoiceTemplateRequest() {
            return voiceTemplateRequest != null ? voiceTemplateRequest.toBuilder() : null;
        }

        public final void setVoiceTemplateRequest(VoiceTemplateRequest.BuilderImpl voiceTemplateRequest) {
            this.voiceTemplateRequest = voiceTemplateRequest != null ? voiceTemplateRequest.build() : null;
        }

        @Override
        public final Builder voiceTemplateRequest(VoiceTemplateRequest voiceTemplateRequest) {
            this.voiceTemplateRequest = voiceTemplateRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVoiceTemplateRequest build() {
            return new CreateVoiceTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
