/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteUserEndpointsResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteUserEndpointsResponse.Builder, DeleteUserEndpointsResponse> {
    private static final SdkField<EndpointsResponse> ENDPOINTS_RESPONSE_FIELD = SdkField
            .<EndpointsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("EndpointsResponse")
            .getter(getter(DeleteUserEndpointsResponse::endpointsResponse))
            .setter(setter(Builder::endpointsResponse))
            .constructor(EndpointsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointsResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_RESPONSE_FIELD));

    private final EndpointsResponse endpointsResponse;

    private DeleteUserEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointsResponse = builder.endpointsResponse;
    }

    /**
     * Returns the value of the EndpointsResponse property for this object.
     * 
     * @return The value of the EndpointsResponse property for this object.
     */
    public final EndpointsResponse endpointsResponse() {
        return endpointsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointsResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserEndpointsResponse)) {
            return false;
        }
        DeleteUserEndpointsResponse other = (DeleteUserEndpointsResponse) obj;
        return Objects.equals(endpointsResponse(), other.endpointsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteUserEndpointsResponse").add("EndpointsResponse", endpointsResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointsResponse":
            return Optional.ofNullable(clazz.cast(endpointsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteUserEndpointsResponse, T> g) {
        return obj -> g.apply((DeleteUserEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteUserEndpointsResponse> {
        /**
         * Sets the value of the EndpointsResponse property for this object.
         *
         * @param endpointsResponse
         *        The new value for the EndpointsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointsResponse(EndpointsResponse endpointsResponse);

        /**
         * Sets the value of the EndpointsResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EndpointsResponse.Builder} avoiding the
         * need to create one manually via {@link EndpointsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointsResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointsResponse(EndpointsResponse)}.
         * 
         * @param endpointsResponse
         *        a consumer that will call methods on {@link EndpointsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointsResponse(EndpointsResponse)
         */
        default Builder endpointsResponse(Consumer<EndpointsResponse.Builder> endpointsResponse) {
            return endpointsResponse(EndpointsResponse.builder().applyMutation(endpointsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private EndpointsResponse endpointsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserEndpointsResponse model) {
            super(model);
            endpointsResponse(model.endpointsResponse);
        }

        public final EndpointsResponse.Builder getEndpointsResponse() {
            return endpointsResponse != null ? endpointsResponse.toBuilder() : null;
        }

        public final void setEndpointsResponse(EndpointsResponse.BuilderImpl endpointsResponse) {
            this.endpointsResponse = endpointsResponse != null ? endpointsResponse.build() : null;
        }

        @Override
        public final Builder endpointsResponse(EndpointsResponse endpointsResponse) {
            this.endpointsResponse = endpointsResponse;
            return this;
        }

        @Override
        public DeleteUserEndpointsResponse build() {
            return new DeleteUserEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
