/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Button Config for an in-app message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppMessageButton implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppMessageButton.Builder, InAppMessageButton> {
    private static final SdkField<OverrideButtonConfiguration> ANDROID_FIELD = SdkField
            .<OverrideButtonConfiguration> builder(MarshallingType.SDK_POJO).memberName("Android")
            .getter(getter(InAppMessageButton::android)).setter(setter(Builder::android))
            .constructor(OverrideButtonConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Android").build()).build();

    private static final SdkField<DefaultButtonConfiguration> DEFAULT_CONFIG_FIELD = SdkField
            .<DefaultButtonConfiguration> builder(MarshallingType.SDK_POJO).memberName("DefaultConfig")
            .getter(getter(InAppMessageButton::defaultConfig)).setter(setter(Builder::defaultConfig))
            .constructor(DefaultButtonConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultConfig").build()).build();

    private static final SdkField<OverrideButtonConfiguration> IOS_FIELD = SdkField
            .<OverrideButtonConfiguration> builder(MarshallingType.SDK_POJO).memberName("IOS")
            .getter(getter(InAppMessageButton::ios)).setter(setter(Builder::ios))
            .constructor(OverrideButtonConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IOS").build()).build();

    private static final SdkField<OverrideButtonConfiguration> WEB_FIELD = SdkField
            .<OverrideButtonConfiguration> builder(MarshallingType.SDK_POJO).memberName("Web")
            .getter(getter(InAppMessageButton::web)).setter(setter(Builder::web))
            .constructor(OverrideButtonConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Web").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANDROID_FIELD,
            DEFAULT_CONFIG_FIELD, IOS_FIELD, WEB_FIELD));

    private static final long serialVersionUID = 1L;

    private final OverrideButtonConfiguration android;

    private final DefaultButtonConfiguration defaultConfig;

    private final OverrideButtonConfiguration ios;

    private final OverrideButtonConfiguration web;

    private InAppMessageButton(BuilderImpl builder) {
        this.android = builder.android;
        this.defaultConfig = builder.defaultConfig;
        this.ios = builder.ios;
        this.web = builder.web;
    }

    /**
     * <p>
     * Default button content.
     * </p>
     * 
     * @return Default button content.
     */
    public final OverrideButtonConfiguration android() {
        return android;
    }

    /**
     * <p>
     * Default button content.
     * </p>
     * 
     * @return Default button content.
     */
    public final DefaultButtonConfiguration defaultConfig() {
        return defaultConfig;
    }

    /**
     * <p>
     * Default button content.
     * </p>
     * 
     * @return Default button content.
     */
    public final OverrideButtonConfiguration ios() {
        return ios;
    }

    /**
     * <p>
     * Default button content.
     * </p>
     * 
     * @return Default button content.
     */
    public final OverrideButtonConfiguration web() {
        return web;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(android());
        hashCode = 31 * hashCode + Objects.hashCode(defaultConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ios());
        hashCode = 31 * hashCode + Objects.hashCode(web());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageButton)) {
            return false;
        }
        InAppMessageButton other = (InAppMessageButton) obj;
        return Objects.equals(android(), other.android()) && Objects.equals(defaultConfig(), other.defaultConfig())
                && Objects.equals(ios(), other.ios()) && Objects.equals(web(), other.web());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppMessageButton").add("Android", android()).add("DefaultConfig", defaultConfig())
                .add("IOS", ios()).add("Web", web()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Android":
            return Optional.ofNullable(clazz.cast(android()));
        case "DefaultConfig":
            return Optional.ofNullable(clazz.cast(defaultConfig()));
        case "IOS":
            return Optional.ofNullable(clazz.cast(ios()));
        case "Web":
            return Optional.ofNullable(clazz.cast(web()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageButton, T> g) {
        return obj -> g.apply((InAppMessageButton) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppMessageButton> {
        /**
         * <p>
         * Default button content.
         * </p>
         * 
         * @param android
         *        Default button content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder android(OverrideButtonConfiguration android);

        /**
         * <p>
         * Default button content.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverrideButtonConfiguration.Builder}
         * avoiding the need to create one manually via {@link OverrideButtonConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OverrideButtonConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #android(OverrideButtonConfiguration)}.
         * 
         * @param android
         *        a consumer that will call methods on {@link OverrideButtonConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #android(OverrideButtonConfiguration)
         */
        default Builder android(Consumer<OverrideButtonConfiguration.Builder> android) {
            return android(OverrideButtonConfiguration.builder().applyMutation(android).build());
        }

        /**
         * <p>
         * Default button content.
         * </p>
         * 
         * @param defaultConfig
         *        Default button content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultConfig(DefaultButtonConfiguration defaultConfig);

        /**
         * <p>
         * Default button content.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultButtonConfiguration.Builder}
         * avoiding the need to create one manually via {@link DefaultButtonConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefaultButtonConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultConfig(DefaultButtonConfiguration)}.
         * 
         * @param defaultConfig
         *        a consumer that will call methods on {@link DefaultButtonConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultConfig(DefaultButtonConfiguration)
         */
        default Builder defaultConfig(Consumer<DefaultButtonConfiguration.Builder> defaultConfig) {
            return defaultConfig(DefaultButtonConfiguration.builder().applyMutation(defaultConfig).build());
        }

        /**
         * <p>
         * Default button content.
         * </p>
         * 
         * @param ios
         *        Default button content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ios(OverrideButtonConfiguration ios);

        /**
         * <p>
         * Default button content.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverrideButtonConfiguration.Builder}
         * avoiding the need to create one manually via {@link OverrideButtonConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OverrideButtonConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ios(OverrideButtonConfiguration)}.
         * 
         * @param ios
         *        a consumer that will call methods on {@link OverrideButtonConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ios(OverrideButtonConfiguration)
         */
        default Builder ios(Consumer<OverrideButtonConfiguration.Builder> ios) {
            return ios(OverrideButtonConfiguration.builder().applyMutation(ios).build());
        }

        /**
         * <p>
         * Default button content.
         * </p>
         * 
         * @param web
         *        Default button content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder web(OverrideButtonConfiguration web);

        /**
         * <p>
         * Default button content.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverrideButtonConfiguration.Builder}
         * avoiding the need to create one manually via {@link OverrideButtonConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link OverrideButtonConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #web(OverrideButtonConfiguration)}.
         * 
         * @param web
         *        a consumer that will call methods on {@link OverrideButtonConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #web(OverrideButtonConfiguration)
         */
        default Builder web(Consumer<OverrideButtonConfiguration.Builder> web) {
            return web(OverrideButtonConfiguration.builder().applyMutation(web).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OverrideButtonConfiguration android;

        private DefaultButtonConfiguration defaultConfig;

        private OverrideButtonConfiguration ios;

        private OverrideButtonConfiguration web;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageButton model) {
            android(model.android);
            defaultConfig(model.defaultConfig);
            ios(model.ios);
            web(model.web);
        }

        public final OverrideButtonConfiguration.Builder getAndroid() {
            return android != null ? android.toBuilder() : null;
        }

        public final void setAndroid(OverrideButtonConfiguration.BuilderImpl android) {
            this.android = android != null ? android.build() : null;
        }

        @Override
        public final Builder android(OverrideButtonConfiguration android) {
            this.android = android;
            return this;
        }

        public final DefaultButtonConfiguration.Builder getDefaultConfig() {
            return defaultConfig != null ? defaultConfig.toBuilder() : null;
        }

        public final void setDefaultConfig(DefaultButtonConfiguration.BuilderImpl defaultConfig) {
            this.defaultConfig = defaultConfig != null ? defaultConfig.build() : null;
        }

        @Override
        public final Builder defaultConfig(DefaultButtonConfiguration defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public final OverrideButtonConfiguration.Builder getIos() {
            return ios != null ? ios.toBuilder() : null;
        }

        public final void setIos(OverrideButtonConfiguration.BuilderImpl ios) {
            this.ios = ios != null ? ios.build() : null;
        }

        @Override
        public final Builder ios(OverrideButtonConfiguration ios) {
            this.ios = ios;
            return this;
        }

        public final OverrideButtonConfiguration.Builder getWeb() {
            return web != null ? web.toBuilder() : null;
        }

        public final void setWeb(OverrideButtonConfiguration.BuilderImpl web) {
            this.web = web != null ? web.build() : null;
        }

        @Override
        public final Builder web(OverrideButtonConfiguration web) {
            this.web = web;
            return this;
        }

        @Override
        public InAppMessageButton build() {
            return new InAppMessageButton(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
