/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status, configuration, and other settings for a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignResponse.Builder, CampaignResponse> {
    private static final SdkField<List<TreatmentResource>> ADDITIONAL_TREATMENTS_FIELD = SdkField
            .<List<TreatmentResource>> builder(MarshallingType.LIST)
            .memberName("AdditionalTreatments")
            .getter(getter(CampaignResponse::additionalTreatments))
            .setter(setter(Builder::additionalTreatments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalTreatments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TreatmentResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TreatmentResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CampaignResponse::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CampaignResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(CampaignResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<CustomDeliveryConfiguration> CUSTOM_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<CustomDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CustomDeliveryConfiguration")
            .getter(getter(CampaignResponse::customDeliveryConfiguration))
            .setter(setter(Builder::customDeliveryConfiguration))
            .constructor(CustomDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDeliveryConfiguration")
                    .build()).build();

    private static final SdkField<CampaignState> DEFAULT_STATE_FIELD = SdkField.<CampaignState> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultState").getter(getter(CampaignResponse::defaultState)).setter(setter(Builder::defaultState))
            .constructor(CampaignState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultState").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CampaignResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> HOLDOUT_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HoldoutPercent").getter(getter(CampaignResponse::holdoutPercent))
            .setter(setter(Builder::holdoutPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoldoutPercent").build()).build();

    private static final SdkField<CampaignHook> HOOK_FIELD = SdkField.<CampaignHook> builder(MarshallingType.SDK_POJO)
            .memberName("Hook").getter(getter(CampaignResponse::hook)).setter(setter(Builder::hook))
            .constructor(CampaignHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hook").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CampaignResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Boolean> IS_PAUSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPaused").getter(getter(CampaignResponse::isPaused)).setter(setter(Builder::isPaused))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPaused").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(CampaignResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.<CampaignLimits> builder(MarshallingType.SDK_POJO)
            .memberName("Limits").getter(getter(CampaignResponse::limits)).setter(setter(Builder::limits))
            .constructor(CampaignLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<MessageConfiguration> builder(MarshallingType.SDK_POJO).memberName("MessageConfiguration")
            .getter(getter(CampaignResponse::messageConfiguration)).setter(setter(Builder::messageConfiguration))
            .constructor(MessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CampaignResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(CampaignResponse::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentId").getter(getter(CampaignResponse::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentVersion").getter(getter(CampaignResponse::segmentVersion))
            .setter(setter(Builder::segmentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()).build();

    private static final SdkField<CampaignState> STATE_FIELD = SdkField.<CampaignState> builder(MarshallingType.SDK_POJO)
            .memberName("State").getter(getter(CampaignResponse::state)).setter(setter(Builder::state))
            .constructor(CampaignState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CampaignResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("TemplateConfiguration")
            .getter(getter(CampaignResponse::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(TemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build())
            .build();

    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentDescription").getter(getter(CampaignResponse::treatmentDescription))
            .setter(setter(Builder::treatmentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build())
            .build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentName").getter(getter(CampaignResponse::treatmentName)).setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(CampaignResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(CampaignResponse::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TREATMENTS_FIELD,
            APPLICATION_ID_FIELD, ARN_FIELD, CREATION_DATE_FIELD, CUSTOM_DELIVERY_CONFIGURATION_FIELD, DEFAULT_STATE_FIELD,
            DESCRIPTION_FIELD, HOLDOUT_PERCENT_FIELD, HOOK_FIELD, ID_FIELD, IS_PAUSED_FIELD, LAST_MODIFIED_DATE_FIELD,
            LIMITS_FIELD, MESSAGE_CONFIGURATION_FIELD, NAME_FIELD, SCHEDULE_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD,
            STATE_FIELD, TAGS_FIELD, TEMPLATE_CONFIGURATION_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD,
            VERSION_FIELD, PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TreatmentResource> additionalTreatments;

    private final String applicationId;

    private final String arn;

    private final String creationDate;

    private final CustomDeliveryConfiguration customDeliveryConfiguration;

    private final CampaignState defaultState;

    private final String description;

    private final Integer holdoutPercent;

    private final CampaignHook hook;

    private final String id;

    private final Boolean isPaused;

    private final String lastModifiedDate;

    private final CampaignLimits limits;

    private final MessageConfiguration messageConfiguration;

    private final String name;

    private final Schedule schedule;

    private final String segmentId;

    private final Integer segmentVersion;

    private final CampaignState state;

    private final Map<String, String> tags;

    private final TemplateConfiguration templateConfiguration;

    private final String treatmentDescription;

    private final String treatmentName;

    private final Integer version;

    private final Integer priority;

    private CampaignResponse(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.applicationId = builder.applicationId;
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.customDeliveryConfiguration = builder.customDeliveryConfiguration;
        this.defaultState = builder.defaultState;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.hook = builder.hook;
        this.id = builder.id;
        this.isPaused = builder.isPaused;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.state = builder.state;
        this.tags = builder.tags;
        this.templateConfiguration = builder.templateConfiguration;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
        this.version = builder.version;
        this.priority = builder.priority;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalTreatments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalTreatments() {
        return additionalTreatments != null && !(additionalTreatments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of responses, one for each treatment that you defined for the campaign, in addition to the default
     * treatment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalTreatments} method.
     * </p>
     * 
     * @return An array of responses, one for each treatment that you defined for the campaign, in addition to the
     *         default treatment.
     */
    public final List<TreatmentResource> additionalTreatments() {
        return additionalTreatments;
    }

    /**
     * <p>
     * The unique identifier for the application that the campaign applies to.
     * </p>
     * 
     * @return The unique identifier for the application that the campaign applies to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the campaign was created.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the campaign was created.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The delivery configuration settings for sending the campaign through a custom channel.
     * </p>
     * 
     * @return The delivery configuration settings for sending the campaign through a custom channel.
     */
    public final CustomDeliveryConfiguration customDeliveryConfiguration() {
        return customDeliveryConfiguration;
    }

    /**
     * <p>
     * The current status of the campaign's default treatment. This value exists only for campaigns that have more than
     * one treatment.
     * </p>
     * 
     * @return The current status of the campaign's default treatment. This value exists only for campaigns that have
     *         more than one treatment.
     */
    public final CampaignState defaultState() {
        return defaultState;
    }

    /**
     * <p>
     * The custom description of the campaign.
     * </p>
     * 
     * @return The custom description of the campaign.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     * </p>
     * 
     * @return The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     */
    public final Integer holdoutPercent() {
        return holdoutPercent;
    }

    /**
     * <p>
     * The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to
     * customize the segment that's used by the campaign.
     * </p>
     * 
     * @return The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to
     *         customize the segment that's used by the campaign.
     */
    public final CampaignHook hook() {
        return hook;
    }

    /**
     * <p>
     * The unique identifier for the campaign.
     * </p>
     * 
     * @return The unique identifier for the campaign.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this
     * value to false.
     * </p>
     * 
     * @return Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing
     *         this value to false.
     */
    public final Boolean isPaused() {
        return isPaused;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the campaign was last modified.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the campaign was last modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The messaging limits for the campaign.
     * </p>
     * 
     * @return The messaging limits for the campaign.
     */
    public final CampaignLimits limits() {
        return limits;
    }

    /**
     * <p>
     * The message configuration settings for the campaign.
     * </p>
     * 
     * @return The message configuration settings for the campaign.
     */
    public final MessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * <p>
     * The name of the campaign.
     * </p>
     * 
     * @return The name of the campaign.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The schedule settings for the campaign.
     * </p>
     * 
     * @return The schedule settings for the campaign.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The unique identifier for the segment that's associated with the campaign.
     * </p>
     * 
     * @return The unique identifier for the segment that's associated with the campaign.
     */
    public final String segmentId() {
        return segmentId;
    }

    /**
     * <p>
     * The version number of the segment that's associated with the campaign.
     * </p>
     * 
     * @return The version number of the segment that's associated with the campaign.
     */
    public final Integer segmentVersion() {
        return segmentVersion;
    }

    /**
     * <p>
     * The current status of the campaign.
     * </p>
     * 
     * @return The current status of the campaign.
     */
    public final CampaignState state() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each
     * tag consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign.
     *         Each tag consists of a required tag key and an associated tag value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The message template that’s used for the campaign.
     * </p>
     * 
     * @return The message template that’s used for the campaign.
     */
    public final TemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * The custom description of the default treatment for the campaign.
     * </p>
     * 
     * @return The custom description of the default treatment for the campaign.
     */
    public final String treatmentDescription() {
        return treatmentDescription;
    }

    /**
     * <p>
     * The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
     * <i>treatment</i> is a variation of a campaign that's used for A/B testing.
     * </p>
     * 
     * @return The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
     *         <i>treatment</i> is a variation of a campaign that's used for A/B testing.
     */
    public final String treatmentName() {
        return treatmentName;
    }

    /**
     * <p>
     * The version number of the campaign.
     * </p>
     * 
     * @return The version number of the campaign.
     */
    public final Integer version() {
        return version;
    }

    /**
     * <p>
     * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are
     * multiple messages scheduled to be displayed at the same moment.
     * </p>
     * 
     * @return Defines the priority of the campaign, used to decide the order of messages displayed to user if there are
     *         multiple messages scheduled to be displayed at the same moment.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalTreatments() ? additionalTreatments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(customDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(defaultState());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(hook());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignResponse)) {
            return false;
        }
        CampaignResponse other = (CampaignResponse) obj;
        return hasAdditionalTreatments() == other.hasAdditionalTreatments()
                && Objects.equals(additionalTreatments(), other.additionalTreatments())
                && Objects.equals(applicationId(), other.applicationId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(customDeliveryConfiguration(), other.customDeliveryConfiguration())
                && Objects.equals(defaultState(), other.defaultState()) && Objects.equals(description(), other.description())
                && Objects.equals(holdoutPercent(), other.holdoutPercent()) && Objects.equals(hook(), other.hook())
                && Objects.equals(id(), other.id()) && Objects.equals(isPaused(), other.isPaused())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(limits(), other.limits())
                && Objects.equals(messageConfiguration(), other.messageConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(segmentId(), other.segmentId())
                && Objects.equals(segmentVersion(), other.segmentVersion()) && Objects.equals(state(), other.state())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(treatmentDescription(), other.treatmentDescription())
                && Objects.equals(treatmentName(), other.treatmentName()) && Objects.equals(version(), other.version())
                && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignResponse")
                .add("AdditionalTreatments", hasAdditionalTreatments() ? additionalTreatments() : null)
                .add("ApplicationId", applicationId()).add("Arn", arn()).add("CreationDate", creationDate())
                .add("CustomDeliveryConfiguration", customDeliveryConfiguration()).add("DefaultState", defaultState())
                .add("Description", description()).add("HoldoutPercent", holdoutPercent()).add("Hook", hook()).add("Id", id())
                .add("IsPaused", isPaused()).add("LastModifiedDate", lastModifiedDate()).add("Limits", limits())
                .add("MessageConfiguration", messageConfiguration()).add("Name", name()).add("Schedule", schedule())
                .add("SegmentId", segmentId()).add("SegmentVersion", segmentVersion()).add("State", state())
                .add("Tags", hasTags() ? tags() : null).add("TemplateConfiguration", templateConfiguration())
                .add("TreatmentDescription", treatmentDescription()).add("TreatmentName", treatmentName())
                .add("Version", version()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalTreatments":
            return Optional.ofNullable(clazz.cast(additionalTreatments()));
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CustomDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(customDeliveryConfiguration()));
        case "DefaultState":
            return Optional.ofNullable(clazz.cast(defaultState()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HoldoutPercent":
            return Optional.ofNullable(clazz.cast(holdoutPercent()));
        case "Hook":
            return Optional.ofNullable(clazz.cast(hook()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IsPaused":
            return Optional.ofNullable(clazz.cast(isPaused()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentVersion":
            return Optional.ofNullable(clazz.cast(segmentVersion()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "TreatmentDescription":
            return Optional.ofNullable(clazz.cast(treatmentDescription()));
        case "TreatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CampaignResponse, T> g) {
        return obj -> g.apply((CampaignResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignResponse> {
        /**
         * <p>
         * An array of responses, one for each treatment that you defined for the campaign, in addition to the default
         * treatment.
         * </p>
         * 
         * @param additionalTreatments
         *        An array of responses, one for each treatment that you defined for the campaign, in addition to the
         *        default treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(Collection<TreatmentResource> additionalTreatments);

        /**
         * <p>
         * An array of responses, one for each treatment that you defined for the campaign, in addition to the default
         * treatment.
         * </p>
         * 
         * @param additionalTreatments
         *        An array of responses, one for each treatment that you defined for the campaign, in addition to the
         *        default treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(TreatmentResource... additionalTreatments);

        /**
         * <p>
         * An array of responses, one for each treatment that you defined for the campaign, in addition to the default
         * treatment.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TreatmentResource>.Builder} avoiding
         * the need to create one manually via {@link List<TreatmentResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TreatmentResource>.Builder#build()} is called immediately
         * and its result is passed to {@link #additionalTreatments(List<TreatmentResource>)}.
         * 
         * @param additionalTreatments
         *        a consumer that will call methods on {@link List<TreatmentResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalTreatments(List<TreatmentResource>)
         */
        Builder additionalTreatments(Consumer<TreatmentResource.Builder>... additionalTreatments);

        /**
         * <p>
         * The unique identifier for the application that the campaign applies to.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the campaign applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date, in ISO 8601 format, when the campaign was created.
         * </p>
         * 
         * @param creationDate
         *        The date, in ISO 8601 format, when the campaign was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The delivery configuration settings for sending the campaign through a custom channel.
         * </p>
         * 
         * @param customDeliveryConfiguration
         *        The delivery configuration settings for sending the campaign through a custom channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration);

        /**
         * <p>
         * The delivery configuration settings for sending the campaign through a custom channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomDeliveryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #customDeliveryConfiguration(CustomDeliveryConfiguration)}.
         * 
         * @param customDeliveryConfiguration
         *        a consumer that will call methods on {@link CustomDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDeliveryConfiguration(CustomDeliveryConfiguration)
         */
        default Builder customDeliveryConfiguration(Consumer<CustomDeliveryConfiguration.Builder> customDeliveryConfiguration) {
            return customDeliveryConfiguration(CustomDeliveryConfiguration.builder().applyMutation(customDeliveryConfiguration)
                    .build());
        }

        /**
         * <p>
         * The current status of the campaign's default treatment. This value exists only for campaigns that have more
         * than one treatment.
         * </p>
         * 
         * @param defaultState
         *        The current status of the campaign's default treatment. This value exists only for campaigns that have
         *        more than one treatment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultState(CampaignState defaultState);

        /**
         * <p>
         * The current status of the campaign's default treatment. This value exists only for campaigns that have more
         * than one treatment.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignState.Builder} avoiding the need
         * to create one manually via {@link CampaignState#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignState.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultState(CampaignState)}.
         * 
         * @param defaultState
         *        a consumer that will call methods on {@link CampaignState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultState(CampaignState)
         */
        default Builder defaultState(Consumer<CampaignState.Builder> defaultState) {
            return defaultState(CampaignState.builder().applyMutation(defaultState).build());
        }

        /**
         * <p>
         * The custom description of the campaign.
         * </p>
         * 
         * @param description
         *        The custom description of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         * </p>
         * 
         * @param holdoutPercent
         *        The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder holdoutPercent(Integer holdoutPercent);

        /**
         * <p>
         * The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to
         * customize the segment that's used by the campaign.
         * </p>
         * 
         * @param hook
         *        The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook
         *        to customize the segment that's used by the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hook(CampaignHook hook);

        /**
         * <p>
         * The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to
         * customize the segment that's used by the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignHook.Builder} avoiding the need
         * to create one manually via {@link CampaignHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignHook.Builder#build()} is called immediately and its
         * result is passed to {@link #hook(CampaignHook)}.
         * 
         * @param hook
         *        a consumer that will call methods on {@link CampaignHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hook(CampaignHook)
         */
        default Builder hook(Consumer<CampaignHook.Builder> hook) {
            return hook(CampaignHook.builder().applyMutation(hook).build());
        }

        /**
         * <p>
         * The unique identifier for the campaign.
         * </p>
         * 
         * @param id
         *        The unique identifier for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by changing this
         * value to false.
         * </p>
         * 
         * @param isPaused
         *        Specifies whether the campaign is paused. A paused campaign doesn't run unless you resume it by
         *        changing this value to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPaused(Boolean isPaused);

        /**
         * <p>
         * The date, in ISO 8601 format, when the campaign was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date, in ISO 8601 format, when the campaign was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The messaging limits for the campaign.
         * </p>
         * 
         * @param limits
         *        The messaging limits for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(CampaignLimits limits);

        /**
         * <p>
         * The messaging limits for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignLimits.Builder} avoiding the need
         * to create one manually via {@link CampaignLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(CampaignLimits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link CampaignLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(CampaignLimits)
         */
        default Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return limits(CampaignLimits.builder().applyMutation(limits).build());
        }

        /**
         * <p>
         * The message configuration settings for the campaign.
         * </p>
         * 
         * @param messageConfiguration
         *        The message configuration settings for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(MessageConfiguration messageConfiguration);

        /**
         * <p>
         * The message configuration settings for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageConfiguration.Builder} avoiding
         * the need to create one manually via {@link MessageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #messageConfiguration(MessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link MessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(MessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(MessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * <p>
         * The name of the campaign.
         * </p>
         * 
         * @param name
         *        The name of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The schedule settings for the campaign.
         * </p>
         * 
         * @param schedule
         *        The schedule settings for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule settings for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The unique identifier for the segment that's associated with the campaign.
         * </p>
         * 
         * @param segmentId
         *        The unique identifier for the segment that's associated with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * <p>
         * The version number of the segment that's associated with the campaign.
         * </p>
         * 
         * @param segmentVersion
         *        The version number of the segment that's associated with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentVersion(Integer segmentVersion);

        /**
         * <p>
         * The current status of the campaign.
         * </p>
         * 
         * @param state
         *        The current status of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(CampaignState state);

        /**
         * <p>
         * The current status of the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignState.Builder} avoiding the need
         * to create one manually via {@link CampaignState#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(CampaignState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link CampaignState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(CampaignState)
         */
        default Builder state(Consumer<CampaignState.Builder> state) {
            return state(CampaignState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign.
         * Each tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that identifies the tags that are associated with the
         *        campaign. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The message template that’s used for the campaign.
         * </p>
         * 
         * @param templateConfiguration
         *        The message template that’s used for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(TemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The message template that’s used for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateConfiguration.Builder} avoiding
         * the need to create one manually via {@link TemplateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #templateConfiguration(TemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link TemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(TemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(TemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * The custom description of the default treatment for the campaign.
         * </p>
         * 
         * @param treatmentDescription
         *        The custom description of the default treatment for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentDescription(String treatmentDescription);

        /**
         * <p>
         * The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
         * <i>treatment</i> is a variation of a campaign that's used for A/B testing.
         * </p>
         * 
         * @param treatmentName
         *        The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
         *        <i>treatment</i> is a variation of a campaign that's used for A/B testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);

        /**
         * <p>
         * The version number of the campaign.
         * </p>
         * 
         * @param version
         *        The version number of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are
         * multiple messages scheduled to be displayed at the same moment.
         * </p>
         * 
         * @param priority
         *        Defines the priority of the campaign, used to decide the order of messages displayed to user if there
         *        are multiple messages scheduled to be displayed at the same moment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private List<TreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();

        private String applicationId;

        private String arn;

        private String creationDate;

        private CustomDeliveryConfiguration customDeliveryConfiguration;

        private CampaignState defaultState;

        private String description;

        private Integer holdoutPercent;

        private CampaignHook hook;

        private String id;

        private Boolean isPaused;

        private String lastModifiedDate;

        private CampaignLimits limits;

        private MessageConfiguration messageConfiguration;

        private String name;

        private Schedule schedule;

        private String segmentId;

        private Integer segmentVersion;

        private CampaignState state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private TemplateConfiguration templateConfiguration;

        private String treatmentDescription;

        private String treatmentName;

        private Integer version;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignResponse model) {
            additionalTreatments(model.additionalTreatments);
            applicationId(model.applicationId);
            arn(model.arn);
            creationDate(model.creationDate);
            customDeliveryConfiguration(model.customDeliveryConfiguration);
            defaultState(model.defaultState);
            description(model.description);
            holdoutPercent(model.holdoutPercent);
            hook(model.hook);
            id(model.id);
            isPaused(model.isPaused);
            lastModifiedDate(model.lastModifiedDate);
            limits(model.limits);
            messageConfiguration(model.messageConfiguration);
            name(model.name);
            schedule(model.schedule);
            segmentId(model.segmentId);
            segmentVersion(model.segmentVersion);
            state(model.state);
            tags(model.tags);
            templateConfiguration(model.templateConfiguration);
            treatmentDescription(model.treatmentDescription);
            treatmentName(model.treatmentName);
            version(model.version);
            priority(model.priority);
        }

        public final List<TreatmentResource.Builder> getAdditionalTreatments() {
            List<TreatmentResource.Builder> result = ListOfTreatmentResourceCopier.copyToBuilder(this.additionalTreatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalTreatments(Collection<TreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        @Override
        public final Builder additionalTreatments(Collection<TreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(TreatmentResource... additionalTreatments) {
            additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<TreatmentResource.Builder>... additionalTreatments) {
            additionalTreatments(Stream.of(additionalTreatments).map(c -> TreatmentResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final CustomDeliveryConfiguration.Builder getCustomDeliveryConfiguration() {
            return customDeliveryConfiguration != null ? customDeliveryConfiguration.toBuilder() : null;
        }

        public final void setCustomDeliveryConfiguration(CustomDeliveryConfiguration.BuilderImpl customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration != null ? customDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration;
            return this;
        }

        public final CampaignState.Builder getDefaultState() {
            return defaultState != null ? defaultState.toBuilder() : null;
        }

        public final void setDefaultState(CampaignState.BuilderImpl defaultState) {
            this.defaultState = defaultState != null ? defaultState.build() : null;
        }

        @Override
        public final Builder defaultState(CampaignState defaultState) {
            this.defaultState = defaultState;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getHoldoutPercent() {
            return holdoutPercent;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final CampaignHook.Builder getHook() {
            return hook != null ? hook.toBuilder() : null;
        }

        public final void setHook(CampaignHook.BuilderImpl hook) {
            this.hook = hook != null ? hook.build() : null;
        }

        @Override
        public final Builder hook(CampaignHook hook) {
            this.hook = hook;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIsPaused() {
            return isPaused;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final CampaignLimits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final Integer getSegmentVersion() {
            return segmentVersion;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final CampaignState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(CampaignState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTreatmentDescription() {
            return treatmentDescription;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public CampaignResponse build() {
            return new CampaignResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
