/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetExportJobResponse extends PinpointResponse implements
        ToCopyableBuilder<GetExportJobResponse.Builder, GetExportJobResponse> {
    private static final SdkField<ExportJobResponse> EXPORT_JOB_RESPONSE_FIELD = SdkField
            .<ExportJobResponse> builder(MarshallingType.SDK_POJO)
            .memberName("ExportJobResponse")
            .getter(getter(GetExportJobResponse::exportJobResponse))
            .setter(setter(Builder::exportJobResponse))
            .constructor(ExportJobResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_RESPONSE_FIELD));

    private final ExportJobResponse exportJobResponse;

    private GetExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobResponse = builder.exportJobResponse;
    }

    /**
     * Returns the value of the ExportJobResponse property for this object.
     * 
     * @return The value of the ExportJobResponse property for this object.
     */
    public final ExportJobResponse exportJobResponse() {
        return exportJobResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportJobResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportJobResponse)) {
            return false;
        }
        GetExportJobResponse other = (GetExportJobResponse) obj;
        return Objects.equals(exportJobResponse(), other.exportJobResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetExportJobResponse").add("ExportJobResponse", exportJobResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobResponse":
            return Optional.ofNullable(clazz.cast(exportJobResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExportJobResponse, T> g) {
        return obj -> g.apply((GetExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetExportJobResponse> {
        /**
         * Sets the value of the ExportJobResponse property for this object.
         *
         * @param exportJobResponse
         *        The new value for the ExportJobResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobResponse(ExportJobResponse exportJobResponse);

        /**
         * Sets the value of the ExportJobResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExportJobResponse.Builder} avoiding the
         * need to create one manually via {@link ExportJobResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportJobResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #exportJobResponse(ExportJobResponse)}.
         * 
         * @param exportJobResponse
         *        a consumer that will call methods on {@link ExportJobResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportJobResponse(ExportJobResponse)
         */
        default Builder exportJobResponse(Consumer<ExportJobResponse.Builder> exportJobResponse) {
            return exportJobResponse(ExportJobResponse.builder().applyMutation(exportJobResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ExportJobResponse exportJobResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportJobResponse model) {
            super(model);
            exportJobResponse(model.exportJobResponse);
        }

        public final ExportJobResponse.Builder getExportJobResponse() {
            return exportJobResponse != null ? exportJobResponse.toBuilder() : null;
        }

        public final void setExportJobResponse(ExportJobResponse.BuilderImpl exportJobResponse) {
            this.exportJobResponse = exportJobResponse != null ? exportJobResponse.build() : null;
        }

        @Override
        public final Builder exportJobResponse(ExportJobResponse exportJobResponse) {
            this.exportJobResponse = exportJobResponse;
            return this;
        }

        @Override
        public GetExportJobResponse build() {
            return new GetExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
