/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Schedule of the campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppCampaignSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppCampaignSchedule.Builder, InAppCampaignSchedule> {
    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDate").getter(getter(InAppCampaignSchedule::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<CampaignEventFilter> EVENT_FILTER_FIELD = SdkField
            .<CampaignEventFilter> builder(MarshallingType.SDK_POJO).memberName("EventFilter")
            .getter(getter(InAppCampaignSchedule::eventFilter)).setter(setter(Builder::eventFilter))
            .constructor(CampaignEventFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build()).build();

    private static final SdkField<QuietTime> QUIET_TIME_FIELD = SdkField.<QuietTime> builder(MarshallingType.SDK_POJO)
            .memberName("QuietTime").getter(getter(InAppCampaignSchedule::quietTime)).setter(setter(Builder::quietTime))
            .constructor(QuietTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuietTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_DATE_FIELD,
            EVENT_FILTER_FIELD, QUIET_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endDate;

    private final CampaignEventFilter eventFilter;

    private final QuietTime quietTime;

    private InAppCampaignSchedule(BuilderImpl builder) {
        this.endDate = builder.endDate;
        this.eventFilter = builder.eventFilter;
        this.quietTime = builder.quietTime;
    }

    /**
     * <p>
     * The scheduled time after which the in-app message should not be shown. Timestamp is in ISO 8601 format.
     * </p>
     * 
     * @return The scheduled time after which the in-app message should not be shown. Timestamp is in ISO 8601 format.
     */
    public final String endDate() {
        return endDate;
    }

    /**
     * <p>
     * The event filter the SDK has to use to show the in-app message in the application.
     * </p>
     * 
     * @return The event filter the SDK has to use to show the in-app message in the application.
     */
    public final CampaignEventFilter eventFilter() {
        return eventFilter;
    }

    /**
     * <p>
     * Time during which the in-app message should not be shown to the user.
     * </p>
     * 
     * @return Time during which the in-app message should not be shown to the user.
     */
    public final QuietTime quietTime() {
        return quietTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(eventFilter());
        hashCode = 31 * hashCode + Objects.hashCode(quietTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppCampaignSchedule)) {
            return false;
        }
        InAppCampaignSchedule other = (InAppCampaignSchedule) obj;
        return Objects.equals(endDate(), other.endDate()) && Objects.equals(eventFilter(), other.eventFilter())
                && Objects.equals(quietTime(), other.quietTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppCampaignSchedule").add("EndDate", endDate()).add("EventFilter", eventFilter())
                .add("QuietTime", quietTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "EventFilter":
            return Optional.ofNullable(clazz.cast(eventFilter()));
        case "QuietTime":
            return Optional.ofNullable(clazz.cast(quietTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppCampaignSchedule, T> g) {
        return obj -> g.apply((InAppCampaignSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppCampaignSchedule> {
        /**
         * <p>
         * The scheduled time after which the in-app message should not be shown. Timestamp is in ISO 8601 format.
         * </p>
         * 
         * @param endDate
         *        The scheduled time after which the in-app message should not be shown. Timestamp is in ISO 8601
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * <p>
         * The event filter the SDK has to use to show the in-app message in the application.
         * </p>
         * 
         * @param eventFilter
         *        The event filter the SDK has to use to show the in-app message in the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventFilter(CampaignEventFilter eventFilter);

        /**
         * <p>
         * The event filter the SDK has to use to show the in-app message in the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignEventFilter.Builder} avoiding the
         * need to create one manually via {@link CampaignEventFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignEventFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #eventFilter(CampaignEventFilter)}.
         * 
         * @param eventFilter
         *        a consumer that will call methods on {@link CampaignEventFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventFilter(CampaignEventFilter)
         */
        default Builder eventFilter(Consumer<CampaignEventFilter.Builder> eventFilter) {
            return eventFilter(CampaignEventFilter.builder().applyMutation(eventFilter).build());
        }

        /**
         * <p>
         * Time during which the in-app message should not be shown to the user.
         * </p>
         * 
         * @param quietTime
         *        Time during which the in-app message should not be shown to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quietTime(QuietTime quietTime);

        /**
         * <p>
         * Time during which the in-app message should not be shown to the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuietTime.Builder} avoiding the need to
         * create one manually via {@link QuietTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuietTime.Builder#build()} is called immediately and its result
         * is passed to {@link #quietTime(QuietTime)}.
         * 
         * @param quietTime
         *        a consumer that will call methods on {@link QuietTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quietTime(QuietTime)
         */
        default Builder quietTime(Consumer<QuietTime.Builder> quietTime) {
            return quietTime(QuietTime.builder().applyMutation(quietTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String endDate;

        private CampaignEventFilter eventFilter;

        private QuietTime quietTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppCampaignSchedule model) {
            endDate(model.endDate);
            eventFilter(model.eventFilter);
            quietTime(model.quietTime);
        }

        public final String getEndDate() {
            return endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final CampaignEventFilter.Builder getEventFilter() {
            return eventFilter != null ? eventFilter.toBuilder() : null;
        }

        public final void setEventFilter(CampaignEventFilter.BuilderImpl eventFilter) {
            this.eventFilter = eventFilter != null ? eventFilter.build() : null;
        }

        @Override
        public final Builder eventFilter(CampaignEventFilter eventFilter) {
            this.eventFilter = eventFilter;
            return this;
        }

        public final QuietTime.Builder getQuietTime() {
            return quietTime != null ? quietTime.toBuilder() : null;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        @Override
        public InAppCampaignSchedule build() {
            return new InAppCampaignSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
