/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Targeted in-app message campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppMessageCampaign implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppMessageCampaign.Builder, InAppMessageCampaign> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignId").getter(getter(InAppMessageCampaign::campaignId)).setter(setter(Builder::campaignId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignId").build()).build();

    private static final SdkField<Integer> DAILY_CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DailyCap").getter(getter(InAppMessageCampaign::dailyCap)).setter(setter(Builder::dailyCap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyCap").build()).build();

    private static final SdkField<InAppMessage> IN_APP_MESSAGE_FIELD = SdkField.<InAppMessage> builder(MarshallingType.SDK_POJO)
            .memberName("InAppMessage").getter(getter(InAppMessageCampaign::inAppMessage)).setter(setter(Builder::inAppMessage))
            .constructor(InAppMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppMessage").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(InAppMessageCampaign::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<InAppCampaignSchedule> SCHEDULE_FIELD = SdkField
            .<InAppCampaignSchedule> builder(MarshallingType.SDK_POJO).memberName("Schedule")
            .getter(getter(InAppMessageCampaign::schedule)).setter(setter(Builder::schedule))
            .constructor(InAppCampaignSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<Integer> SESSION_CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionCap").getter(getter(InAppMessageCampaign::sessionCap)).setter(setter(Builder::sessionCap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionCap").build()).build();

    private static final SdkField<Integer> TOTAL_CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCap").getter(getter(InAppMessageCampaign::totalCap)).setter(setter(Builder::totalCap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCap").build()).build();

    private static final SdkField<String> TREATMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentId").getter(getter(InAppMessageCampaign::treatmentId)).setter(setter(Builder::treatmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD,
            DAILY_CAP_FIELD, IN_APP_MESSAGE_FIELD, PRIORITY_FIELD, SCHEDULE_FIELD, SESSION_CAP_FIELD, TOTAL_CAP_FIELD,
            TREATMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String campaignId;

    private final Integer dailyCap;

    private final InAppMessage inAppMessage;

    private final Integer priority;

    private final InAppCampaignSchedule schedule;

    private final Integer sessionCap;

    private final Integer totalCap;

    private final String treatmentId;

    private InAppMessageCampaign(BuilderImpl builder) {
        this.campaignId = builder.campaignId;
        this.dailyCap = builder.dailyCap;
        this.inAppMessage = builder.inAppMessage;
        this.priority = builder.priority;
        this.schedule = builder.schedule;
        this.sessionCap = builder.sessionCap;
        this.totalCap = builder.totalCap;
        this.treatmentId = builder.treatmentId;
    }

    /**
     * <p>
     * Campaign id of the corresponding campaign.
     * </p>
     * 
     * @return Campaign id of the corresponding campaign.
     */
    public final String campaignId() {
        return campaignId;
    }

    /**
     * <p>
     * Daily cap which controls the number of times any in-app messages can be shown to the endpoint during a day.
     * </p>
     * 
     * @return Daily cap which controls the number of times any in-app messages can be shown to the endpoint during a
     *         day.
     */
    public final Integer dailyCap() {
        return dailyCap;
    }

    /**
     * <p>
     * In-app message content with all fields required for rendering an in-app message.
     * </p>
     * 
     * @return In-app message content with all fields required for rendering an in-app message.
     */
    public final InAppMessage inAppMessage() {
        return inAppMessage;
    }

    /**
     * <p>
     * Priority of the in-app message.
     * </p>
     * 
     * @return Priority of the in-app message.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Schedule of the campaign.
     * </p>
     * 
     * @return Schedule of the campaign.
     */
    public final InAppCampaignSchedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * Session cap which controls the number of times an in-app message can be shown to the endpoint during an
     * application session.
     * </p>
     * 
     * @return Session cap which controls the number of times an in-app message can be shown to the endpoint during an
     *         application session.
     */
    public final Integer sessionCap() {
        return sessionCap;
    }

    /**
     * <p>
     * Total cap which controls the number of times an in-app message can be shown to the endpoint.
     * </p>
     * 
     * @return Total cap which controls the number of times an in-app message can be shown to the endpoint.
     */
    public final Integer totalCap() {
        return totalCap;
    }

    /**
     * <p>
     * Treatment id of the campaign.
     * </p>
     * 
     * @return Treatment id of the campaign.
     */
    public final String treatmentId() {
        return treatmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(dailyCap());
        hashCode = 31 * hashCode + Objects.hashCode(inAppMessage());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(sessionCap());
        hashCode = 31 * hashCode + Objects.hashCode(totalCap());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageCampaign)) {
            return false;
        }
        InAppMessageCampaign other = (InAppMessageCampaign) obj;
        return Objects.equals(campaignId(), other.campaignId()) && Objects.equals(dailyCap(), other.dailyCap())
                && Objects.equals(inAppMessage(), other.inAppMessage()) && Objects.equals(priority(), other.priority())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(sessionCap(), other.sessionCap())
                && Objects.equals(totalCap(), other.totalCap()) && Objects.equals(treatmentId(), other.treatmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppMessageCampaign").add("CampaignId", campaignId()).add("DailyCap", dailyCap())
                .add("InAppMessage", inAppMessage()).add("Priority", priority()).add("Schedule", schedule())
                .add("SessionCap", sessionCap()).add("TotalCap", totalCap()).add("TreatmentId", treatmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignId":
            return Optional.ofNullable(clazz.cast(campaignId()));
        case "DailyCap":
            return Optional.ofNullable(clazz.cast(dailyCap()));
        case "InAppMessage":
            return Optional.ofNullable(clazz.cast(inAppMessage()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "SessionCap":
            return Optional.ofNullable(clazz.cast(sessionCap()));
        case "TotalCap":
            return Optional.ofNullable(clazz.cast(totalCap()));
        case "TreatmentId":
            return Optional.ofNullable(clazz.cast(treatmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageCampaign, T> g) {
        return obj -> g.apply((InAppMessageCampaign) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppMessageCampaign> {
        /**
         * <p>
         * Campaign id of the corresponding campaign.
         * </p>
         * 
         * @param campaignId
         *        Campaign id of the corresponding campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignId(String campaignId);

        /**
         * <p>
         * Daily cap which controls the number of times any in-app messages can be shown to the endpoint during a day.
         * </p>
         * 
         * @param dailyCap
         *        Daily cap which controls the number of times any in-app messages can be shown to the endpoint during a
         *        day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyCap(Integer dailyCap);

        /**
         * <p>
         * In-app message content with all fields required for rendering an in-app message.
         * </p>
         * 
         * @param inAppMessage
         *        In-app message content with all fields required for rendering an in-app message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppMessage(InAppMessage inAppMessage);

        /**
         * <p>
         * In-app message content with all fields required for rendering an in-app message.
         * </p>
         * This is a convenience method that creates an instance of the {@link InAppMessage.Builder} avoiding the need
         * to create one manually via {@link InAppMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link InAppMessage.Builder#build()} is called immediately and its
         * result is passed to {@link #inAppMessage(InAppMessage)}.
         * 
         * @param inAppMessage
         *        a consumer that will call methods on {@link InAppMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inAppMessage(InAppMessage)
         */
        default Builder inAppMessage(Consumer<InAppMessage.Builder> inAppMessage) {
            return inAppMessage(InAppMessage.builder().applyMutation(inAppMessage).build());
        }

        /**
         * <p>
         * Priority of the in-app message.
         * </p>
         * 
         * @param priority
         *        Priority of the in-app message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Schedule of the campaign.
         * </p>
         * 
         * @param schedule
         *        Schedule of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(InAppCampaignSchedule schedule);

        /**
         * <p>
         * Schedule of the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link InAppCampaignSchedule.Builder} avoiding
         * the need to create one manually via {@link InAppCampaignSchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link InAppCampaignSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(InAppCampaignSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link InAppCampaignSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(InAppCampaignSchedule)
         */
        default Builder schedule(Consumer<InAppCampaignSchedule.Builder> schedule) {
            return schedule(InAppCampaignSchedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * Session cap which controls the number of times an in-app message can be shown to the endpoint during an
         * application session.
         * </p>
         * 
         * @param sessionCap
         *        Session cap which controls the number of times an in-app message can be shown to the endpoint during
         *        an application session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionCap(Integer sessionCap);

        /**
         * <p>
         * Total cap which controls the number of times an in-app message can be shown to the endpoint.
         * </p>
         * 
         * @param totalCap
         *        Total cap which controls the number of times an in-app message can be shown to the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCap(Integer totalCap);

        /**
         * <p>
         * Treatment id of the campaign.
         * </p>
         * 
         * @param treatmentId
         *        Treatment id of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentId(String treatmentId);
    }

    static final class BuilderImpl implements Builder {
        private String campaignId;

        private Integer dailyCap;

        private InAppMessage inAppMessage;

        private Integer priority;

        private InAppCampaignSchedule schedule;

        private Integer sessionCap;

        private Integer totalCap;

        private String treatmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageCampaign model) {
            campaignId(model.campaignId);
            dailyCap(model.dailyCap);
            inAppMessage(model.inAppMessage);
            priority(model.priority);
            schedule(model.schedule);
            sessionCap(model.sessionCap);
            totalCap(model.totalCap);
            treatmentId(model.treatmentId);
        }

        public final String getCampaignId() {
            return campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final Integer getDailyCap() {
            return dailyCap;
        }

        public final void setDailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
        }

        @Override
        public final Builder dailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
            return this;
        }

        public final InAppMessage.Builder getInAppMessage() {
            return inAppMessage != null ? inAppMessage.toBuilder() : null;
        }

        public final void setInAppMessage(InAppMessage.BuilderImpl inAppMessage) {
            this.inAppMessage = inAppMessage != null ? inAppMessage.build() : null;
        }

        @Override
        public final Builder inAppMessage(InAppMessage inAppMessage) {
            this.inAppMessage = inAppMessage;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final InAppCampaignSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(InAppCampaignSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(InAppCampaignSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Integer getSessionCap() {
            return sessionCap;
        }

        public final void setSessionCap(Integer sessionCap) {
            this.sessionCap = sessionCap;
        }

        @Override
        public final Builder sessionCap(Integer sessionCap) {
            this.sessionCap = sessionCap;
            return this;
        }

        public final Integer getTotalCap() {
            return totalCap;
        }

        public final void setTotalCap(Integer totalCap) {
            this.totalCap = totalCap;
        }

        @Override
        public final Builder totalCap(Integer totalCap) {
            this.totalCap = totalCap;
            return this;
        }

        public final String getTreatmentId() {
            return treatmentId;
        }

        public final void setTreatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
        }

        @Override
        public final Builder treatmentId(String treatmentId) {
            this.treatmentId = treatmentId;
            return this;
        }

        @Override
        public InAppMessageCampaign build() {
            return new InAppMessageCampaign(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
