/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * InApp Template Request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppTemplateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppTemplateRequest.Builder, InAppTemplateRequest> {
    private static final SdkField<List<InAppMessageContent>> CONTENT_FIELD = SdkField
            .<List<InAppMessageContent>> builder(MarshallingType.LIST)
            .memberName("Content")
            .getter(getter(InAppTemplateRequest::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InAppMessageContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(InAppMessageContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomConfig")
            .getter(getter(InAppTemplateRequest::customConfig))
            .setter(setter(Builder::customConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConfig").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Layout")
            .getter(getter(InAppTemplateRequest::layoutAsString)).setter(setter(Builder::layout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(InAppTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(InAppTemplateRequest::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            CUSTOM_CONFIG_FIELD, LAYOUT_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InAppMessageContent> content;

    private final Map<String, String> customConfig;

    private final String layout;

    private final Map<String, String> tags;

    private final String templateDescription;

    private InAppTemplateRequest(BuilderImpl builder) {
        this.content = builder.content;
        this.customConfig = builder.customConfig;
        this.layout = builder.layout;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
     * background color. ImageUrl and buttons are optional.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
     *         background color. ImageUrl and buttons are optional.
     */
    public final List<InAppMessageContent> content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomConfig() {
        return customConfig != null && !(customConfig instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Custom config to be sent to client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomConfig} method.
     * </p>
     * 
     * @return Custom config to be sent to client.
     */
    public final Map<String, String> customConfig() {
        return customConfig;
    }

    /**
     * <p>
     * The layout of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layout} will
     * return {@link Layout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutAsString}.
     * </p>
     * 
     * @return The layout of the message.
     * @see Layout
     */
    public final Layout layout() {
        return Layout.fromValue(layout);
    }

    /**
     * <p>
     * The layout of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layout} will
     * return {@link Layout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutAsString}.
     * </p>
     * 
     * @return The layout of the message.
     * @see Layout
     */
    public final String layoutAsString() {
        return layout;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag
     * consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that defines the tags to associate with the message template.
     *         Each tag consists of a required tag key and an associated tag value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description of the template.
     * </p>
     * 
     * @return The description of the template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomConfig() ? customConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(layoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppTemplateRequest)) {
            return false;
        }
        InAppTemplateRequest other = (InAppTemplateRequest) obj;
        return hasContent() == other.hasContent() && Objects.equals(content(), other.content())
                && hasCustomConfig() == other.hasCustomConfig() && Objects.equals(customConfig(), other.customConfig())
                && Objects.equals(layoutAsString(), other.layoutAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateDescription(), other.templateDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppTemplateRequest").add("Content", hasContent() ? content() : null)
                .add("CustomConfig", hasCustomConfig() ? customConfig() : null).add("Layout", layoutAsString())
                .add("Tags", hasTags() ? tags() : null).add("TemplateDescription", templateDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "CustomConfig":
            return Optional.ofNullable(clazz.cast(customConfig()));
        case "Layout":
            return Optional.ofNullable(clazz.cast(layoutAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppTemplateRequest, T> g) {
        return obj -> g.apply((InAppTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppTemplateRequest> {
        /**
         * <p>
         * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
         * background color. ImageUrl and buttons are optional.
         * </p>
         * 
         * @param content
         *        The content of the message, can include up to 5 modals. Each modal must contain a message, a header,
         *        and background color. ImageUrl and buttons are optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<InAppMessageContent> content);

        /**
         * <p>
         * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
         * background color. ImageUrl and buttons are optional.
         * </p>
         * 
         * @param content
         *        The content of the message, can include up to 5 modals. Each modal must contain a message, a header,
         *        and background color. ImageUrl and buttons are optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(InAppMessageContent... content);

        /**
         * <p>
         * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
         * background color. ImageUrl and buttons are optional.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<InAppMessageContent>.Builder}
         * avoiding the need to create one manually via {@link List<InAppMessageContent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InAppMessageContent>.Builder#build()} is called immediately
         * and its result is passed to {@link #content(List<InAppMessageContent>)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link List<InAppMessageContent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(List<InAppMessageContent>)
         */
        Builder content(Consumer<InAppMessageContent.Builder>... content);

        /**
         * <p>
         * Custom config to be sent to client.
         * </p>
         * 
         * @param customConfig
         *        Custom config to be sent to client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customConfig(Map<String, String> customConfig);

        /**
         * <p>
         * The layout of the message.
         * </p>
         * 
         * @param layout
         *        The layout of the message.
         * @see Layout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Layout
         */
        Builder layout(String layout);

        /**
         * <p>
         * The layout of the message.
         * </p>
         * 
         * @param layout
         *        The layout of the message.
         * @see Layout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Layout
         */
        Builder layout(Layout layout);

        /**
         * <p>
         * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each
         * tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that defines the tags to associate with the message
         *        template. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description of the template.
         * </p>
         * 
         * @param templateDescription
         *        The description of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);
    }

    static final class BuilderImpl implements Builder {
        private List<InAppMessageContent> content = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> customConfig = DefaultSdkAutoConstructMap.getInstance();

        private String layout;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppTemplateRequest model) {
            content(model.content);
            customConfig(model.customConfig);
            layout(model.layout);
            tags(model.tags);
            templateDescription(model.templateDescription);
        }

        public final List<InAppMessageContent.Builder> getContent() {
            List<InAppMessageContent.Builder> result = ListOfInAppMessageContentCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<InAppMessageContent.BuilderImpl> content) {
            this.content = ListOfInAppMessageContentCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<InAppMessageContent> content) {
            this.content = ListOfInAppMessageContentCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(InAppMessageContent... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<InAppMessageContent.Builder>... content) {
            content(Stream.of(content).map(c -> InAppMessageContent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getCustomConfig() {
            if (customConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return customConfig;
        }

        public final void setCustomConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
        }

        @Override
        public final Builder customConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
            return this;
        }

        public final String getLayout() {
            return layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        public final Builder layout(Layout layout) {
            this.layout(layout == null ? null : layout.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        @Override
        public InAppTemplateRequest build() {
            return new InAppTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
