/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration and other settings for a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteCampaignRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<WriteCampaignRequest.Builder, WriteCampaignRequest> {
    private static final SdkField<List<WriteTreatmentResource>> ADDITIONAL_TREATMENTS_FIELD = SdkField
            .<List<WriteTreatmentResource>> builder(MarshallingType.LIST)
            .memberName("AdditionalTreatments")
            .getter(getter(WriteCampaignRequest::additionalTreatments))
            .setter(setter(Builder::additionalTreatments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalTreatments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WriteTreatmentResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(WriteTreatmentResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomDeliveryConfiguration> CUSTOM_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<CustomDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CustomDeliveryConfiguration")
            .getter(getter(WriteCampaignRequest::customDeliveryConfiguration))
            .setter(setter(Builder::customDeliveryConfiguration))
            .constructor(CustomDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDeliveryConfiguration")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WriteCampaignRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> HOLDOUT_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HoldoutPercent").getter(getter(WriteCampaignRequest::holdoutPercent))
            .setter(setter(Builder::holdoutPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoldoutPercent").build()).build();

    private static final SdkField<CampaignHook> HOOK_FIELD = SdkField.<CampaignHook> builder(MarshallingType.SDK_POJO)
            .memberName("Hook").getter(getter(WriteCampaignRequest::hook)).setter(setter(Builder::hook))
            .constructor(CampaignHook::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hook").build()).build();

    private static final SdkField<Boolean> IS_PAUSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPaused").getter(getter(WriteCampaignRequest::isPaused)).setter(setter(Builder::isPaused))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPaused").build()).build();

    private static final SdkField<CampaignLimits> LIMITS_FIELD = SdkField.<CampaignLimits> builder(MarshallingType.SDK_POJO)
            .memberName("Limits").getter(getter(WriteCampaignRequest::limits)).setter(setter(Builder::limits))
            .constructor(CampaignLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build()).build();

    private static final SdkField<MessageConfiguration> MESSAGE_CONFIGURATION_FIELD = SdkField
            .<MessageConfiguration> builder(MarshallingType.SDK_POJO).memberName("MessageConfiguration")
            .getter(getter(WriteCampaignRequest::messageConfiguration)).setter(setter(Builder::messageConfiguration))
            .constructor(MessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WriteCampaignRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("Schedule").getter(getter(WriteCampaignRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentId").getter(getter(WriteCampaignRequest::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<Integer> SEGMENT_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentVersion").getter(getter(WriteCampaignRequest::segmentVersion))
            .setter(setter(Builder::segmentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentVersion").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(WriteCampaignRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField
            .<TemplateConfiguration> builder(MarshallingType.SDK_POJO).memberName("TemplateConfiguration")
            .getter(getter(WriteCampaignRequest::templateConfiguration)).setter(setter(Builder::templateConfiguration))
            .constructor(TemplateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateConfiguration").build())
            .build();

    private static final SdkField<String> TREATMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentDescription").getter(getter(WriteCampaignRequest::treatmentDescription))
            .setter(setter(Builder::treatmentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentDescription").build())
            .build();

    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentName").getter(getter(WriteCampaignRequest::treatmentName))
            .setter(setter(Builder::treatmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentName").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(WriteCampaignRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_TREATMENTS_FIELD,
            CUSTOM_DELIVERY_CONFIGURATION_FIELD, DESCRIPTION_FIELD, HOLDOUT_PERCENT_FIELD, HOOK_FIELD, IS_PAUSED_FIELD,
            LIMITS_FIELD, MESSAGE_CONFIGURATION_FIELD, NAME_FIELD, SCHEDULE_FIELD, SEGMENT_ID_FIELD, SEGMENT_VERSION_FIELD,
            TAGS_FIELD, TEMPLATE_CONFIGURATION_FIELD, TREATMENT_DESCRIPTION_FIELD, TREATMENT_NAME_FIELD, PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<WriteTreatmentResource> additionalTreatments;

    private final CustomDeliveryConfiguration customDeliveryConfiguration;

    private final String description;

    private final Integer holdoutPercent;

    private final CampaignHook hook;

    private final Boolean isPaused;

    private final CampaignLimits limits;

    private final MessageConfiguration messageConfiguration;

    private final String name;

    private final Schedule schedule;

    private final String segmentId;

    private final Integer segmentVersion;

    private final Map<String, String> tags;

    private final TemplateConfiguration templateConfiguration;

    private final String treatmentDescription;

    private final String treatmentName;

    private final Integer priority;

    private WriteCampaignRequest(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.customDeliveryConfiguration = builder.customDeliveryConfiguration;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.hook = builder.hook;
        this.isPaused = builder.isPaused;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.tags = builder.tags;
        this.templateConfiguration = builder.templateConfiguration;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
        this.priority = builder.priority;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalTreatments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalTreatments() {
        return additionalTreatments != null && !(additionalTreatments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of requests that defines additional treatments for the campaign, in addition to the default treatment
     * for the campaign.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalTreatments} method.
     * </p>
     * 
     * @return An array of requests that defines additional treatments for the campaign, in addition to the default
     *         treatment for the campaign.
     */
    public final List<WriteTreatmentResource> additionalTreatments() {
        return additionalTreatments;
    }

    /**
     * <p>
     * The delivery configuration settings for sending the campaign through a custom channel. This object is required if
     * the MessageConfiguration object for the campaign specifies a CustomMessage object.
     * </p>
     * 
     * @return The delivery configuration settings for sending the campaign through a custom channel. This object is
     *         required if the MessageConfiguration object for the campaign specifies a CustomMessage object.
     */
    public final CustomDeliveryConfiguration customDeliveryConfiguration() {
        return customDeliveryConfiguration;
    }

    /**
     * <p>
     * A custom description of the campaign.
     * </p>
     * 
     * @return A custom description of the campaign.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     * </p>
     * 
     * @return The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
     */
    public final Integer holdoutPercent() {
        return holdoutPercent;
    }

    /**
     * <p>
     * The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to
     * customize the segment that's used by the campaign.
     * </p>
     * 
     * @return The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook
     *         to customize the segment that's used by the campaign.
     */
    public final CampaignHook hook() {
        return hook;
    }

    /**
     * <p>
     * Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this
     * value to false.
     * </p>
     * 
     * @return Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing
     *         this value to false.
     */
    public final Boolean isPaused() {
        return isPaused;
    }

    /**
     * <p>
     * The messaging limits for the campaign.
     * </p>
     * 
     * @return The messaging limits for the campaign.
     */
    public final CampaignLimits limits() {
        return limits;
    }

    /**
     * <p>
     * The message configuration settings for the campaign.
     * </p>
     * 
     * @return The message configuration settings for the campaign.
     */
    public final MessageConfiguration messageConfiguration() {
        return messageConfiguration;
    }

    /**
     * <p>
     * A custom name for the campaign.
     * </p>
     * 
     * @return A custom name for the campaign.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The schedule settings for the campaign.
     * </p>
     * 
     * @return The schedule settings for the campaign.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The unique identifier for the segment to associate with the campaign.
     * </p>
     * 
     * @return The unique identifier for the segment to associate with the campaign.
     */
    public final String segmentId() {
        return segmentId;
    }

    /**
     * <p>
     * The version of the segment to associate with the campaign.
     * </p>
     * 
     * @return The version of the segment to associate with the campaign.
     */
    public final Integer segmentVersion() {
        return segmentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists
     * of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag
     *         consists of a required tag key and an associated tag value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The message template to use for the campaign.
     * </p>
     * 
     * @return The message template to use for the campaign.
     */
    public final TemplateConfiguration templateConfiguration() {
        return templateConfiguration;
    }

    /**
     * <p>
     * A custom description of the default treatment for the campaign.
     * </p>
     * 
     * @return A custom description of the default treatment for the campaign.
     */
    public final String treatmentDescription() {
        return treatmentDescription;
    }

    /**
     * <p>
     * A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
     * <i>treatment</i> is a variation of a campaign that's used for A/B testing.
     * </p>
     * 
     * @return A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
     *         <i>treatment</i> is a variation of a campaign that's used for A/B testing.
     */
    public final String treatmentName() {
        return treatmentName;
    }

    /**
     * <p>
     * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are
     * multiple messages scheduled to be displayed at the same moment.
     * </p>
     * 
     * @return Defines the priority of the campaign, used to decide the order of messages displayed to user if there are
     *         multiple messages scheduled to be displayed at the same moment.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalTreatments() ? additionalTreatments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(holdoutPercent());
        hashCode = 31 * hashCode + Objects.hashCode(hook());
        hashCode = 31 * hashCode + Objects.hashCode(isPaused());
        hashCode = 31 * hashCode + Objects.hashCode(limits());
        hashCode = 31 * hashCode + Objects.hashCode(messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteCampaignRequest)) {
            return false;
        }
        WriteCampaignRequest other = (WriteCampaignRequest) obj;
        return hasAdditionalTreatments() == other.hasAdditionalTreatments()
                && Objects.equals(additionalTreatments(), other.additionalTreatments())
                && Objects.equals(customDeliveryConfiguration(), other.customDeliveryConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(holdoutPercent(), other.holdoutPercent())
                && Objects.equals(hook(), other.hook()) && Objects.equals(isPaused(), other.isPaused())
                && Objects.equals(limits(), other.limits())
                && Objects.equals(messageConfiguration(), other.messageConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(segmentId(), other.segmentId())
                && Objects.equals(segmentVersion(), other.segmentVersion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateConfiguration(), other.templateConfiguration())
                && Objects.equals(treatmentDescription(), other.treatmentDescription())
                && Objects.equals(treatmentName(), other.treatmentName()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WriteCampaignRequest")
                .add("AdditionalTreatments", hasAdditionalTreatments() ? additionalTreatments() : null)
                .add("CustomDeliveryConfiguration", customDeliveryConfiguration()).add("Description", description())
                .add("HoldoutPercent", holdoutPercent()).add("Hook", hook()).add("IsPaused", isPaused()).add("Limits", limits())
                .add("MessageConfiguration", messageConfiguration()).add("Name", name()).add("Schedule", schedule())
                .add("SegmentId", segmentId()).add("SegmentVersion", segmentVersion()).add("Tags", hasTags() ? tags() : null)
                .add("TemplateConfiguration", templateConfiguration()).add("TreatmentDescription", treatmentDescription())
                .add("TreatmentName", treatmentName()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalTreatments":
            return Optional.ofNullable(clazz.cast(additionalTreatments()));
        case "CustomDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(customDeliveryConfiguration()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HoldoutPercent":
            return Optional.ofNullable(clazz.cast(holdoutPercent()));
        case "Hook":
            return Optional.ofNullable(clazz.cast(hook()));
        case "IsPaused":
            return Optional.ofNullable(clazz.cast(isPaused()));
        case "Limits":
            return Optional.ofNullable(clazz.cast(limits()));
        case "MessageConfiguration":
            return Optional.ofNullable(clazz.cast(messageConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentVersion":
            return Optional.ofNullable(clazz.cast(segmentVersion()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateConfiguration":
            return Optional.ofNullable(clazz.cast(templateConfiguration()));
        case "TreatmentDescription":
            return Optional.ofNullable(clazz.cast(treatmentDescription()));
        case "TreatmentName":
            return Optional.ofNullable(clazz.cast(treatmentName()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteCampaignRequest, T> g) {
        return obj -> g.apply((WriteCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WriteCampaignRequest> {
        /**
         * <p>
         * An array of requests that defines additional treatments for the campaign, in addition to the default
         * treatment for the campaign.
         * </p>
         * 
         * @param additionalTreatments
         *        An array of requests that defines additional treatments for the campaign, in addition to the default
         *        treatment for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(Collection<WriteTreatmentResource> additionalTreatments);

        /**
         * <p>
         * An array of requests that defines additional treatments for the campaign, in addition to the default
         * treatment for the campaign.
         * </p>
         * 
         * @param additionalTreatments
         *        An array of requests that defines additional treatments for the campaign, in addition to the default
         *        treatment for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTreatments(WriteTreatmentResource... additionalTreatments);

        /**
         * <p>
         * An array of requests that defines additional treatments for the campaign, in addition to the default
         * treatment for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<WriteTreatmentResource>.Builder}
         * avoiding the need to create one manually via {@link List<WriteTreatmentResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WriteTreatmentResource>.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalTreatments(List<WriteTreatmentResource>)}.
         * 
         * @param additionalTreatments
         *        a consumer that will call methods on {@link List<WriteTreatmentResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalTreatments(List<WriteTreatmentResource>)
         */
        Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder>... additionalTreatments);

        /**
         * <p>
         * The delivery configuration settings for sending the campaign through a custom channel. This object is
         * required if the MessageConfiguration object for the campaign specifies a CustomMessage object.
         * </p>
         * 
         * @param customDeliveryConfiguration
         *        The delivery configuration settings for sending the campaign through a custom channel. This object is
         *        required if the MessageConfiguration object for the campaign specifies a CustomMessage object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration);

        /**
         * <p>
         * The delivery configuration settings for sending the campaign through a custom channel. This object is
         * required if the MessageConfiguration object for the campaign specifies a CustomMessage object.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomDeliveryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #customDeliveryConfiguration(CustomDeliveryConfiguration)}.
         * 
         * @param customDeliveryConfiguration
         *        a consumer that will call methods on {@link CustomDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDeliveryConfiguration(CustomDeliveryConfiguration)
         */
        default Builder customDeliveryConfiguration(Consumer<CustomDeliveryConfiguration.Builder> customDeliveryConfiguration) {
            return customDeliveryConfiguration(CustomDeliveryConfiguration.builder().applyMutation(customDeliveryConfiguration)
                    .build());
        }

        /**
         * <p>
         * A custom description of the campaign.
         * </p>
         * 
         * @param description
         *        A custom description of the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         * </p>
         * 
         * @param holdoutPercent
         *        The allocated percentage of users (segment members) who shouldn't receive messages from the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder holdoutPercent(Integer holdoutPercent);

        /**
         * <p>
         * The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to
         * customize the segment that's used by the campaign.
         * </p>
         * 
         * @param hook
         *        The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this
         *        hook to customize the segment that's used by the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hook(CampaignHook hook);

        /**
         * <p>
         * The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to
         * customize the segment that's used by the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignHook.Builder} avoiding the need
         * to create one manually via {@link CampaignHook#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignHook.Builder#build()} is called immediately and its
         * result is passed to {@link #hook(CampaignHook)}.
         * 
         * @param hook
         *        a consumer that will call methods on {@link CampaignHook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hook(CampaignHook)
         */
        default Builder hook(Consumer<CampaignHook.Builder> hook) {
            return hook(CampaignHook.builder().applyMutation(hook).build());
        }

        /**
         * <p>
         * Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by changing this
         * value to false.
         * </p>
         * 
         * @param isPaused
         *        Specifies whether to pause the campaign. A paused campaign doesn't run unless you resume it by
         *        changing this value to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPaused(Boolean isPaused);

        /**
         * <p>
         * The messaging limits for the campaign.
         * </p>
         * 
         * @param limits
         *        The messaging limits for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limits(CampaignLimits limits);

        /**
         * <p>
         * The messaging limits for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link CampaignLimits.Builder} avoiding the need
         * to create one manually via {@link CampaignLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link CampaignLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #limits(CampaignLimits)}.
         * 
         * @param limits
         *        a consumer that will call methods on {@link CampaignLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limits(CampaignLimits)
         */
        default Builder limits(Consumer<CampaignLimits.Builder> limits) {
            return limits(CampaignLimits.builder().applyMutation(limits).build());
        }

        /**
         * <p>
         * The message configuration settings for the campaign.
         * </p>
         * 
         * @param messageConfiguration
         *        The message configuration settings for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageConfiguration(MessageConfiguration messageConfiguration);

        /**
         * <p>
         * The message configuration settings for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageConfiguration.Builder} avoiding
         * the need to create one manually via {@link MessageConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MessageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #messageConfiguration(MessageConfiguration)}.
         * 
         * @param messageConfiguration
         *        a consumer that will call methods on {@link MessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageConfiguration(MessageConfiguration)
         */
        default Builder messageConfiguration(Consumer<MessageConfiguration.Builder> messageConfiguration) {
            return messageConfiguration(MessageConfiguration.builder().applyMutation(messageConfiguration).build());
        }

        /**
         * <p>
         * A custom name for the campaign.
         * </p>
         * 
         * @param name
         *        A custom name for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The schedule settings for the campaign.
         * </p>
         * 
         * @param schedule
         *        The schedule settings for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule settings for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The unique identifier for the segment to associate with the campaign.
         * </p>
         * 
         * @param segmentId
         *        The unique identifier for the segment to associate with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * <p>
         * The version of the segment to associate with the campaign.
         * </p>
         * 
         * @param segmentVersion
         *        The version of the segment to associate with the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentVersion(Integer segmentVersion);

        /**
         * <p>
         * A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag
         * consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each
         *        tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The message template to use for the campaign.
         * </p>
         * 
         * @param templateConfiguration
         *        The message template to use for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateConfiguration(TemplateConfiguration templateConfiguration);

        /**
         * <p>
         * The message template to use for the campaign.
         * </p>
         * This is a convenience method that creates an instance of the {@link TemplateConfiguration.Builder} avoiding
         * the need to create one manually via {@link TemplateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #templateConfiguration(TemplateConfiguration)}.
         * 
         * @param templateConfiguration
         *        a consumer that will call methods on {@link TemplateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templateConfiguration(TemplateConfiguration)
         */
        default Builder templateConfiguration(Consumer<TemplateConfiguration.Builder> templateConfiguration) {
            return templateConfiguration(TemplateConfiguration.builder().applyMutation(templateConfiguration).build());
        }

        /**
         * <p>
         * A custom description of the default treatment for the campaign.
         * </p>
         * 
         * @param treatmentDescription
         *        A custom description of the default treatment for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentDescription(String treatmentDescription);

        /**
         * <p>
         * A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
         * <i>treatment</i> is a variation of a campaign that's used for A/B testing.
         * </p>
         * 
         * @param treatmentName
         *        A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A
         *        <i>treatment</i> is a variation of a campaign that's used for A/B testing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treatmentName(String treatmentName);

        /**
         * <p>
         * Defines the priority of the campaign, used to decide the order of messages displayed to user if there are
         * multiple messages scheduled to be displayed at the same moment.
         * </p>
         * 
         * @param priority
         *        Defines the priority of the campaign, used to decide the order of messages displayed to user if there
         *        are multiple messages scheduled to be displayed at the same moment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private List<WriteTreatmentResource> additionalTreatments = DefaultSdkAutoConstructList.getInstance();

        private CustomDeliveryConfiguration customDeliveryConfiguration;

        private String description;

        private Integer holdoutPercent;

        private CampaignHook hook;

        private Boolean isPaused;

        private CampaignLimits limits;

        private MessageConfiguration messageConfiguration;

        private String name;

        private Schedule schedule;

        private String segmentId;

        private Integer segmentVersion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private TemplateConfiguration templateConfiguration;

        private String treatmentDescription;

        private String treatmentName;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteCampaignRequest model) {
            additionalTreatments(model.additionalTreatments);
            customDeliveryConfiguration(model.customDeliveryConfiguration);
            description(model.description);
            holdoutPercent(model.holdoutPercent);
            hook(model.hook);
            isPaused(model.isPaused);
            limits(model.limits);
            messageConfiguration(model.messageConfiguration);
            name(model.name);
            schedule(model.schedule);
            segmentId(model.segmentId);
            segmentVersion(model.segmentVersion);
            tags(model.tags);
            templateConfiguration(model.templateConfiguration);
            treatmentDescription(model.treatmentDescription);
            treatmentName(model.treatmentName);
            priority(model.priority);
        }

        public final List<WriteTreatmentResource.Builder> getAdditionalTreatments() {
            List<WriteTreatmentResource.Builder> result = ListOfWriteTreatmentResourceCopier
                    .copyToBuilder(this.additionalTreatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalTreatments(Collection<WriteTreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        @Override
        public final Builder additionalTreatments(Collection<WriteTreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfWriteTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(WriteTreatmentResource... additionalTreatments) {
            additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(Consumer<WriteTreatmentResource.Builder>... additionalTreatments) {
            additionalTreatments(Stream.of(additionalTreatments)
                    .map(c -> WriteTreatmentResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomDeliveryConfiguration.Builder getCustomDeliveryConfiguration() {
            return customDeliveryConfiguration != null ? customDeliveryConfiguration.toBuilder() : null;
        }

        public final void setCustomDeliveryConfiguration(CustomDeliveryConfiguration.BuilderImpl customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration != null ? customDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder customDeliveryConfiguration(CustomDeliveryConfiguration customDeliveryConfiguration) {
            this.customDeliveryConfiguration = customDeliveryConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getHoldoutPercent() {
            return holdoutPercent;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final CampaignHook.Builder getHook() {
            return hook != null ? hook.toBuilder() : null;
        }

        public final void setHook(CampaignHook.BuilderImpl hook) {
            this.hook = hook != null ? hook.build() : null;
        }

        @Override
        public final Builder hook(CampaignHook hook) {
            this.hook = hook;
            return this;
        }

        public final Boolean getIsPaused() {
            return isPaused;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final CampaignLimits.Builder getLimits() {
            return limits != null ? limits.toBuilder() : null;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return messageConfiguration != null ? messageConfiguration.toBuilder() : null;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final Integer getSegmentVersion() {
            return segmentVersion;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final TemplateConfiguration.Builder getTemplateConfiguration() {
            return templateConfiguration != null ? templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(TemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(TemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTreatmentDescription() {
            return treatmentDescription;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final String getTreatmentName() {
            return treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public WriteCampaignRequest build() {
            return new WriteCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
