/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about which users and endpoints a message was sent to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendUsersMessageResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<SendUsersMessageResponse.Builder, SendUsersMessageResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(SendUsersMessageResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(SendUsersMessageResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Map<String, Map<String, EndpointMessageResult>>> RESULT_FIELD = SdkField
            .<Map<String, Map<String, EndpointMessageResult>>> builder(MarshallingType.MAP)
            .memberName("Result")
            .getter(getter(SendUsersMessageResponse::result))
            .setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, EndpointMessageResult>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<EndpointMessageResult> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(EndpointMessageResult::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            REQUEST_ID_FIELD, RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String requestId;

    private final Map<String, Map<String, EndpointMessageResult>> result;

    private SendUsersMessageResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.requestId = builder.requestId;
        this.result = builder.result;
    }

    /**
     * <p>
     * The unique identifier for the application that was used to send the message.
     * </p>
     * 
     * @return The unique identifier for the application that was used to send the message.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The unique identifier that was assigned to the message request.
     * </p>
     * 
     * @return The unique identifier that was assigned to the message request.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Result property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResult() {
        return result != null && !(result instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that indicates which endpoints the message was sent to, for each user. The object lists user IDs and,
     * for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID, it provides an
     * EndpointMessageResult object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResult} method.
     * </p>
     * 
     * @return An object that indicates which endpoints the message was sent to, for each user. The object lists user
     *         IDs and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID,
     *         it provides an EndpointMessageResult object.
     */
    public final Map<String, Map<String, EndpointMessageResult>> result() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResult() ? result() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessageResponse)) {
            return false;
        }
        SendUsersMessageResponse other = (SendUsersMessageResponse) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(requestId(), other.requestId())
                && hasResult() == other.hasResult() && Objects.equals(result(), other.result());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendUsersMessageResponse").add("ApplicationId", applicationId()).add("RequestId", requestId())
                .add("Result", hasResult() ? result() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Result":
            return Optional.ofNullable(clazz.cast(result()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendUsersMessageResponse, T> g) {
        return obj -> g.apply((SendUsersMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendUsersMessageResponse> {
        /**
         * <p>
         * The unique identifier for the application that was used to send the message.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that was used to send the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The unique identifier that was assigned to the message request.
         * </p>
         * 
         * @param requestId
         *        The unique identifier that was assigned to the message request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * An object that indicates which endpoints the message was sent to, for each user. The object lists user IDs
         * and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID, it
         * provides an EndpointMessageResult object.
         * </p>
         * 
         * @param result
         *        An object that indicates which endpoints the message was sent to, for each user. The object lists user
         *        IDs and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint
         *        ID, it provides an EndpointMessageResult object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(Map<String, ? extends Map<String, EndpointMessageResult>> result);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String requestId;

        private Map<String, Map<String, EndpointMessageResult>> result = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessageResponse model) {
            applicationId(model.applicationId);
            requestId(model.requestId);
            result(model.result);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Map<String, Map<String, EndpointMessageResult.Builder>> getResult() {
            Map<String, Map<String, EndpointMessageResult.Builder>> result = MapOfMapOfEndpointMessageResultCopier
                    .copyToBuilder(this.result);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResult(Map<String, ? extends Map<String, EndpointMessageResult.BuilderImpl>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copyFromBuilder(result);
        }

        @Override
        @Transient
        public final Builder result(Map<String, ? extends Map<String, EndpointMessageResult>> result) {
            this.result = MapOfMapOfEndpointMessageResultCopier.copy(result);
            return this;
        }

        @Override
        public SendUsersMessageResponse build() {
            return new SendUsersMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
