/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCampaignRequest extends PinpointRequest implements
        ToCopyableBuilder<CreateCampaignRequest.Builder, CreateCampaignRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CreateCampaignRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<WriteCampaignRequest> WRITE_CAMPAIGN_REQUEST_FIELD = SdkField
            .<WriteCampaignRequest> builder(MarshallingType.SDK_POJO)
            .memberName("WriteCampaignRequest")
            .getter(getter(CreateCampaignRequest::writeCampaignRequest))
            .setter(setter(Builder::writeCampaignRequest))
            .constructor(WriteCampaignRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteCampaignRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            WRITE_CAMPAIGN_REQUEST_FIELD));

    private final String applicationId;

    private final WriteCampaignRequest writeCampaignRequest;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.writeCampaignRequest = builder.writeCampaignRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the WriteCampaignRequest property for this object.
     * 
     * @return The value of the WriteCampaignRequest property for this object.
     */
    public final WriteCampaignRequest writeCampaignRequest() {
        return writeCampaignRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(writeCampaignRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(writeCampaignRequest(), other.writeCampaignRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCampaignRequest").add("ApplicationId", applicationId())
                .add("WriteCampaignRequest", writeCampaignRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "WriteCampaignRequest":
            return Optional.ofNullable(clazz.cast(writeCampaignRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCampaignRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the WriteCampaignRequest property for this object.
         *
         * @param writeCampaignRequest
         *        The new value for the WriteCampaignRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCampaignRequest(WriteCampaignRequest writeCampaignRequest);

        /**
         * Sets the value of the WriteCampaignRequest property for this object.
         *
         * This is a convenience that creates an instance of the {@link WriteCampaignRequest.Builder} avoiding the need
         * to create one manually via {@link WriteCampaignRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link WriteCampaignRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #writeCampaignRequest(WriteCampaignRequest)}.
         * 
         * @param writeCampaignRequest
         *        a consumer that will call methods on {@link WriteCampaignRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeCampaignRequest(WriteCampaignRequest)
         */
        default Builder writeCampaignRequest(Consumer<WriteCampaignRequest.Builder> writeCampaignRequest) {
            return writeCampaignRequest(WriteCampaignRequest.builder().applyMutation(writeCampaignRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private WriteCampaignRequest writeCampaignRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            applicationId(model.applicationId);
            writeCampaignRequest(model.writeCampaignRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        @Transient
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final WriteCampaignRequest.Builder getWriteCampaignRequest() {
            return writeCampaignRequest != null ? writeCampaignRequest.toBuilder() : null;
        }

        public final void setWriteCampaignRequest(WriteCampaignRequest.BuilderImpl writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest != null ? writeCampaignRequest.build() : null;
        }

        @Override
        @Transient
        public final Builder writeCampaignRequest(WriteCampaignRequest writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
