/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInAppMessagesResponse extends PinpointResponse implements
        ToCopyableBuilder<GetInAppMessagesResponse.Builder, GetInAppMessagesResponse> {
    private static final SdkField<InAppMessagesResponse> IN_APP_MESSAGES_RESPONSE_FIELD = SdkField
            .<InAppMessagesResponse> builder(MarshallingType.SDK_POJO)
            .memberName("InAppMessagesResponse")
            .getter(getter(GetInAppMessagesResponse::inAppMessagesResponse))
            .setter(setter(Builder::inAppMessagesResponse))
            .constructor(InAppMessagesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppMessagesResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IN_APP_MESSAGES_RESPONSE_FIELD));

    private final InAppMessagesResponse inAppMessagesResponse;

    private GetInAppMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.inAppMessagesResponse = builder.inAppMessagesResponse;
    }

    /**
     * Returns the value of the InAppMessagesResponse property for this object.
     * 
     * @return The value of the InAppMessagesResponse property for this object.
     */
    public final InAppMessagesResponse inAppMessagesResponse() {
        return inAppMessagesResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inAppMessagesResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInAppMessagesResponse)) {
            return false;
        }
        GetInAppMessagesResponse other = (GetInAppMessagesResponse) obj;
        return Objects.equals(inAppMessagesResponse(), other.inAppMessagesResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInAppMessagesResponse").add("InAppMessagesResponse", inAppMessagesResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InAppMessagesResponse":
            return Optional.ofNullable(clazz.cast(inAppMessagesResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInAppMessagesResponse, T> g) {
        return obj -> g.apply((GetInAppMessagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInAppMessagesResponse> {
        /**
         * Sets the value of the InAppMessagesResponse property for this object.
         *
         * @param inAppMessagesResponse
         *        The new value for the InAppMessagesResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppMessagesResponse(InAppMessagesResponse inAppMessagesResponse);

        /**
         * Sets the value of the InAppMessagesResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link InAppMessagesResponse.Builder} avoiding the need
         * to create one manually via {@link InAppMessagesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link InAppMessagesResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #inAppMessagesResponse(InAppMessagesResponse)}.
         * 
         * @param inAppMessagesResponse
         *        a consumer that will call methods on {@link InAppMessagesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inAppMessagesResponse(InAppMessagesResponse)
         */
        default Builder inAppMessagesResponse(Consumer<InAppMessagesResponse.Builder> inAppMessagesResponse) {
            return inAppMessagesResponse(InAppMessagesResponse.builder().applyMutation(inAppMessagesResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private InAppMessagesResponse inAppMessagesResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInAppMessagesResponse model) {
            super(model);
            inAppMessagesResponse(model.inAppMessagesResponse);
        }

        public final InAppMessagesResponse.Builder getInAppMessagesResponse() {
            return inAppMessagesResponse != null ? inAppMessagesResponse.toBuilder() : null;
        }

        public final void setInAppMessagesResponse(InAppMessagesResponse.BuilderImpl inAppMessagesResponse) {
            this.inAppMessagesResponse = inAppMessagesResponse != null ? inAppMessagesResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder inAppMessagesResponse(InAppMessagesResponse inAppMessagesResponse) {
            this.inAppMessagesResponse = inAppMessagesResponse;
            return this;
        }

        @Override
        public GetInAppMessagesResponse build() {
            return new GetInAppMessagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
