/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In-App Template Response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppTemplateResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppTemplateResponse.Builder, InAppTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(InAppTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<InAppMessageContent>> CONTENT_FIELD = SdkField
            .<List<InAppMessageContent>> builder(MarshallingType.LIST)
            .memberName("Content")
            .getter(getter(InAppTemplateResponse::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InAppMessageContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(InAppMessageContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(InAppTemplateResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomConfig")
            .getter(getter(InAppTemplateResponse::customConfig))
            .setter(setter(Builder::customConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomConfig").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(InAppTemplateResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Layout")
            .getter(getter(InAppTemplateResponse::layoutAsString)).setter(setter(Builder::layout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(InAppTemplateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(InAppTemplateResponse::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(InAppTemplateResponse::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(InAppTemplateResponse::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(InAppTemplateResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONTENT_FIELD,
            CREATION_DATE_FIELD, CUSTOM_CONFIG_FIELD, LAST_MODIFIED_DATE_FIELD, LAYOUT_FIELD, TAGS_FIELD,
            TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<InAppMessageContent> content;

    private final String creationDate;

    private final Map<String, String> customConfig;

    private final String lastModifiedDate;

    private final String layout;

    private final Map<String, String> tags;

    private final String templateDescription;

    private final String templateName;

    private final String templateType;

    private final String version;

    private InAppTemplateResponse(BuilderImpl builder) {
        this.arn = builder.arn;
        this.content = builder.content;
        this.creationDate = builder.creationDate;
        this.customConfig = builder.customConfig;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.layout = builder.layout;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.version = builder.version;
    }

    /**
     * <p>
     * The resource arn of the template.
     * </p>
     * 
     * @return The resource arn of the template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
     * background color. ImageUrl and buttons are optional.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
     *         background color. ImageUrl and buttons are optional.
     */
    public final List<InAppMessageContent> content() {
        return content;
    }

    /**
     * <p>
     * The creation date of the template.
     * </p>
     * 
     * @return The creation date of the template.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomConfig() {
        return customConfig != null && !(customConfig instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Custom config to be sent to client.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomConfig} method.
     * </p>
     * 
     * @return Custom config to be sent to client.
     */
    public final Map<String, String> customConfig() {
        return customConfig;
    }

    /**
     * <p>
     * The last modified date of the template.
     * </p>
     * 
     * @return The last modified date of the template.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The layout of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layout} will
     * return {@link Layout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutAsString}.
     * </p>
     * 
     * @return The layout of the message.
     * @see Layout
     */
    public final Layout layout() {
        return Layout.fromValue(layout);
    }

    /**
     * <p>
     * The layout of the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layout} will
     * return {@link Layout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutAsString}.
     * </p>
     * 
     * @return The layout of the message.
     * @see Layout
     */
    public final String layoutAsString() {
        return layout;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag
     * consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that defines the tags to associate with the message template.
     *         Each tag consists of a required tag key and an associated tag value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The description of the template.
     * </p>
     * 
     * @return The description of the template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The name of the template.
     * </p>
     * 
     * @return The name of the template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The type of the template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the template.
     * @see TemplateType
     */
    public final TemplateType templateType() {
        return TemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of the template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of the template.
     * @see TemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * The version id of the template.
     * </p>
     * 
     * @return The version id of the template.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomConfig() ? customConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(layoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppTemplateResponse)) {
            return false;
        }
        InAppTemplateResponse other = (InAppTemplateResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasContent() == other.hasContent()
                && Objects.equals(content(), other.content()) && Objects.equals(creationDate(), other.creationDate())
                && hasCustomConfig() == other.hasCustomConfig() && Objects.equals(customConfig(), other.customConfig())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(layoutAsString(), other.layoutAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppTemplateResponse").add("Arn", arn()).add("Content", hasContent() ? content() : null)
                .add("CreationDate", creationDate()).add("CustomConfig", hasCustomConfig() ? customConfig() : null)
                .add("LastModifiedDate", lastModifiedDate()).add("Layout", layoutAsString())
                .add("Tags", hasTags() ? tags() : null).add("TemplateDescription", templateDescription())
                .add("TemplateName", templateName()).add("TemplateType", templateTypeAsString()).add("Version", version())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CustomConfig":
            return Optional.ofNullable(clazz.cast(customConfig()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "Layout":
            return Optional.ofNullable(clazz.cast(layoutAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppTemplateResponse, T> g) {
        return obj -> g.apply((InAppTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppTemplateResponse> {
        /**
         * <p>
         * The resource arn of the template.
         * </p>
         * 
         * @param arn
         *        The resource arn of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
         * background color. ImageUrl and buttons are optional.
         * </p>
         * 
         * @param content
         *        The content of the message, can include up to 5 modals. Each modal must contain a message, a header,
         *        and background color. ImageUrl and buttons are optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<InAppMessageContent> content);

        /**
         * <p>
         * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
         * background color. ImageUrl and buttons are optional.
         * </p>
         * 
         * @param content
         *        The content of the message, can include up to 5 modals. Each modal must contain a message, a header,
         *        and background color. ImageUrl and buttons are optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(InAppMessageContent... content);

        /**
         * <p>
         * The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and
         * background color. ImageUrl and buttons are optional.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InAppMessageContent>.Builder} avoiding the
         * need to create one manually via {@link List<InAppMessageContent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InAppMessageContent>.Builder#build()} is called immediately
         * and its result is passed to {@link #content(List<InAppMessageContent>)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link List<InAppMessageContent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(List<InAppMessageContent>)
         */
        Builder content(Consumer<InAppMessageContent.Builder>... content);

        /**
         * <p>
         * The creation date of the template.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * Custom config to be sent to client.
         * </p>
         * 
         * @param customConfig
         *        Custom config to be sent to client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customConfig(Map<String, String> customConfig);

        /**
         * <p>
         * The last modified date of the template.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last modified date of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The layout of the message.
         * </p>
         * 
         * @param layout
         *        The layout of the message.
         * @see Layout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Layout
         */
        Builder layout(String layout);

        /**
         * <p>
         * The layout of the message.
         * </p>
         * 
         * @param layout
         *        The layout of the message.
         * @see Layout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Layout
         */
        Builder layout(Layout layout);

        /**
         * <p>
         * A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each
         * tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that defines the tags to associate with the message
         *        template. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The description of the template.
         * </p>
         * 
         * @param templateDescription
         *        The description of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The name of the template.
         * </p>
         * 
         * @param templateName
         *        The name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The type of the template.
         * </p>
         * 
         * @param templateType
         *        The type of the template.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of the template.
         * </p>
         * 
         * @param templateType
         *        The type of the template.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(TemplateType templateType);

        /**
         * <p>
         * The version id of the template.
         * </p>
         * 
         * @param version
         *        The version id of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<InAppMessageContent> content = DefaultSdkAutoConstructList.getInstance();

        private String creationDate;

        private Map<String, String> customConfig = DefaultSdkAutoConstructMap.getInstance();

        private String lastModifiedDate;

        private String layout;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private String templateName;

        private String templateType;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppTemplateResponse model) {
            arn(model.arn);
            content(model.content);
            creationDate(model.creationDate);
            customConfig(model.customConfig);
            lastModifiedDate(model.lastModifiedDate);
            layout(model.layout);
            tags(model.tags);
            templateDescription(model.templateDescription);
            templateName(model.templateName);
            templateType(model.templateType);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<InAppMessageContent.Builder> getContent() {
            List<InAppMessageContent.Builder> result = ListOfInAppMessageContentCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<InAppMessageContent.BuilderImpl> content) {
            this.content = ListOfInAppMessageContentCopier.copyFromBuilder(content);
        }

        @Override
        @Transient
        public final Builder content(Collection<InAppMessageContent> content) {
            this.content = ListOfInAppMessageContentCopier.copy(content);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder content(InAppMessageContent... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder content(Consumer<InAppMessageContent.Builder>... content) {
            content(Stream.of(content).map(c -> InAppMessageContent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Map<String, String> getCustomConfig() {
            if (customConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return customConfig;
        }

        public final void setCustomConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
        }

        @Override
        @Transient
        public final Builder customConfig(Map<String, String> customConfig) {
            this.customConfig = MapOf__stringCopier.copy(customConfig);
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLayout() {
            return layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        @Transient
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        @Transient
        public final Builder layout(Layout layout) {
            this.layout(layout == null ? null : layout.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        @Transient
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        @Transient
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        @Transient
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public InAppTemplateResponse build() {
            return new InAppTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
