/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.DefaultButtonConfiguration;
import software.amazon.awssdk.services.pinpoint.model.OverrideButtonConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InAppMessageButton
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InAppMessageButton> {
    private static final SdkField<OverrideButtonConfiguration> ANDROID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Android").getter(InAppMessageButton.getter(InAppMessageButton::android)).setter(InAppMessageButton.setter(Builder::android)).constructor(OverrideButtonConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Android").build()}).build();
    private static final SdkField<DefaultButtonConfiguration> DEFAULT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultConfig").getter(InAppMessageButton.getter(InAppMessageButton::defaultConfig)).setter(InAppMessageButton.setter(Builder::defaultConfig)).constructor(DefaultButtonConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultConfig").build()}).build();
    private static final SdkField<OverrideButtonConfiguration> IOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IOS").getter(InAppMessageButton.getter(InAppMessageButton::ios)).setter(InAppMessageButton.setter(Builder::ios)).constructor(OverrideButtonConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IOS").build()}).build();
    private static final SdkField<OverrideButtonConfiguration> WEB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Web").getter(InAppMessageButton.getter(InAppMessageButton::web)).setter(InAppMessageButton.setter(Builder::web)).constructor(OverrideButtonConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Web").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANDROID_FIELD, DEFAULT_CONFIG_FIELD, IOS_FIELD, WEB_FIELD));
    private static final long serialVersionUID = 1L;
    private final OverrideButtonConfiguration android;
    private final DefaultButtonConfiguration defaultConfig;
    private final OverrideButtonConfiguration ios;
    private final OverrideButtonConfiguration web;

    private InAppMessageButton(BuilderImpl builder) {
        this.android = builder.android;
        this.defaultConfig = builder.defaultConfig;
        this.ios = builder.ios;
        this.web = builder.web;
    }

    public final OverrideButtonConfiguration android() {
        return this.android;
    }

    public final DefaultButtonConfiguration defaultConfig() {
        return this.defaultConfig;
    }

    public final OverrideButtonConfiguration ios() {
        return this.ios;
    }

    public final OverrideButtonConfiguration web() {
        return this.web;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.android());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ios());
        hashCode = 31 * hashCode + Objects.hashCode(this.web());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageButton)) {
            return false;
        }
        InAppMessageButton other = (InAppMessageButton)obj;
        return Objects.equals(this.android(), other.android()) && Objects.equals(this.defaultConfig(), other.defaultConfig()) && Objects.equals(this.ios(), other.ios()) && Objects.equals(this.web(), other.web());
    }

    public final String toString() {
        return ToString.builder((String)"InAppMessageButton").add("Android", (Object)this.android()).add("DefaultConfig", (Object)this.defaultConfig()).add("IOS", (Object)this.ios()).add("Web", (Object)this.web()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Android": {
                return Optional.ofNullable(clazz.cast(this.android()));
            }
            case "DefaultConfig": {
                return Optional.ofNullable(clazz.cast(this.defaultConfig()));
            }
            case "IOS": {
                return Optional.ofNullable(clazz.cast(this.ios()));
            }
            case "Web": {
                return Optional.ofNullable(clazz.cast(this.web()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageButton, T> g) {
        return obj -> g.apply((InAppMessageButton)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OverrideButtonConfiguration android;
        private DefaultButtonConfiguration defaultConfig;
        private OverrideButtonConfiguration ios;
        private OverrideButtonConfiguration web;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageButton model) {
            this.android(model.android);
            this.defaultConfig(model.defaultConfig);
            this.ios(model.ios);
            this.web(model.web);
        }

        public final OverrideButtonConfiguration.Builder getAndroid() {
            return this.android != null ? this.android.toBuilder() : null;
        }

        public final void setAndroid(OverrideButtonConfiguration.BuilderImpl android) {
            this.android = android != null ? android.build() : null;
        }

        @Override
        @Transient
        public final Builder android(OverrideButtonConfiguration android) {
            this.android = android;
            return this;
        }

        public final DefaultButtonConfiguration.Builder getDefaultConfig() {
            return this.defaultConfig != null ? this.defaultConfig.toBuilder() : null;
        }

        public final void setDefaultConfig(DefaultButtonConfiguration.BuilderImpl defaultConfig) {
            this.defaultConfig = defaultConfig != null ? defaultConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder defaultConfig(DefaultButtonConfiguration defaultConfig) {
            this.defaultConfig = defaultConfig;
            return this;
        }

        public final OverrideButtonConfiguration.Builder getIos() {
            return this.ios != null ? this.ios.toBuilder() : null;
        }

        public final void setIos(OverrideButtonConfiguration.BuilderImpl ios) {
            this.ios = ios != null ? ios.build() : null;
        }

        @Override
        @Transient
        public final Builder ios(OverrideButtonConfiguration ios) {
            this.ios = ios;
            return this;
        }

        public final OverrideButtonConfiguration.Builder getWeb() {
            return this.web != null ? this.web.toBuilder() : null;
        }

        public final void setWeb(OverrideButtonConfiguration.BuilderImpl web) {
            this.web = web != null ? web.build() : null;
        }

        @Override
        @Transient
        public final Builder web(OverrideButtonConfiguration web) {
            this.web = web;
            return this;
        }

        public InAppMessageButton build() {
            return new InAppMessageButton(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InAppMessageButton> {
        public Builder android(OverrideButtonConfiguration var1);

        default public Builder android(Consumer<OverrideButtonConfiguration.Builder> android) {
            return this.android((OverrideButtonConfiguration)((OverrideButtonConfiguration.Builder)OverrideButtonConfiguration.builder().applyMutation(android)).build());
        }

        public Builder defaultConfig(DefaultButtonConfiguration var1);

        default public Builder defaultConfig(Consumer<DefaultButtonConfiguration.Builder> defaultConfig) {
            return this.defaultConfig((DefaultButtonConfiguration)((DefaultButtonConfiguration.Builder)DefaultButtonConfiguration.builder().applyMutation(defaultConfig)).build());
        }

        public Builder ios(OverrideButtonConfiguration var1);

        default public Builder ios(Consumer<OverrideButtonConfiguration.Builder> ios) {
            return this.ios((OverrideButtonConfiguration)((OverrideButtonConfiguration.Builder)OverrideButtonConfiguration.builder().applyMutation(ios)).build());
        }

        public Builder web(OverrideButtonConfiguration var1);

        default public Builder web(Consumer<OverrideButtonConfiguration.Builder> web) {
            return this.web((OverrideButtonConfiguration)((OverrideButtonConfiguration.Builder)OverrideButtonConfiguration.builder().applyMutation(web)).build());
        }
    }
}

