/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApnsVoipChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<UpdateApnsVoipChannelResponse.Builder, UpdateApnsVoipChannelResponse> {
    private static final SdkField<APNSVoipChannelResponse> APNS_VOIP_CHANNEL_RESPONSE_FIELD = SdkField
            .<APNSVoipChannelResponse> builder(MarshallingType.SDK_POJO)
            .memberName("APNSVoipChannelResponse")
            .getter(getter(UpdateApnsVoipChannelResponse::apnsVoipChannelResponse))
            .setter(setter(Builder::apnsVoipChannelResponse))
            .constructor(APNSVoipChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSVoipChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APNS_VOIP_CHANNEL_RESPONSE_FIELD));

    private final APNSVoipChannelResponse apnsVoipChannelResponse;

    private UpdateApnsVoipChannelResponse(BuilderImpl builder) {
        super(builder);
        this.apnsVoipChannelResponse = builder.apnsVoipChannelResponse;
    }

    /**
     * Returns the value of the APNSVoipChannelResponse property for this object.
     * 
     * @return The value of the APNSVoipChannelResponse property for this object.
     */
    public final APNSVoipChannelResponse apnsVoipChannelResponse() {
        return apnsVoipChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apnsVoipChannelResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApnsVoipChannelResponse)) {
            return false;
        }
        UpdateApnsVoipChannelResponse other = (UpdateApnsVoipChannelResponse) obj;
        return Objects.equals(apnsVoipChannelResponse(), other.apnsVoipChannelResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApnsVoipChannelResponse").add("APNSVoipChannelResponse", apnsVoipChannelResponse())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "APNSVoipChannelResponse":
            return Optional.ofNullable(clazz.cast(apnsVoipChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApnsVoipChannelResponse, T> g) {
        return obj -> g.apply((UpdateApnsVoipChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateApnsVoipChannelResponse> {
        /**
         * Sets the value of the APNSVoipChannelResponse property for this object.
         *
         * @param apnsVoipChannelResponse
         *        The new value for the APNSVoipChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsVoipChannelResponse(APNSVoipChannelResponse apnsVoipChannelResponse);

        /**
         * Sets the value of the APNSVoipChannelResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link APNSVoipChannelResponse.Builder} avoiding
         * the need to create one manually via {@link APNSVoipChannelResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APNSVoipChannelResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #apnsVoipChannelResponse(APNSVoipChannelResponse)}.
         * 
         * @param apnsVoipChannelResponse
         *        a consumer that will call methods on {@link APNSVoipChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsVoipChannelResponse(APNSVoipChannelResponse)
         */
        default Builder apnsVoipChannelResponse(Consumer<APNSVoipChannelResponse.Builder> apnsVoipChannelResponse) {
            return apnsVoipChannelResponse(APNSVoipChannelResponse.builder().applyMutation(apnsVoipChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private APNSVoipChannelResponse apnsVoipChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApnsVoipChannelResponse model) {
            super(model);
            apnsVoipChannelResponse(model.apnsVoipChannelResponse);
        }

        public final APNSVoipChannelResponse.Builder getApnsVoipChannelResponse() {
            return apnsVoipChannelResponse != null ? apnsVoipChannelResponse.toBuilder() : null;
        }

        public final void setApnsVoipChannelResponse(APNSVoipChannelResponse.BuilderImpl apnsVoipChannelResponse) {
            this.apnsVoipChannelResponse = apnsVoipChannelResponse != null ? apnsVoipChannelResponse.build() : null;
        }

        @Override
        public final Builder apnsVoipChannelResponse(APNSVoipChannelResponse apnsVoipChannelResponse) {
            this.apnsVoipChannelResponse = apnsVoipChannelResponse;
            return this;
        }

        @Override
        public UpdateApnsVoipChannelResponse build() {
            return new UpdateApnsVoipChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
