/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information from a specified run of a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyRunResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyRunResponse.Builder, JourneyRunResponse> {
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(JourneyRunResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> LAST_UPDATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdateTime").getter(getter(JourneyRunResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(JourneyRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(JourneyRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            LAST_UPDATE_TIME_FIELD, RUN_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String creationTime;

    private final String lastUpdateTime;

    private final String runId;

    private final String status;

    private JourneyRunResponse(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.runId = builder.runId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time when the journey run was created or scheduled, in ISO 8601 format.
     * </p>
     * 
     * @return The time when the journey run was created or scheduled, in ISO 8601 format.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the journey run was updated, in ISO 8601 format..
     * </p>
     * 
     * @return The last time the journey run was updated, in ISO 8601 format..
     */
    public final String lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The unique identifier for the run.
     * </p>
     * 
     * @return The unique identifier for the run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The current status of the journey run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JourneyRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the journey run.
     * @see JourneyRunStatus
     */
    public final JourneyRunStatus status() {
        return JourneyRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the journey run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JourneyRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the journey run.
     * @see JourneyRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyRunResponse)) {
            return false;
        }
        JourneyRunResponse other = (JourneyRunResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(runId(), other.runId()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneyRunResponse").add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("RunId", runId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyRunResponse, T> g) {
        return obj -> g.apply((JourneyRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyRunResponse> {
        /**
         * <p>
         * The time when the journey run was created or scheduled, in ISO 8601 format.
         * </p>
         * 
         * @param creationTime
         *        The time when the journey run was created or scheduled, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The last time the journey run was updated, in ISO 8601 format..
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the journey run was updated, in ISO 8601 format..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(String lastUpdateTime);

        /**
         * <p>
         * The unique identifier for the run.
         * </p>
         * 
         * @param runId
         *        The unique identifier for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The current status of the journey run.
         * </p>
         * 
         * @param status
         *        The current status of the journey run.
         * @see JourneyRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JourneyRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the journey run.
         * </p>
         * 
         * @param status
         *        The current status of the journey run.
         * @see JourneyRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JourneyRunStatus
         */
        Builder status(JourneyRunStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String creationTime;

        private String lastUpdateTime;

        private String runId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyRunResponse model) {
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            runId(model.runId);
            status(model.status);
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(String lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(String lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JourneyRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public JourneyRunResponse build() {
            return new JourneyRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
