/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.TemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SMSTemplateResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SMSTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(SMSTemplateResponse.getter(SMSTemplateResponse::arn)).setter(SMSTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(SMSTemplateResponse.getter(SMSTemplateResponse::body)).setter(SMSTemplateResponse.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(SMSTemplateResponse.getter(SMSTemplateResponse::creationDate)).setter(SMSTemplateResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSubstitutions").getter(SMSTemplateResponse.getter(SMSTemplateResponse::defaultSubstitutions)).setter(SMSTemplateResponse.setter(Builder::defaultSubstitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(SMSTemplateResponse.getter(SMSTemplateResponse::lastModifiedDate)).setter(SMSTemplateResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderId").getter(SMSTemplateResponse.getter(SMSTemplateResponse::recommenderId)).setter(SMSTemplateResponse.setter(Builder::recommenderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SMSTemplateResponse.getter(SMSTemplateResponse::tags)).setter(SMSTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateDescription").getter(SMSTemplateResponse.getter(SMSTemplateResponse::templateDescription)).setter(SMSTemplateResponse.setter(Builder::templateDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(SMSTemplateResponse.getter(SMSTemplateResponse::templateName)).setter(SMSTemplateResponse.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(SMSTemplateResponse.getter(SMSTemplateResponse::templateTypeAsString)).setter(SMSTemplateResponse.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(SMSTemplateResponse.getter(SMSTemplateResponse::version)).setter(SMSTemplateResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BODY_FIELD, CREATION_DATE_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, LAST_MODIFIED_DATE_FIELD, RECOMMENDER_ID_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String body;
    private final String creationDate;
    private final String defaultSubstitutions;
    private final String lastModifiedDate;
    private final String recommenderId;
    private final Map<String, String> tags;
    private final String templateDescription;
    private final String templateName;
    private final String templateType;
    private final String version;

    private SMSTemplateResponse(BuilderImpl builder) {
        this.arn = builder.arn;
        this.body = builder.body;
        this.creationDate = builder.creationDate;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.recommenderId = builder.recommenderId;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.version = builder.version;
    }

    public final String arn() {
        return this.arn;
    }

    public final String body() {
        return this.body;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String defaultSubstitutions() {
        return this.defaultSubstitutions;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String recommenderId() {
        return this.recommenderId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String templateDescription() {
        return this.templateDescription;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final TemplateType templateType() {
        return TemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSTemplateResponse)) {
            return false;
        }
        SMSTemplateResponse other = (SMSTemplateResponse)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.defaultSubstitutions(), other.defaultSubstitutions()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.recommenderId(), other.recommenderId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templateDescription(), other.templateDescription()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"SMSTemplateResponse").add("Arn", (Object)this.arn()).add("Body", (Object)this.body()).add("CreationDate", (Object)this.creationDate()).add("DefaultSubstitutions", (Object)this.defaultSubstitutions()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("RecommenderId", (Object)this.recommenderId()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateDescription", (Object)this.templateDescription()).add("TemplateName", (Object)this.templateName()).add("TemplateType", (Object)this.templateTypeAsString()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "DefaultSubstitutions": {
                return Optional.ofNullable(clazz.cast(this.defaultSubstitutions()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "RecommenderId": {
                return Optional.ofNullable(clazz.cast(this.recommenderId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateDescription": {
                return Optional.ofNullable(clazz.cast(this.templateDescription()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SMSTemplateResponse, T> g) {
        return obj -> g.apply((SMSTemplateResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String body;
        private String creationDate;
        private String defaultSubstitutions;
        private String lastModifiedDate;
        private String recommenderId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String templateDescription;
        private String templateName;
        private String templateType;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSTemplateResponse model) {
            this.arn(model.arn);
            this.body(model.body);
            this.creationDate(model.creationDate);
            this.defaultSubstitutions(model.defaultSubstitutions);
            this.lastModifiedDate(model.lastModifiedDate);
            this.recommenderId(model.recommenderId);
            this.tags(model.tags);
            this.templateDescription(model.templateDescription);
            this.templateName(model.templateName);
            this.templateType(model.templateType);
            this.version(model.version);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDefaultSubstitutions() {
            return this.defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getRecommenderId() {
            return this.recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return this.templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public SMSTemplateResponse build() {
            return new SMSTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SMSTemplateResponse> {
        public Builder arn(String var1);

        public Builder body(String var1);

        public Builder creationDate(String var1);

        public Builder defaultSubstitutions(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder recommenderId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder templateDescription(String var1);

        public Builder templateName(String var1);

        public Builder templateType(String var1);

        public Builder templateType(TemplateType var1);

        public Builder version(String var1);
    }
}

