/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJourneyRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateJourneyRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateJourneyRequest.getter(UpdateJourneyRequest::applicationId)).setter(UpdateJourneyRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> JOURNEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JourneyId").getter(UpdateJourneyRequest.getter(UpdateJourneyRequest::journeyId)).setter(UpdateJourneyRequest.setter(Builder::journeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("journey-id").build()}).build();
    private static final SdkField<WriteJourneyRequest> WRITE_JOURNEY_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WriteJourneyRequest").getter(UpdateJourneyRequest.getter(UpdateJourneyRequest::writeJourneyRequest)).setter(UpdateJourneyRequest.setter(Builder::writeJourneyRequest)).constructor(WriteJourneyRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteJourneyRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, JOURNEY_ID_FIELD, WRITE_JOURNEY_REQUEST_FIELD));
    private final String applicationId;
    private final String journeyId;
    private final WriteJourneyRequest writeJourneyRequest;

    private UpdateJourneyRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.journeyId = builder.journeyId;
        this.writeJourneyRequest = builder.writeJourneyRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String journeyId() {
        return this.journeyId;
    }

    public final WriteJourneyRequest writeJourneyRequest() {
        return this.writeJourneyRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.journeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeJourneyRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJourneyRequest)) {
            return false;
        }
        UpdateJourneyRequest other = (UpdateJourneyRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.journeyId(), other.journeyId()) && Objects.equals(this.writeJourneyRequest(), other.writeJourneyRequest());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateJourneyRequest").add("ApplicationId", (Object)this.applicationId()).add("JourneyId", (Object)this.journeyId()).add("WriteJourneyRequest", (Object)this.writeJourneyRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "JourneyId": {
                return Optional.ofNullable(clazz.cast(this.journeyId()));
            }
            case "WriteJourneyRequest": {
                return Optional.ofNullable(clazz.cast(this.writeJourneyRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateJourneyRequest, T> g) {
        return obj -> g.apply((UpdateJourneyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String journeyId;
        private WriteJourneyRequest writeJourneyRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJourneyRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.journeyId(model.journeyId);
            this.writeJourneyRequest(model.writeJourneyRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJourneyId() {
            return this.journeyId;
        }

        public final void setJourneyId(String journeyId) {
            this.journeyId = journeyId;
        }

        @Override
        public final Builder journeyId(String journeyId) {
            this.journeyId = journeyId;
            return this;
        }

        public final WriteJourneyRequest.Builder getWriteJourneyRequest() {
            return this.writeJourneyRequest != null ? this.writeJourneyRequest.toBuilder() : null;
        }

        public final void setWriteJourneyRequest(WriteJourneyRequest.BuilderImpl writeJourneyRequest) {
            this.writeJourneyRequest = writeJourneyRequest != null ? writeJourneyRequest.build() : null;
        }

        @Override
        public final Builder writeJourneyRequest(WriteJourneyRequest writeJourneyRequest) {
            this.writeJourneyRequest = writeJourneyRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJourneyRequest build() {
            return new UpdateJourneyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJourneyRequest> {
        public Builder applicationId(String var1);

        public Builder journeyId(String var1);

        public Builder writeJourneyRequest(WriteJourneyRequest var1);

        default public Builder writeJourneyRequest(Consumer<WriteJourneyRequest.Builder> writeJourneyRequest) {
            return this.writeJourneyRequest((WriteJourneyRequest)((WriteJourneyRequest.Builder)WriteJourneyRequest.builder().applyMutation(writeJourneyRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

