/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.pinpoint.internal.PinpointServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.pinpoint.model.BadRequestException;
import software.amazon.awssdk.services.pinpoint.model.ConflictException;
import software.amazon.awssdk.services.pinpoint.model.CreateAppRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateAppResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.ForbiddenException;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetInAppMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetInAppMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRunsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.InternalServerErrorException;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysRequest;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesResponse;
import software.amazon.awssdk.services.pinpoint.model.MethodNotAllowedException;
import software.amazon.awssdk.services.pinpoint.model.NotFoundException;
import software.amazon.awssdk.services.pinpoint.model.PayloadTooLargeException;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateRequest;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateResponse;
import software.amazon.awssdk.services.pinpoint.model.PinpointException;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventsResponse;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesRequest;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest;
import software.amazon.awssdk.services.pinpoint.model.SendOtpMessageResponse;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageRequest;
import software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse;
import software.amazon.awssdk.services.pinpoint.transform.CreateAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeletePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetAppsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignActivitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetChannelsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetInAppMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyDateRangeKpiRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionActivityMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyExecutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunExecutionActivityMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunExecutionMetricsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetJourneyRunsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetPushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetRecommenderConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentExportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetUserEndpointsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListJourneysRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PhoneNumberValidateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.RemoveAttributesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendOtpMessageRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendUsersMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateAdmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsVoipSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateBaiduChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointsBatchRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateInAppTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateJourneyStateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdatePushTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateRecommenderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateTemplateActiveVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateVoiceTemplateRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.VerifyOtpMessageRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link PinpointAsyncClient}.
 *
 * @see PinpointAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPinpointAsyncClient implements PinpointAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultPinpointAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPinpointAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAppRequest, CreateAppResponse>().withOperationName("CreateApp")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAppRequest));
            CompletableFuture<CreateAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     * </p>
     *
     * @param createCampaignRequest
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCampaignRequest, CreateCampaignResponse>()
                            .withOperationName("CreateCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCampaignRequest));
            CompletableFuture<CreateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param createEmailTemplateRequest
     * @return A Java Future containing the result of the CreateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(
            CreateEmailTemplateRequest createEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEmailTemplateRequest, CreateEmailTemplateResponse>()
                            .withOperationName("CreateEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEmailTemplateRequest));
            CompletableFuture<CreateEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an export job for an application.
     * </p>
     *
     * @param createExportJobRequest
     * @return A Java Future containing the result of the CreateExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateExportJobResponse> createExportJob(CreateExportJobRequest createExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateExportJobRequest, CreateExportJobResponse>()
                            .withOperationName("CreateExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createExportJobRequest));
            CompletableFuture<CreateExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an import job for an application.
     * </p>
     *
     * @param createImportJobRequest
     * @return A Java Future containing the result of the CreateImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImportJobResponse> createImportJob(CreateImportJobRequest createImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImportJobRequest, CreateImportJobResponse>()
                            .withOperationName("CreateImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImportJobRequest));
            CompletableFuture<CreateImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new message template for messages using the in-app message channel.
     * </p>
     *
     * @param createInAppTemplateRequest
     * @return A Java Future containing the result of the CreateInAppTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateInAppTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInAppTemplateResponse> createInAppTemplate(
            CreateInAppTemplateRequest createInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInAppTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInAppTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInAppTemplateRequest, CreateInAppTemplateResponse>()
                            .withOperationName("CreateInAppTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInAppTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInAppTemplateRequest));
            CompletableFuture<CreateInAppTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a journey for an application.
     * </p>
     *
     * @param createJourneyRequest
     * @return A Java Future containing the result of the CreateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateJourneyResponse> createJourney(CreateJourneyRequest createJourneyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateJourneyRequest, CreateJourneyResponse>()
                            .withOperationName("CreateJourney").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createJourneyRequest));
            CompletableFuture<CreateJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param createPushTemplateRequest
     * @return A Java Future containing the result of the CreatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePushTemplateResponse> createPushTemplate(CreatePushTemplateRequest createPushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePushTemplateRequest, CreatePushTemplateResponse>()
                            .withOperationName("CreatePushTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPushTemplateRequest));
            CompletableFuture<CreatePushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param createRecommenderConfigurationRequest
     * @return A Java Future containing the result of the CreateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRecommenderConfigurationResponse> createRecommenderConfiguration(
            CreateRecommenderConfigurationRequest createRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRecommenderConfigurationRequest, CreateRecommenderConfigurationResponse>()
                            .withOperationName("CreateRecommenderConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRecommenderConfigurationRequest));
            CompletableFuture<CreateRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param createSegmentRequest
     * @return A Java Future containing the result of the CreateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSegmentResponse> createSegment(CreateSegmentRequest createSegmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSegmentRequest, CreateSegmentResponse>()
                            .withOperationName("CreateSegment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSegmentRequest));
            CompletableFuture<CreateSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param createSmsTemplateRequest
     * @return A Java Future containing the result of the CreateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSmsTemplateResponse> createSmsTemplate(CreateSmsTemplateRequest createSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSmsTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSmsTemplateRequest, CreateSmsTemplateResponse>()
                            .withOperationName("CreateSmsTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSmsTemplateRequest));
            CompletableFuture<CreateSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param createVoiceTemplateRequest
     * @return A Java Future containing the result of the CreateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVoiceTemplateResponse> createVoiceTemplate(
            CreateVoiceTemplateRequest createVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVoiceTemplateRequest, CreateVoiceTemplateResponse>()
                            .withOperationName("CreateVoiceTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVoiceTemplateRequest));
            CompletableFuture<CreateVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteAdmChannelRequest
     * @return A Java Future containing the result of the DeleteAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAdmChannelResponse> deleteAdmChannel(DeleteAdmChannelRequest deleteAdmChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAdmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAdmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAdmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAdmChannelRequest, DeleteAdmChannelResponse>()
                            .withOperationName("DeleteAdmChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAdmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAdmChannelRequest));
            CompletableFuture<DeleteAdmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsChannelRequest
     * @return A Java Future containing the result of the DeleteApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsChannelResponse> deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsChannelRequest, DeleteApnsChannelResponse>()
                            .withOperationName("DeleteApnsChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApnsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApnsChannelRequest));
            CompletableFuture<DeleteApnsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsSandboxChannelRequest
     * @return A Java Future containing the result of the DeleteApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsSandboxChannelResponse> deleteApnsSandboxChannel(
            DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsSandboxChannelRequest, DeleteApnsSandboxChannelResponse>()
                            .withOperationName("DeleteApnsSandboxChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApnsSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApnsSandboxChannelRequest));
            CompletableFuture<DeleteApnsSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipChannelRequest
     * @return A Java Future containing the result of the DeleteApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsVoipChannelResponse> deleteApnsVoipChannel(
            DeleteApnsVoipChannelRequest deleteApnsVoipChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsVoipChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsVoipChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsVoipChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsVoipChannelRequest, DeleteApnsVoipChannelResponse>()
                            .withOperationName("DeleteApnsVoipChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApnsVoipChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApnsVoipChannelRequest));
            CompletableFuture<DeleteApnsVoipChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the DeleteApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteApnsVoipSandboxChannelResponse> deleteApnsVoipSandboxChannel(
            DeleteApnsVoipSandboxChannelRequest deleteApnsVoipSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApnsVoipSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteApnsVoipSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteApnsVoipSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteApnsVoipSandboxChannelRequest, DeleteApnsVoipSandboxChannelResponse>()
                            .withOperationName("DeleteApnsVoipSandboxChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteApnsVoipSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteApnsVoipSandboxChannelRequest));
            CompletableFuture<DeleteApnsVoipSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAppRequest, DeleteAppResponse>().withOperationName("DeleteApp")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAppRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAppRequest));
            CompletableFuture<DeleteAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteBaiduChannelRequest
     * @return A Java Future containing the result of the DeleteBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBaiduChannelResponse> deleteBaiduChannel(DeleteBaiduChannelRequest deleteBaiduChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBaiduChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBaiduChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBaiduChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBaiduChannelRequest, DeleteBaiduChannelResponse>()
                            .withOperationName("DeleteBaiduChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBaiduChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBaiduChannelRequest));
            CompletableFuture<DeleteBaiduChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a campaign from an application.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCampaignRequest, DeleteCampaignResponse>()
                            .withOperationName("DeleteCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCampaignRequest));
            CompletableFuture<DeleteCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the email channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteEmailChannelRequest
     * @return A Java Future containing the result of the DeleteEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailChannelResponse> deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEmailChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEmailChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailChannelRequest, DeleteEmailChannelResponse>()
                            .withOperationName("DeleteEmailChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEmailChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEmailChannelRequest));
            CompletableFuture<DeleteEmailChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the email channel.
     * </p>
     *
     * @param deleteEmailTemplateRequest
     * @return A Java Future containing the result of the DeleteEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(
            DeleteEmailTemplateRequest deleteEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailTemplateRequest, DeleteEmailTemplateResponse>()
                            .withOperationName("DeleteEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEmailTemplateRequest));
            CompletableFuture<DeleteEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an endpoint from an application.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                            .withOperationName("DeleteEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointRequest));
            CompletableFuture<DeleteEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the event stream for an application.
     * </p>
     *
     * @param deleteEventStreamRequest
     * @return A Java Future containing the result of the DeleteEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventStreamResponse> deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventStreamRequest, DeleteEventStreamResponse>()
                            .withOperationName("DeleteEventStream").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventStreamRequest));
            CompletableFuture<DeleteEventStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteGcmChannelRequest
     * @return A Java Future containing the result of the DeleteGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGcmChannelResponse> deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGcmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGcmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGcmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGcmChannelRequest, DeleteGcmChannelResponse>()
                            .withOperationName("DeleteGcmChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGcmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGcmChannelRequest));
            CompletableFuture<DeleteGcmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages sent using the in-app message channel.
     * </p>
     *
     * @param deleteInAppTemplateRequest
     * @return A Java Future containing the result of the DeleteInAppTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteInAppTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInAppTemplateResponse> deleteInAppTemplate(
            DeleteInAppTemplateRequest deleteInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInAppTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInAppTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInAppTemplateRequest, DeleteInAppTemplateResponse>()
                            .withOperationName("DeleteInAppTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInAppTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInAppTemplateRequest));
            CompletableFuture<DeleteInAppTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a journey from an application.
     * </p>
     *
     * @param deleteJourneyRequest
     * @return A Java Future containing the result of the DeleteJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteJourneyResponse> deleteJourney(DeleteJourneyRequest deleteJourneyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteJourneyRequest, DeleteJourneyResponse>()
                            .withOperationName("DeleteJourney").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteJourneyRequest));
            CompletableFuture<DeleteJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through a push notification channel.
     * </p>
     *
     * @param deletePushTemplateRequest
     * @return A Java Future containing the result of the DeletePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeletePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePushTemplateResponse> deletePushTemplate(DeletePushTemplateRequest deletePushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePushTemplateRequest, DeletePushTemplateResponse>()
                            .withOperationName("DeletePushTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePushTemplateRequest));
            CompletableFuture<DeletePushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param deleteRecommenderConfigurationRequest
     * @return A Java Future containing the result of the DeleteRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRecommenderConfigurationResponse> deleteRecommenderConfiguration(
            DeleteRecommenderConfigurationRequest deleteRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRecommenderConfigurationRequest, DeleteRecommenderConfigurationResponse>()
                            .withOperationName("DeleteRecommenderConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRecommenderConfigurationRequest));
            CompletableFuture<DeleteRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a segment from an application.
     * </p>
     *
     * @param deleteSegmentRequest
     * @return A Java Future containing the result of the DeleteSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSegmentResponse> deleteSegment(DeleteSegmentRequest deleteSegmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSegmentRequest, DeleteSegmentResponse>()
                            .withOperationName("DeleteSegment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSegmentRequest));
            CompletableFuture<DeleteSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteSmsChannelRequest
     * @return A Java Future containing the result of the DeleteSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSmsChannelResponse> deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSmsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSmsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSmsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSmsChannelRequest, DeleteSmsChannelResponse>()
                            .withOperationName("DeleteSmsChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSmsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSmsChannelRequest));
            CompletableFuture<DeleteSmsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the SMS channel.
     * </p>
     *
     * @param deleteSmsTemplateRequest
     * @return A Java Future containing the result of the DeleteSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSmsTemplateResponse> deleteSmsTemplate(DeleteSmsTemplateRequest deleteSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSmsTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSmsTemplateRequest, DeleteSmsTemplateResponse>()
                            .withOperationName("DeleteSmsTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSmsTemplateRequest));
            CompletableFuture<DeleteSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param deleteUserEndpointsRequest
     * @return A Java Future containing the result of the DeleteUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserEndpointsResponse> deleteUserEndpoints(
            DeleteUserEndpointsRequest deleteUserEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserEndpointsRequest, DeleteUserEndpointsResponse>()
                            .withOperationName("DeleteUserEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserEndpointsRequest));
            CompletableFuture<DeleteUserEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteVoiceChannelRequest
     * @return A Java Future containing the result of the DeleteVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceChannelResponse> deleteVoiceChannel(DeleteVoiceChannelRequest deleteVoiceChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVoiceChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceChannelRequest, DeleteVoiceChannelResponse>()
                            .withOperationName("DeleteVoiceChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVoiceChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVoiceChannelRequest));
            CompletableFuture<DeleteVoiceChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the voice channel.
     * </p>
     *
     * @param deleteVoiceTemplateRequest
     * @return A Java Future containing the result of the DeleteVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVoiceTemplateResponse> deleteVoiceTemplate(
            DeleteVoiceTemplateRequest deleteVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVoiceTemplateRequest, DeleteVoiceTemplateResponse>()
                            .withOperationName("DeleteVoiceTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVoiceTemplateRequest));
            CompletableFuture<DeleteVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the ADM channel for an application.
     * </p>
     *
     * @param getAdmChannelRequest
     * @return A Java Future containing the result of the GetAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAdmChannelResponse> getAdmChannel(GetAdmChannelRequest getAdmChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAdmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAdmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAdmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAdmChannelRequest, GetAdmChannelResponse>()
                            .withOperationName("GetAdmChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAdmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAdmChannelRequest));
            CompletableFuture<GetAdmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs channel for an application.
     * </p>
     *
     * @param getApnsChannelRequest
     * @return A Java Future containing the result of the GetApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsChannelResponse> getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsChannelRequest, GetApnsChannelResponse>()
                            .withOperationName("GetApnsChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApnsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApnsChannelRequest));
            CompletableFuture<GetApnsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     * </p>
     *
     * @param getApnsSandboxChannelRequest
     * @return A Java Future containing the result of the GetApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsSandboxChannelResponse> getApnsSandboxChannel(
            GetApnsSandboxChannelRequest getApnsSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsSandboxChannelRequest, GetApnsSandboxChannelResponse>()
                            .withOperationName("GetApnsSandboxChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApnsSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApnsSandboxChannelRequest));
            CompletableFuture<GetApnsSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     * </p>
     *
     * @param getApnsVoipChannelRequest
     * @return A Java Future containing the result of the GetApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsVoipChannelResponse> getApnsVoipChannel(GetApnsVoipChannelRequest getApnsVoipChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsVoipChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsVoipChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsVoipChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsVoipChannelRequest, GetApnsVoipChannelResponse>()
                            .withOperationName("GetApnsVoipChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApnsVoipChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApnsVoipChannelRequest));
            CompletableFuture<GetApnsVoipChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     * </p>
     *
     * @param getApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the GetApnsVoipSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApnsVoipSandboxChannelResponse> getApnsVoipSandboxChannel(
            GetApnsVoipSandboxChannelRequest getApnsVoipSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApnsVoipSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApnsVoipSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApnsVoipSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApnsVoipSandboxChannelRequest, GetApnsVoipSandboxChannelResponse>()
                            .withOperationName("GetApnsVoipSandboxChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApnsVoipSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApnsVoipSandboxChannelRequest));
            CompletableFuture<GetApnsVoipSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     *
     * @param getAppRequest
     * @return A Java Future containing the result of the GetApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAppResponse> getApp(GetAppRequest getAppRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAppRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAppRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAppResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAppResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAppResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAppRequest, GetAppResponse>().withOperationName("GetApp")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetAppRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAppRequest));
            CompletableFuture<GetAppResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     * </p>
     *
     * @param getApplicationDateRangeKpiRequest
     * @return A Java Future containing the result of the GetApplicationDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationDateRangeKpiResponse> getApplicationDateRangeKpi(
            GetApplicationDateRangeKpiRequest getApplicationDateRangeKpiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationDateRangeKpiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationDateRangeKpiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApplicationDateRangeKpiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationDateRangeKpiRequest, GetApplicationDateRangeKpiResponse>()
                            .withOperationName("GetApplicationDateRangeKpi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApplicationDateRangeKpiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApplicationDateRangeKpiRequest));
            CompletableFuture<GetApplicationDateRangeKpiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the settings for an application.
     * </p>
     *
     * @param getApplicationSettingsRequest
     * @return A Java Future containing the result of the GetApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetApplicationSettingsResponse> getApplicationSettings(
            GetApplicationSettingsRequest getApplicationSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApplicationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApplicationSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetApplicationSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetApplicationSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetApplicationSettingsRequest, GetApplicationSettingsResponse>()
                            .withOperationName("GetApplicationSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetApplicationSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getApplicationSettingsRequest));
            CompletableFuture<GetApplicationSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param getAppsRequest
     * @return A Java Future containing the result of the GetApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAppsResponse> getApps(GetAppsRequest getAppsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAppsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAppsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAppsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAppsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAppsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAppsRequest, GetAppsResponse>().withOperationName("GetApps")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetAppsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAppsRequest));
            CompletableFuture<GetAppsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the Baidu channel for an application.
     * </p>
     *
     * @param getBaiduChannelRequest
     * @return A Java Future containing the result of the GetBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBaiduChannelResponse> getBaiduChannel(GetBaiduChannelRequest getBaiduChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBaiduChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBaiduChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBaiduChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBaiduChannelRequest, GetBaiduChannelResponse>()
                            .withOperationName("GetBaiduChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBaiduChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBaiduChannelRequest));
            CompletableFuture<GetBaiduChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return A Java Future containing the result of the GetCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignResponse> getCampaign(GetCampaignRequest getCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignRequest, GetCampaignResponse>()
                            .withOperationName("GetCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignRequest));
            CompletableFuture<GetCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the activities for a campaign.
     * </p>
     *
     * @param getCampaignActivitiesRequest
     * @return A Java Future containing the result of the GetCampaignActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignActivitiesResponse> getCampaignActivities(
            GetCampaignActivitiesRequest getCampaignActivitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignActivitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignActivitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignActivities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignActivitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignActivitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignActivitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignActivitiesRequest, GetCampaignActivitiesResponse>()
                            .withOperationName("GetCampaignActivities").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignActivitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignActivitiesRequest));
            CompletableFuture<GetCampaignActivitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     * </p>
     *
     * @param getCampaignDateRangeKpiRequest
     * @return A Java Future containing the result of the GetCampaignDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignDateRangeKpiResponse> getCampaignDateRangeKpi(
            GetCampaignDateRangeKpiRequest getCampaignDateRangeKpiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignDateRangeKpiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignDateRangeKpiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignDateRangeKpiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignDateRangeKpiRequest, GetCampaignDateRangeKpiResponse>()
                            .withOperationName("GetCampaignDateRangeKpi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignDateRangeKpiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignDateRangeKpiRequest));
            CompletableFuture<GetCampaignDateRangeKpiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     * </p>
     *
     * @param getCampaignVersionRequest
     * @return A Java Future containing the result of the GetCampaignVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignVersionResponse> getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignVersionRequest, GetCampaignVersionResponse>()
                            .withOperationName("GetCampaignVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignVersionRequest));
            CompletableFuture<GetCampaignVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     * </p>
     *
     * @param getCampaignVersionsRequest
     * @return A Java Future containing the result of the GetCampaignVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignVersionsResponse> getCampaignVersions(
            GetCampaignVersionsRequest getCampaignVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaignVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCampaignVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignVersionsRequest, GetCampaignVersionsResponse>()
                            .withOperationName("GetCampaignVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignVersionsRequest));
            CompletableFuture<GetCampaignVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are
     * associated with an application.
     * </p>
     *
     * @param getCampaignsRequest
     * @return A Java Future containing the result of the GetCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCampaignsResponse> getCampaigns(GetCampaignsRequest getCampaignsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCampaignsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCampaignsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCampaigns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCampaignsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCampaignsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCampaignsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCampaignsRequest, GetCampaignsResponse>()
                            .withOperationName("GetCampaigns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCampaignsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCampaignsRequest));
            CompletableFuture<GetCampaignsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the history and status of each channel for an application.
     * </p>
     *
     * @param getChannelsRequest
     * @return A Java Future containing the result of the GetChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetChannelsResponse> getChannels(GetChannelsRequest getChannelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetChannelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetChannelsRequest, GetChannelsResponse>()
                            .withOperationName("GetChannels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getChannelsRequest));
            CompletableFuture<GetChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the email channel for an application.
     * </p>
     *
     * @param getEmailChannelRequest
     * @return A Java Future containing the result of the GetEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEmailChannelResponse> getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEmailChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEmailChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEmailChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEmailChannelRequest, GetEmailChannelResponse>()
                            .withOperationName("GetEmailChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEmailChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEmailChannelRequest));
            CompletableFuture<GetEmailChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param getEmailTemplateRequest
     * @return A Java Future containing the result of the GetEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEmailTemplateRequest, GetEmailTemplateResponse>()
                            .withOperationName("GetEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEmailTemplateRequest));
            CompletableFuture<GetEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     * </p>
     *
     * @param getEndpointRequest
     * @return A Java Future containing the result of the GetEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEndpointResponse> getEndpoint(GetEndpointRequest getEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEndpointRequest, GetEndpointResponse>()
                            .withOperationName("GetEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEndpointRequest));
            CompletableFuture<GetEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the event stream settings for an application.
     * </p>
     *
     * @param getEventStreamRequest
     * @return A Java Future containing the result of the GetEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventStreamResponse> getEventStream(GetEventStreamRequest getEventStreamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventStreamRequest, GetEventStreamResponse>()
                            .withOperationName("GetEventStream").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventStreamRequest));
            CompletableFuture<GetEventStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific export job for an application.
     * </p>
     *
     * @param getExportJobRequest
     * @return A Java Future containing the result of the GetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportJobResponse> getExportJob(GetExportJobRequest getExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportJobRequest, GetExportJobResponse>()
                            .withOperationName("GetExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getExportJobRequest));
            CompletableFuture<GetExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the export jobs for an application.
     * </p>
     *
     * @param getExportJobsRequest
     * @return A Java Future containing the result of the GetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportJobsResponse> getExportJobs(GetExportJobsRequest getExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getExportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportJobsRequest, GetExportJobsResponse>()
                            .withOperationName("GetExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getExportJobsRequest));
            CompletableFuture<GetExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the GCM channel for an application.
     * </p>
     *
     * @param getGcmChannelRequest
     * @return A Java Future containing the result of the GetGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGcmChannelResponse> getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGcmChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGcmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGcmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGcmChannelRequest, GetGcmChannelResponse>()
                            .withOperationName("GetGcmChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetGcmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGcmChannelRequest));
            CompletableFuture<GetGcmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific import job for an application.
     * </p>
     *
     * @param getImportJobRequest
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportJobRequest, GetImportJobResponse>()
                            .withOperationName("GetImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImportJobRequest));
            CompletableFuture<GetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the import jobs for an application.
     * </p>
     *
     * @param getImportJobsRequest
     * @return A Java Future containing the result of the GetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetImportJobsResponse> getImportJobs(GetImportJobsRequest getImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImportJobsRequest, GetImportJobsResponse>()
                            .withOperationName("GetImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImportJobsRequest));
            CompletableFuture<GetImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the in-app messages targeted for the provided endpoint ID.
     * </p>
     *
     * @param getInAppMessagesRequest
     * @return A Java Future containing the result of the GetInAppMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetInAppMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetInAppMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInAppMessagesResponse> getInAppMessages(GetInAppMessagesRequest getInAppMessagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInAppMessagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInAppMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInAppMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInAppMessagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInAppMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInAppMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInAppMessagesRequest, GetInAppMessagesResponse>()
                            .withOperationName("GetInAppMessages").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInAppMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInAppMessagesRequest));
            CompletableFuture<GetInAppMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages sent through the in-app channel.
     * </p>
     *
     * @param getInAppTemplateRequest
     * @return A Java Future containing the result of the GetInAppTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetInAppTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInAppTemplateResponse> getInAppTemplate(GetInAppTemplateRequest getInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInAppTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInAppTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInAppTemplateRequest, GetInAppTemplateResponse>()
                            .withOperationName("GetInAppTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetInAppTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInAppTemplateRequest));
            CompletableFuture<GetInAppTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a journey.
     * </p>
     *
     * @param getJourneyRequest
     * @return A Java Future containing the result of the GetJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyResponse> getJourney(GetJourneyRequest getJourneyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyRequest, GetJourneyResponse>().withOperationName("GetJourney")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJourneyRequest));
            CompletableFuture<GetJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     * </p>
     *
     * @param getJourneyDateRangeKpiRequest
     * @return A Java Future containing the result of the GetJourneyDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyDateRangeKpiResponse> getJourneyDateRangeKpi(
            GetJourneyDateRangeKpiRequest getJourneyDateRangeKpiRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyDateRangeKpiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyDateRangeKpiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyDateRangeKpi");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyDateRangeKpiResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetJourneyDateRangeKpiResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyDateRangeKpiResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyDateRangeKpiRequest, GetJourneyDateRangeKpiResponse>()
                            .withOperationName("GetJourneyDateRangeKpi").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJourneyDateRangeKpiRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJourneyDateRangeKpiRequest));
            CompletableFuture<GetJourneyDateRangeKpiResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     * </p>
     *
     * @param getJourneyExecutionActivityMetricsRequest
     * @return A Java Future containing the result of the GetJourneyExecutionActivityMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionActivityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyExecutionActivityMetricsResponse> getJourneyExecutionActivityMetrics(
            GetJourneyExecutionActivityMetricsRequest getJourneyExecutionActivityMetricsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyExecutionActivityMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getJourneyExecutionActivityMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyExecutionActivityMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyExecutionActivityMetricsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetJourneyExecutionActivityMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyExecutionActivityMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyExecutionActivityMetricsRequest, GetJourneyExecutionActivityMetricsResponse>()
                            .withOperationName("GetJourneyExecutionActivityMetrics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJourneyExecutionActivityMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJourneyExecutionActivityMetricsRequest));
            CompletableFuture<GetJourneyExecutionActivityMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     * </p>
     *
     * @param getJourneyExecutionMetricsRequest
     * @return A Java Future containing the result of the GetJourneyExecutionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyExecutionMetricsResponse> getJourneyExecutionMetrics(
            GetJourneyExecutionMetricsRequest getJourneyExecutionMetricsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyExecutionMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyExecutionMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyExecutionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyExecutionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetJourneyExecutionMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyExecutionMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyExecutionMetricsRequest, GetJourneyExecutionMetricsResponse>()
                            .withOperationName("GetJourneyExecutionMetrics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJourneyExecutionMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJourneyExecutionMetricsRequest));
            CompletableFuture<GetJourneyExecutionMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey activity.
     * </p>
     *
     * @param getJourneyRunExecutionActivityMetricsRequest
     * @return A Java Future containing the result of the GetJourneyRunExecutionActivityMetrics operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyRunExecutionActivityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyRunExecutionActivityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyRunExecutionActivityMetricsResponse> getJourneyRunExecutionActivityMetrics(
            GetJourneyRunExecutionActivityMetricsRequest getJourneyRunExecutionActivityMetricsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRunExecutionActivityMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getJourneyRunExecutionActivityMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyRunExecutionActivityMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyRunExecutionActivityMetricsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetJourneyRunExecutionActivityMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyRunExecutionActivityMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyRunExecutionActivityMetricsRequest, GetJourneyRunExecutionActivityMetricsResponse>()
                            .withOperationName("GetJourneyRunExecutionActivityMetrics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJourneyRunExecutionActivityMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJourneyRunExecutionActivityMetricsRequest));
            CompletableFuture<GetJourneyRunExecutionActivityMetricsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey.
     * </p>
     *
     * @param getJourneyRunExecutionMetricsRequest
     * @return A Java Future containing the result of the GetJourneyRunExecutionMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyRunExecutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyRunExecutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyRunExecutionMetricsResponse> getJourneyRunExecutionMetrics(
            GetJourneyRunExecutionMetricsRequest getJourneyRunExecutionMetricsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRunExecutionMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getJourneyRunExecutionMetricsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyRunExecutionMetrics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyRunExecutionMetricsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetJourneyRunExecutionMetricsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyRunExecutionMetricsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyRunExecutionMetricsRequest, GetJourneyRunExecutionMetricsResponse>()
                            .withOperationName("GetJourneyRunExecutionMetrics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJourneyRunExecutionMetricsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJourneyRunExecutionMetricsRequest));
            CompletableFuture<GetJourneyRunExecutionMetricsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about the runs of a journey.
     * </p>
     *
     * @param getJourneyRunsRequest
     * @return A Java Future containing the result of the GetJourneyRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetJourneyRunsResponse> getJourneyRuns(GetJourneyRunsRequest getJourneyRunsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJourneyRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJourneyRunsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJourneyRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJourneyRunsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetJourneyRunsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJourneyRunsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJourneyRunsRequest, GetJourneyRunsResponse>()
                            .withOperationName("GetJourneyRuns").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetJourneyRunsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getJourneyRunsRequest));
            CompletableFuture<GetJourneyRunsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through a push notification
     * channel.
     * </p>
     *
     * @param getPushTemplateRequest
     * @return A Java Future containing the result of the GetPushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetPushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetPushTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPushTemplateResponse> getPushTemplate(GetPushTemplateRequest getPushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPushTemplateRequest, GetPushTemplateResponse>()
                            .withOperationName("GetPushTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPushTemplateRequest));
            CompletableFuture<GetPushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param getRecommenderConfigurationRequest
     * @return A Java Future containing the result of the GetRecommenderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRecommenderConfigurationResponse> getRecommenderConfiguration(
            GetRecommenderConfigurationRequest getRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRecommenderConfigurationRequest, GetRecommenderConfigurationResponse>()
                            .withOperationName("GetRecommenderConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRecommenderConfigurationRequest));
            CompletableFuture<GetRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the recommender model configurations that are associated with your Amazon
     * Pinpoint account.
     * </p>
     *
     * @param getRecommenderConfigurationsRequest
     * @return A Java Future containing the result of the GetRecommenderConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRecommenderConfigurationsResponse> getRecommenderConfigurations(
            GetRecommenderConfigurationsRequest getRecommenderConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecommenderConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRecommenderConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecommenderConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRecommenderConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRecommenderConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRecommenderConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRecommenderConfigurationsRequest, GetRecommenderConfigurationsResponse>()
                            .withOperationName("GetRecommenderConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRecommenderConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRecommenderConfigurationsRequest));
            CompletableFuture<GetRecommenderConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's
     * associated with an application.
     * </p>
     *
     * @param getSegmentRequest
     * @return A Java Future containing the result of the GetSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentResponse> getSegment(GetSegmentRequest getSegmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentRequest, GetSegmentResponse>().withOperationName("GetSegment")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSegmentRequest));
            CompletableFuture<GetSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the export jobs for a segment.
     * </p>
     *
     * @param getSegmentExportJobsRequest
     * @return A Java Future containing the result of the GetSegmentExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentExportJobsResponse> getSegmentExportJobs(
            GetSegmentExportJobsRequest getSegmentExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentExportJobsRequest, GetSegmentExportJobsResponse>()
                            .withOperationName("GetSegmentExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSegmentExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSegmentExportJobsRequest));
            CompletableFuture<GetSegmentExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the import jobs for a segment.
     * </p>
     *
     * @param getSegmentImportJobsRequest
     * @return A Java Future containing the result of the GetSegmentImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentImportJobsResponse> getSegmentImportJobs(
            GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentImportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentImportJobsRequest, GetSegmentImportJobsResponse>()
                            .withOperationName("GetSegmentImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSegmentImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSegmentImportJobsRequest));
            CompletableFuture<GetSegmentImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment
     * that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionRequest
     * @return A Java Future containing the result of the GetSegmentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentVersionResponse> getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentVersionRequest, GetSegmentVersionResponse>()
                            .withOperationName("GetSegmentVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSegmentVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSegmentVersionRequest));
            CompletableFuture<GetSegmentVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific
     * segment that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionsRequest
     * @return A Java Future containing the result of the GetSegmentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentVersionsResponse> getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegmentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSegmentVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentVersionsRequest, GetSegmentVersionsResponse>()
                            .withOperationName("GetSegmentVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSegmentVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSegmentVersionsRequest));
            CompletableFuture<GetSegmentVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are
     * associated with an application.
     * </p>
     *
     * @param getSegmentsRequest
     * @return A Java Future containing the result of the GetSegments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSegmentsResponse> getSegments(GetSegmentsRequest getSegmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSegmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSegmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSegments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSegmentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSegmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSegmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSegmentsRequest, GetSegmentsResponse>()
                            .withOperationName("GetSegments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSegmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSegmentsRequest));
            CompletableFuture<GetSegmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the SMS channel for an application.
     * </p>
     *
     * @param getSmsChannelRequest
     * @return A Java Future containing the result of the GetSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSmsChannelResponse> getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSmsChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSmsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSmsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSmsChannelRequest, GetSmsChannelResponse>()
                            .withOperationName("GetSmsChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSmsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSmsChannelRequest));
            CompletableFuture<GetSmsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param getSmsTemplateRequest
     * @return A Java Future containing the result of the GetSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSmsTemplateResponse> getSmsTemplate(GetSmsTemplateRequest getSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSmsTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSmsTemplateRequest, GetSmsTemplateResponse>()
                            .withOperationName("GetSmsTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSmsTemplateRequest));
            CompletableFuture<GetSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param getUserEndpointsRequest
     * @return A Java Future containing the result of the GetUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserEndpointsResponse> getUserEndpoints(GetUserEndpointsRequest getUserEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUserEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserEndpointsRequest, GetUserEndpointsResponse>()
                            .withOperationName("GetUserEndpoints").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetUserEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUserEndpointsRequest));
            CompletableFuture<GetUserEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the voice channel for an application.
     * </p>
     *
     * @param getVoiceChannelRequest
     * @return A Java Future containing the result of the GetVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceChannelResponse> getVoiceChannel(GetVoiceChannelRequest getVoiceChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVoiceChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceChannelRequest, GetVoiceChannelResponse>()
                            .withOperationName("GetVoiceChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVoiceChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getVoiceChannelRequest));
            CompletableFuture<GetVoiceChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param getVoiceTemplateRequest
     * @return A Java Future containing the result of the GetVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceTemplateResponse> getVoiceTemplate(GetVoiceTemplateRequest getVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceTemplateRequest, GetVoiceTemplateResponse>()
                            .withOperationName("GetVoiceTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getVoiceTemplateRequest));
            CompletableFuture<GetVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the journeys that are
     * associated with an application.
     * </p>
     *
     * @param listJourneysRequest
     * @return A Java Future containing the result of the ListJourneys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListJourneys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListJourneys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListJourneysResponse> listJourneys(ListJourneysRequest listJourneysRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJourneysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJourneysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJourneys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListJourneysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListJourneysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListJourneysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJourneysRequest, ListJourneysResponse>()
                            .withOperationName("ListJourneys").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListJourneysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listJourneysRequest));
            CompletableFuture<ListJourneysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or
     * segment.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the versions of a specific message template.
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A Java Future containing the result of the ListTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplateVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(
            ListTemplateVersionsRequest listTemplateVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTemplateVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTemplateVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTemplateVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTemplateVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTemplateVersionsRequest, ListTemplateVersionsResponse>()
                            .withOperationName("ListTemplateVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTemplateVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTemplateVersionsRequest));
            CompletableFuture<ListTemplateVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param listTemplatesRequest
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTemplatesRequest, ListTemplatesResponse>()
                            .withOperationName("ListTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTemplatesRequest));
            CompletableFuture<ListTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about a phone number.
     * </p>
     *
     * @param phoneNumberValidateRequest
     * @return A Java Future containing the result of the PhoneNumberValidate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PhoneNumberValidate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PhoneNumberValidateResponse> phoneNumberValidate(
            PhoneNumberValidateRequest phoneNumberValidateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(phoneNumberValidateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, phoneNumberValidateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PhoneNumberValidate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PhoneNumberValidateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PhoneNumberValidateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PhoneNumberValidateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PhoneNumberValidateRequest, PhoneNumberValidateResponse>()
                            .withOperationName("PhoneNumberValidate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PhoneNumberValidateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(phoneNumberValidateRequest));
            CompletableFuture<PhoneNumberValidateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new event stream for an application or updates the settings of an existing event stream for an
     * application.
     * </p>
     *
     * @param putEventStreamRequest
     * @return A Java Future containing the result of the PutEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutEventStreamResponse> putEventStream(PutEventStreamRequest putEventStreamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEventStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEventStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEventStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutEventStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEventStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEventStreamRequest, PutEventStreamResponse>()
                            .withOperationName("PutEventStream").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEventStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEventStreamRequest));
            CompletableFuture<PutEventStreamResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are
     * associated with.
     * </p>
     *
     * @param putEventsRequest
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutEventsResponse> putEvents(PutEventsRequest putEventsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEventsRequest, PutEventsResponse>().withOperationName("PutEvents")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEventsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(putEventsRequest));
            CompletableFuture<PutEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more custom attributes, of the same attribute type, from the application. Existing endpoints still
     * have the attributes but Amazon Pinpoint will stop capturing new or changed values for these attributes.
     * </p>
     *
     * @param removeAttributesRequest
     * @return A Java Future containing the result of the RemoveAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.RemoveAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveAttributesResponse> removeAttributes(RemoveAttributesRequest removeAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveAttributesRequest, RemoveAttributesResponse>()
                            .withOperationName("RemoveAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RemoveAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeAttributesRequest));
            CompletableFuture<RemoveAttributesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and sends a direct message.
     * </p>
     *
     * @param sendMessagesRequest
     * @return A Java Future containing the result of the SendMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendMessagesResponse> sendMessages(SendMessagesRequest sendMessagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendMessagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendMessagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SendMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendMessagesRequest, SendMessagesResponse>()
                            .withOperationName("SendMessages").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendMessagesRequest));
            CompletableFuture<SendMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Send an OTP message
     * </p>
     *
     * @param sendOtpMessageRequest
     * @return A Java Future containing the result of the SendOTPMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>PayloadTooLargeException 413 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>MethodNotAllowedException 405 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendOTPMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendOTPMessage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SendOtpMessageResponse> sendOTPMessage(SendOtpMessageRequest sendOtpMessageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendOtpMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendOtpMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendOTPMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendOtpMessageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendOtpMessageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendOtpMessageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendOtpMessageRequest, SendOtpMessageResponse>()
                            .withOperationName("SendOTPMessage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendOtpMessageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendOtpMessageRequest));
            CompletableFuture<SendOtpMessageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and sends a message to a list of users.
     * </p>
     *
     * @param sendUsersMessagesRequest
     * @return A Java Future containing the result of the SendUsersMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendUsersMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SendUsersMessagesResponse> sendUsersMessages(SendUsersMessagesRequest sendUsersMessagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(sendUsersMessagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendUsersMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendUsersMessages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendUsersMessagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendUsersMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendUsersMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendUsersMessagesRequest, SendUsersMessagesResponse>()
                            .withOperationName("SendUsersMessages").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new SendUsersMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(sendUsersMessagesRequest));
            CompletableFuture<SendUsersMessagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an
     * application.
     * </p>
     *
     * @param updateAdmChannelRequest
     * @return A Java Future containing the result of the UpdateAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAdmChannelResponse> updateAdmChannel(UpdateAdmChannelRequest updateAdmChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAdmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAdmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAdmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAdmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAdmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAdmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAdmChannelRequest, UpdateAdmChannelResponse>()
                            .withOperationName("UpdateAdmChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAdmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAdmChannelRequest));
            CompletableFuture<UpdateAdmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an
     * application.
     * </p>
     *
     * @param updateApnsChannelRequest
     * @return A Java Future containing the result of the UpdateApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsChannelResponse> updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsChannelRequest, UpdateApnsChannelResponse>()
                            .withOperationName("UpdateApnsChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApnsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApnsChannelRequest));
            CompletableFuture<UpdateApnsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox
     * channel for an application.
     * </p>
     *
     * @param updateApnsSandboxChannelRequest
     * @return A Java Future containing the result of the UpdateApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsSandboxChannelResponse> updateApnsSandboxChannel(
            UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsSandboxChannelRequest, UpdateApnsSandboxChannelResponse>()
                            .withOperationName("UpdateApnsSandboxChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApnsSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApnsSandboxChannelRequest));
            CompletableFuture<UpdateApnsSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for
     * an application.
     * </p>
     *
     * @param updateApnsVoipChannelRequest
     * @return A Java Future containing the result of the UpdateApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsVoipChannelResponse> updateApnsVoipChannel(
            UpdateApnsVoipChannelRequest updateApnsVoipChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsVoipChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsVoipChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsVoipChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsVoipChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsVoipChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsVoipChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsVoipChannelRequest, UpdateApnsVoipChannelResponse>()
                            .withOperationName("UpdateApnsVoipChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApnsVoipChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApnsVoipChannelRequest));
            CompletableFuture<UpdateApnsVoipChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP
     * sandbox channel for an application.
     * </p>
     *
     * @param updateApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the UpdateApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApnsVoipSandboxChannelResponse> updateApnsVoipSandboxChannel(
            UpdateApnsVoipSandboxChannelRequest updateApnsVoipSandboxChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApnsVoipSandboxChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApnsVoipSandboxChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApnsVoipSandboxChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApnsVoipSandboxChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApnsVoipSandboxChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApnsVoipSandboxChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApnsVoipSandboxChannelRequest, UpdateApnsVoipSandboxChannelResponse>()
                            .withOperationName("UpdateApnsVoipSandboxChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApnsVoipSandboxChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApnsVoipSandboxChannelRequest));
            CompletableFuture<UpdateApnsVoipSandboxChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings for an application.
     * </p>
     *
     * @param updateApplicationSettingsRequest
     * @return A Java Future containing the result of the UpdateApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateApplicationSettingsResponse> updateApplicationSettings(
            UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApplicationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApplicationSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplicationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateApplicationSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateApplicationSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateApplicationSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateApplicationSettingsRequest, UpdateApplicationSettingsResponse>()
                            .withOperationName("UpdateApplicationSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateApplicationSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateApplicationSettingsRequest));
            CompletableFuture<UpdateApplicationSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an
     * application.
     * </p>
     *
     * @param updateBaiduChannelRequest
     * @return A Java Future containing the result of the UpdateBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBaiduChannelResponse> updateBaiduChannel(UpdateBaiduChannelRequest updateBaiduChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBaiduChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBaiduChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBaiduChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBaiduChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBaiduChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBaiduChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBaiduChannelRequest, UpdateBaiduChannelResponse>()
                            .withOperationName("UpdateBaiduChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBaiduChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBaiduChannelRequest));
            CompletableFuture<UpdateBaiduChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration and other settings for a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCampaignResponse> updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCampaignRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCampaignRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCampaign");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCampaignResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCampaignResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCampaignResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCampaignRequest, UpdateCampaignResponse>()
                            .withOperationName("UpdateCampaign").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCampaignRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCampaignRequest));
            CompletableFuture<UpdateCampaignResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the email channel for an application or updates the status and settings of the email channel for an
     * application.
     * </p>
     *
     * @param updateEmailChannelRequest
     * @return A Java Future containing the result of the UpdateEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEmailChannelResponse> updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEmailChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEmailChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEmailChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEmailChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEmailChannelRequest, UpdateEmailChannelResponse>()
                            .withOperationName("UpdateEmailChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEmailChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEmailChannelRequest));
            CompletableFuture<UpdateEmailChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the email channel.
     * </p>
     *
     * @param updateEmailTemplateRequest
     * @return A Java Future containing the result of the UpdateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(
            UpdateEmailTemplateRequest updateEmailTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEmailTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEmailTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEmailTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEmailTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEmailTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEmailTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEmailTemplateRequest, UpdateEmailTemplateResponse>()
                            .withOperationName("UpdateEmailTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEmailTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEmailTemplateRequest));
            CompletableFuture<UpdateEmailTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an
     * application. You can also use this operation to define custom attributes for an endpoint. If an update includes
     * one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new
     * values.
     * </p>
     *
     * @param updateEndpointRequest
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointRequest, UpdateEndpointResponse>()
                            .withOperationName("UpdateEndpoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEndpointRequest));
            CompletableFuture<UpdateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing
     * endpoints for an application. You can also use this operation to define custom attributes for a batch of
     * endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites)
     * any existing values with the new values.
     * </p>
     *
     * @param updateEndpointsBatchRequest
     * @return A Java Future containing the result of the UpdateEndpointsBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpointsBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointsBatchResponse> updateEndpointsBatch(
            UpdateEndpointsBatchRequest updateEndpointsBatchRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEndpointsBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointsBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpointsBatch");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointsBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointsBatchResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEndpointsBatchResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointsBatchRequest, UpdateEndpointsBatchResponse>()
                            .withOperationName("UpdateEndpointsBatch").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEndpointsBatchRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEndpointsBatchRequest));
            CompletableFuture<UpdateEndpointsBatchResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an
     * application.
     * </p>
     *
     * @param updateGcmChannelRequest
     * @return A Java Future containing the result of the UpdateGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGcmChannelResponse> updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGcmChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGcmChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGcmChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGcmChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGcmChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGcmChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGcmChannelRequest, UpdateGcmChannelResponse>()
                            .withOperationName("UpdateGcmChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGcmChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGcmChannelRequest));
            CompletableFuture<UpdateGcmChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages sent through the in-app message channel.
     * </p>
     *
     * @param updateInAppTemplateRequest
     * @return A Java Future containing the result of the UpdateInAppTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateInAppTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateInAppTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInAppTemplateResponse> updateInAppTemplate(
            UpdateInAppTemplateRequest updateInAppTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInAppTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInAppTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInAppTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateInAppTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateInAppTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateInAppTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateInAppTemplateRequest, UpdateInAppTemplateResponse>()
                            .withOperationName("UpdateInAppTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateInAppTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateInAppTemplateRequest));
            CompletableFuture<UpdateInAppTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration and other settings for a journey.
     * </p>
     *
     * @param updateJourneyRequest
     * @return A Java Future containing the result of the UpdateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>ConflictException The request failed due to a conflict with the current state of the specified
     *         resource (ConflictException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateJourneyResponse> updateJourney(UpdateJourneyRequest updateJourneyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJourneyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJourneyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJourney");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateJourneyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateJourneyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateJourneyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJourneyRequest, UpdateJourneyResponse>()
                            .withOperationName("UpdateJourney").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateJourneyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateJourneyRequest));
            CompletableFuture<UpdateJourneyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels (stops) an active journey.
     * </p>
     *
     * @param updateJourneyStateRequest
     * @return A Java Future containing the result of the UpdateJourneyState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourneyState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateJourneyStateResponse> updateJourneyState(UpdateJourneyStateRequest updateJourneyStateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJourneyStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJourneyStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJourneyState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateJourneyStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateJourneyStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateJourneyStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJourneyStateRequest, UpdateJourneyStateResponse>()
                            .withOperationName("UpdateJourneyState").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateJourneyStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateJourneyStateRequest));
            CompletableFuture<UpdateJourneyStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param updatePushTemplateRequest
     * @return A Java Future containing the result of the UpdatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePushTemplateResponse> updatePushTemplate(UpdatePushTemplateRequest updatePushTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePushTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePushTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePushTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePushTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePushTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePushTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePushTemplateRequest, UpdatePushTemplateResponse>()
                            .withOperationName("UpdatePushTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePushTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePushTemplateRequest));
            CompletableFuture<UpdatePushTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param updateRecommenderConfigurationRequest
     * @return A Java Future containing the result of the UpdateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRecommenderConfigurationResponse> updateRecommenderConfiguration(
            UpdateRecommenderConfigurationRequest updateRecommenderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRecommenderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateRecommenderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRecommenderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRecommenderConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRecommenderConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRecommenderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRecommenderConfigurationRequest, UpdateRecommenderConfigurationResponse>()
                            .withOperationName("UpdateRecommenderConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRecommenderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRecommenderConfigurationRequest));
            CompletableFuture<UpdateRecommenderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param updateSegmentRequest
     * @return A Java Future containing the result of the UpdateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSegmentResponse> updateSegment(UpdateSegmentRequest updateSegmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSegmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSegmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSegment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSegmentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateSegmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSegmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSegmentRequest, UpdateSegmentResponse>()
                            .withOperationName("UpdateSegment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSegmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSegmentRequest));
            CompletableFuture<UpdateSegmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an
     * application.
     * </p>
     *
     * @param updateSmsChannelRequest
     * @return A Java Future containing the result of the UpdateSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmsChannelResponse> updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSmsChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmsChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSmsChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmsChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmsChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmsChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmsChannelRequest, UpdateSmsChannelResponse>()
                            .withOperationName("UpdateSmsChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSmsChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSmsChannelRequest));
            CompletableFuture<UpdateSmsChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param updateSmsTemplateRequest
     * @return A Java Future containing the result of the UpdateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSmsTemplateResponse> updateSmsTemplate(UpdateSmsTemplateRequest updateSmsTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSmsTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSmsTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSmsTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSmsTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSmsTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSmsTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSmsTemplateRequest, UpdateSmsTemplateResponse>()
                            .withOperationName("UpdateSmsTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSmsTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateSmsTemplateRequest));
            CompletableFuture<UpdateSmsTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the status of a specific version of a message template to <i>active</i>.
     * </p>
     *
     * @param updateTemplateActiveVersionRequest
     * @return A Java Future containing the result of the UpdateTemplateActiveVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateTemplateActiveVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateTemplateActiveVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTemplateActiveVersionResponse> updateTemplateActiveVersion(
            UpdateTemplateActiveVersionRequest updateTemplateActiveVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTemplateActiveVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplateActiveVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplateActiveVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTemplateActiveVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTemplateActiveVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTemplateActiveVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTemplateActiveVersionRequest, UpdateTemplateActiveVersionResponse>()
                            .withOperationName("UpdateTemplateActiveVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateTemplateActiveVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateTemplateActiveVersionRequest));
            CompletableFuture<UpdateTemplateActiveVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an
     * application.
     * </p>
     *
     * @param updateVoiceChannelRequest
     * @return A Java Future containing the result of the UpdateVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceChannelResponse> updateVoiceChannel(UpdateVoiceChannelRequest updateVoiceChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVoiceChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceChannelRequest, UpdateVoiceChannelResponse>()
                            .withOperationName("UpdateVoiceChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateVoiceChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateVoiceChannelRequest));
            CompletableFuture<UpdateVoiceChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param updateVoiceTemplateRequest
     * @return A Java Future containing the result of the UpdateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVoiceTemplateResponse> updateVoiceTemplate(
            UpdateVoiceTemplateRequest updateVoiceTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVoiceTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVoiceTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVoiceTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVoiceTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVoiceTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVoiceTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVoiceTemplateRequest, UpdateVoiceTemplateResponse>()
                            .withOperationName("UpdateVoiceTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateVoiceTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateVoiceTemplateRequest));
            CompletableFuture<UpdateVoiceTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Verify an OTP
     * </p>
     *
     * @param verifyOtpMessageRequest
     * @return A Java Future containing the result of the VerifyOTPMessage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>PayloadTooLargeException 413 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>MethodNotAllowedException 405 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.VerifyOTPMessage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/VerifyOTPMessage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<VerifyOtpMessageResponse> verifyOTPMessage(VerifyOtpMessageRequest verifyOtpMessageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(verifyOtpMessageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, verifyOtpMessageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Pinpoint");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "VerifyOTPMessage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<VerifyOtpMessageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, VerifyOtpMessageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<VerifyOtpMessageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<VerifyOtpMessageRequest, VerifyOtpMessageResponse>()
                            .withOperationName("VerifyOTPMessage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new VerifyOtpMessageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(verifyOtpMessageRequest));
            CompletableFuture<VerifyOtpMessageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final PinpointServiceClientConfiguration serviceClientConfiguration() {
        return new PinpointServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PinpointException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MethodNotAllowedException")
                                .exceptionBuilderSupplier(MethodNotAllowedException::builder).httpStatusCode(405).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PayloadTooLargeException")
                                .exceptionBuilderSupplier(PayloadTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        PinpointServiceClientConfigurationBuilder serviceConfigBuilder = new PinpointServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
