/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentExportJobsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetSegmentExportJobsResponse.Builder, GetSegmentExportJobsResponse> {
    private static final SdkField<ExportJobsResponse> EXPORT_JOBS_RESPONSE_FIELD = SdkField
            .<ExportJobsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("ExportJobsResponse")
            .getter(getter(GetSegmentExportJobsResponse::exportJobsResponse))
            .setter(setter(Builder::exportJobsResponse))
            .constructor(ExportJobsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobsResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOBS_RESPONSE_FIELD));

    private final ExportJobsResponse exportJobsResponse;

    private GetSegmentExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobsResponse = builder.exportJobsResponse;
    }

    /**
     * Returns the value of the ExportJobsResponse property for this object.
     * 
     * @return The value of the ExportJobsResponse property for this object.
     */
    public final ExportJobsResponse exportJobsResponse() {
        return exportJobsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportJobsResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentExportJobsResponse)) {
            return false;
        }
        GetSegmentExportJobsResponse other = (GetSegmentExportJobsResponse) obj;
        return Objects.equals(exportJobsResponse(), other.exportJobsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSegmentExportJobsResponse").add("ExportJobsResponse", exportJobsResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobsResponse":
            return Optional.ofNullable(clazz.cast(exportJobsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentExportJobsResponse, T> g) {
        return obj -> g.apply((GetSegmentExportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSegmentExportJobsResponse> {
        /**
         * Sets the value of the ExportJobsResponse property for this object.
         *
         * @param exportJobsResponse
         *        The new value for the ExportJobsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobsResponse(ExportJobsResponse exportJobsResponse);

        /**
         * Sets the value of the ExportJobsResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExportJobsResponse.Builder} avoiding the
         * need to create one manually via {@link ExportJobsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportJobsResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #exportJobsResponse(ExportJobsResponse)}.
         * 
         * @param exportJobsResponse
         *        a consumer that will call methods on {@link ExportJobsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportJobsResponse(ExportJobsResponse)
         */
        default Builder exportJobsResponse(Consumer<ExportJobsResponse.Builder> exportJobsResponse) {
            return exportJobsResponse(ExportJobsResponse.builder().applyMutation(exportJobsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private ExportJobsResponse exportJobsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentExportJobsResponse model) {
            super(model);
            exportJobsResponse(model.exportJobsResponse);
        }

        public final ExportJobsResponse.Builder getExportJobsResponse() {
            return exportJobsResponse != null ? exportJobsResponse.toBuilder() : null;
        }

        public final void setExportJobsResponse(ExportJobsResponse.BuilderImpl exportJobsResponse) {
            this.exportJobsResponse = exportJobsResponse != null ? exportJobsResponse.build() : null;
        }

        @Override
        public final Builder exportJobsResponse(ExportJobsResponse exportJobsResponse) {
            this.exportJobsResponse = exportJobsResponse;
            return this;
        }

        @Override
        public GetSegmentExportJobsResponse build() {
            return new GetSegmentExportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
