/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default sending limits for journeys in the application. To override these limits and define custom limits for a
 * specific journey, use the Journey resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSettingsJourneyLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSettingsJourneyLimits.Builder, ApplicationSettingsJourneyLimits> {
    private static final SdkField<Integer> DAILY_CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DailyCap").getter(getter(ApplicationSettingsJourneyLimits::dailyCap)).setter(setter(Builder::dailyCap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyCap").build()).build();

    private static final SdkField<JourneyTimeframeCap> TIMEFRAME_CAP_FIELD = SdkField
            .<JourneyTimeframeCap> builder(MarshallingType.SDK_POJO).memberName("TimeframeCap")
            .getter(getter(ApplicationSettingsJourneyLimits::timeframeCap)).setter(setter(Builder::timeframeCap))
            .constructor(JourneyTimeframeCap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeframeCap").build()).build();

    private static final SdkField<Integer> TOTAL_CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCap").getter(getter(ApplicationSettingsJourneyLimits::totalCap)).setter(setter(Builder::totalCap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCap").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_CAP_FIELD,
            TIMEFRAME_CAP_FIELD, TOTAL_CAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dailyCap;

    private final JourneyTimeframeCap timeframeCap;

    private final Integer totalCap;

    private ApplicationSettingsJourneyLimits(BuilderImpl builder) {
        this.dailyCap = builder.dailyCap;
        this.timeframeCap = builder.timeframeCap;
        this.totalCap = builder.totalCap;
    }

    /**
     * <p>
     * The daily number of messages that an endpoint can receive from all journeys. The maximum value is 100. If set to
     * 0, this limit will not apply.
     * </p>
     * 
     * @return The daily number of messages that an endpoint can receive from all journeys. The maximum value is 100. If
     *         set to 0, this limit will not apply.
     */
    public final Integer dailyCap() {
        return dailyCap;
    }

    /**
     * <p>
     * The default maximum number of messages that can be sent to an endpoint during the specified timeframe for all
     * journeys.
     * </p>
     * 
     * @return The default maximum number of messages that can be sent to an endpoint during the specified timeframe for
     *         all journeys.
     */
    public final JourneyTimeframeCap timeframeCap() {
        return timeframeCap;
    }

    /**
     * <p>
     * The default maximum number of messages that a single journey can sent to a single endpoint. The maximum value is
     * 100. If set to 0, this limit will not apply.
     * </p>
     * 
     * @return The default maximum number of messages that a single journey can sent to a single endpoint. The maximum
     *         value is 100. If set to 0, this limit will not apply.
     */
    public final Integer totalCap() {
        return totalCap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dailyCap());
        hashCode = 31 * hashCode + Objects.hashCode(timeframeCap());
        hashCode = 31 * hashCode + Objects.hashCode(totalCap());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettingsJourneyLimits)) {
            return false;
        }
        ApplicationSettingsJourneyLimits other = (ApplicationSettingsJourneyLimits) obj;
        return Objects.equals(dailyCap(), other.dailyCap()) && Objects.equals(timeframeCap(), other.timeframeCap())
                && Objects.equals(totalCap(), other.totalCap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSettingsJourneyLimits").add("DailyCap", dailyCap())
                .add("TimeframeCap", timeframeCap()).add("TotalCap", totalCap()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DailyCap":
            return Optional.ofNullable(clazz.cast(dailyCap()));
        case "TimeframeCap":
            return Optional.ofNullable(clazz.cast(timeframeCap()));
        case "TotalCap":
            return Optional.ofNullable(clazz.cast(totalCap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DailyCap", DAILY_CAP_FIELD);
        map.put("TimeframeCap", TIMEFRAME_CAP_FIELD);
        map.put("TotalCap", TOTAL_CAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettingsJourneyLimits, T> g) {
        return obj -> g.apply((ApplicationSettingsJourneyLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSettingsJourneyLimits> {
        /**
         * <p>
         * The daily number of messages that an endpoint can receive from all journeys. The maximum value is 100. If set
         * to 0, this limit will not apply.
         * </p>
         * 
         * @param dailyCap
         *        The daily number of messages that an endpoint can receive from all journeys. The maximum value is 100.
         *        If set to 0, this limit will not apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyCap(Integer dailyCap);

        /**
         * <p>
         * The default maximum number of messages that can be sent to an endpoint during the specified timeframe for all
         * journeys.
         * </p>
         * 
         * @param timeframeCap
         *        The default maximum number of messages that can be sent to an endpoint during the specified timeframe
         *        for all journeys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeframeCap(JourneyTimeframeCap timeframeCap);

        /**
         * <p>
         * The default maximum number of messages that can be sent to an endpoint during the specified timeframe for all
         * journeys.
         * </p>
         * This is a convenience method that creates an instance of the {@link JourneyTimeframeCap.Builder} avoiding the
         * need to create one manually via {@link JourneyTimeframeCap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JourneyTimeframeCap.Builder#build()} is called immediately and
         * its result is passed to {@link #timeframeCap(JourneyTimeframeCap)}.
         * 
         * @param timeframeCap
         *        a consumer that will call methods on {@link JourneyTimeframeCap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeframeCap(JourneyTimeframeCap)
         */
        default Builder timeframeCap(Consumer<JourneyTimeframeCap.Builder> timeframeCap) {
            return timeframeCap(JourneyTimeframeCap.builder().applyMutation(timeframeCap).build());
        }

        /**
         * <p>
         * The default maximum number of messages that a single journey can sent to a single endpoint. The maximum value
         * is 100. If set to 0, this limit will not apply.
         * </p>
         * 
         * @param totalCap
         *        The default maximum number of messages that a single journey can sent to a single endpoint. The
         *        maximum value is 100. If set to 0, this limit will not apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCap(Integer totalCap);
    }

    static final class BuilderImpl implements Builder {
        private Integer dailyCap;

        private JourneyTimeframeCap timeframeCap;

        private Integer totalCap;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettingsJourneyLimits model) {
            dailyCap(model.dailyCap);
            timeframeCap(model.timeframeCap);
            totalCap(model.totalCap);
        }

        public final Integer getDailyCap() {
            return dailyCap;
        }

        public final void setDailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
        }

        @Override
        public final Builder dailyCap(Integer dailyCap) {
            this.dailyCap = dailyCap;
            return this;
        }

        public final JourneyTimeframeCap.Builder getTimeframeCap() {
            return timeframeCap != null ? timeframeCap.toBuilder() : null;
        }

        public final void setTimeframeCap(JourneyTimeframeCap.BuilderImpl timeframeCap) {
            this.timeframeCap = timeframeCap != null ? timeframeCap.build() : null;
        }

        @Override
        public final Builder timeframeCap(JourneyTimeframeCap timeframeCap) {
            this.timeframeCap = timeframeCap;
            return this;
        }

        public final Integer getTotalCap() {
            return totalCap;
        }

        public final void setTotalCap(Integer totalCap) {
            this.totalCap = totalCap;
        }

        @Override
        public final Builder totalCap(Integer totalCap) {
            this.totalCap = totalCap;
            return this;
        }

        @Override
        public ApplicationSettingsJourneyLimits build() {
            return new ApplicationSettingsJourneyLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
