/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the content and "From" address for an email message that's sent to recipients of a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignEmailMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<CampaignEmailMessage.Builder, CampaignEmailMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(CampaignEmailMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromAddress").getter(getter(CampaignEmailMessage::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField
            .<List<MessageHeader>> builder(MarshallingType.LIST)
            .memberName("Headers")
            .getter(getter(CampaignEmailMessage::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HTML_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HtmlBody").getter(getter(CampaignEmailMessage::htmlBody)).setter(setter(Builder::htmlBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlBody").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(CampaignEmailMessage::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            FROM_ADDRESS_FIELD, HEADERS_FIELD, HTML_BODY_FIELD, TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String fromAddress;

    private final List<MessageHeader> headers;

    private final String htmlBody;

    private final String title;

    private CampaignEmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.fromAddress = builder.fromAddress;
        this.headers = builder.headers;
        this.htmlBody = builder.htmlBody;
        this.title = builder.title;
    }

    /**
     * <p>
     * The body of the email for recipients whose email clients don't render HTML content.
     * </p>
     * 
     * @return The body of the email for recipients whose email clients don't render HTML content.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * The verified email address to send the email from. The default address is the FromAddress specified for the email
     * channel for the application.
     * </p>
     * 
     * @return The verified email address to send the email from. The default address is the FromAddress specified for
     *         the email channel for the application.
     */
    public final String fromAddress() {
        return fromAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader"
     * >MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The list of <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader"
     *         >MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.
     */
    public final List<MessageHeader> headers() {
        return headers;
    }

    /**
     * <p>
     * The body of the email, in HTML format, for recipients whose email clients render HTML content.
     * </p>
     * 
     * @return The body of the email, in HTML format, for recipients whose email clients render HTML content.
     */
    public final String htmlBody() {
        return htmlBody;
    }

    /**
     * <p>
     * The subject line, or title, of the email.
     * </p>
     * 
     * @return The subject line, or title, of the email.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(htmlBody());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignEmailMessage)) {
            return false;
        }
        CampaignEmailMessage other = (CampaignEmailMessage) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(fromAddress(), other.fromAddress())
                && hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && Objects.equals(htmlBody(), other.htmlBody()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignEmailMessage").add("Body", body()).add("FromAddress", fromAddress())
                .add("Headers", hasHeaders() ? headers() : null).add("HtmlBody", htmlBody()).add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "HtmlBody":
            return Optional.ofNullable(clazz.cast(htmlBody()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Body", BODY_FIELD);
        map.put("FromAddress", FROM_ADDRESS_FIELD);
        map.put("Headers", HEADERS_FIELD);
        map.put("HtmlBody", HTML_BODY_FIELD);
        map.put("Title", TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignEmailMessage, T> g) {
        return obj -> g.apply((CampaignEmailMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignEmailMessage> {
        /**
         * <p>
         * The body of the email for recipients whose email clients don't render HTML content.
         * </p>
         * 
         * @param body
         *        The body of the email for recipients whose email clients don't render HTML content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The verified email address to send the email from. The default address is the FromAddress specified for the
         * email channel for the application.
         * </p>
         * 
         * @param fromAddress
         *        The verified email address to send the email from. The default address is the FromAddress specified
         *        for the email channel for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.
         * </p>
         * 
         * @param headers
         *        The list of <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader"
         *        >MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<MessageHeader> headers);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.
         * </p>
         * 
         * @param headers
         *        The list of <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader"
         *        >MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(MessageHeader... headers);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder#build()} is called immediately
         * and its result is passed to {@link #headers(List<MessageHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<MessageHeader>)
         */
        Builder headers(Consumer<MessageHeader.Builder>... headers);

        /**
         * <p>
         * The body of the email, in HTML format, for recipients whose email clients render HTML content.
         * </p>
         * 
         * @param htmlBody
         *        The body of the email, in HTML format, for recipients whose email clients render HTML content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlBody(String htmlBody);

        /**
         * <p>
         * The subject line, or title, of the email.
         * </p>
         * 
         * @param title
         *        The subject line, or title, of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String fromAddress;

        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private String htmlBody;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignEmailMessage model) {
            body(model.body);
            fromAddress(model.fromAddress);
            headers(model.headers);
            htmlBody(model.htmlBody);
            title(model.title);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = ListOfMessageHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = ListOfMessageHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = ListOfMessageHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> MessageHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHtmlBody() {
            return htmlBody;
        }

        public final void setHtmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
        }

        @Override
        public final Builder htmlBody(String htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public CampaignEmailMessage build() {
            return new CampaignEmailMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
