/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time when a journey will not send messages. QuietTime should be configured first and SendingSchedule should be
 * set to true.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClosedDays implements SdkPojo, Serializable, ToCopyableBuilder<ClosedDays.Builder, ClosedDays> {
    private static final SdkField<List<ClosedDaysRule>> EMAIL_FIELD = SdkField
            .<List<ClosedDaysRule>> builder(MarshallingType.LIST)
            .memberName("EMAIL")
            .getter(getter(ClosedDays::email))
            .setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EMAIL").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClosedDaysRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClosedDaysRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClosedDaysRule>> SMS_FIELD = SdkField
            .<List<ClosedDaysRule>> builder(MarshallingType.LIST)
            .memberName("SMS")
            .getter(getter(ClosedDays::sms))
            .setter(setter(Builder::sms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClosedDaysRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClosedDaysRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClosedDaysRule>> PUSH_FIELD = SdkField
            .<List<ClosedDaysRule>> builder(MarshallingType.LIST)
            .memberName("PUSH")
            .getter(getter(ClosedDays::push))
            .setter(setter(Builder::push))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PUSH").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClosedDaysRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClosedDaysRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClosedDaysRule>> VOICE_FIELD = SdkField
            .<List<ClosedDaysRule>> builder(MarshallingType.LIST)
            .memberName("VOICE")
            .getter(getter(ClosedDays::voice))
            .setter(setter(Builder::voice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VOICE").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClosedDaysRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClosedDaysRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClosedDaysRule>> CUSTOM_FIELD = SdkField
            .<List<ClosedDaysRule>> builder(MarshallingType.LIST)
            .memberName("CUSTOM")
            .getter(getter(ClosedDays::custom))
            .setter(setter(Builder::custom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CUSTOM").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClosedDaysRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClosedDaysRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, SMS_FIELD,
            PUSH_FIELD, VOICE_FIELD, CUSTOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ClosedDaysRule> email;

    private final List<ClosedDaysRule> sms;

    private final List<ClosedDaysRule> push;

    private final List<ClosedDaysRule> voice;

    private final List<ClosedDaysRule> custom;

    private ClosedDays(BuilderImpl builder) {
        this.email = builder.email;
        this.sms = builder.sms;
        this.push = builder.push;
        this.voice = builder.voice;
        this.custom = builder.custom;
    }

    /**
     * For responses, this returns true if the service returned a value for the EMAIL property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEmail() {
        return email != null && !(email instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules for the Email channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmail} method.
     * </p>
     * 
     * @return Rules for the Email channel.
     */
    public final List<ClosedDaysRule> email() {
        return email;
    }

    /**
     * For responses, this returns true if the service returned a value for the SMS property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSms() {
        return sms != null && !(sms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules for the SMS channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSms} method.
     * </p>
     * 
     * @return Rules for the SMS channel.
     */
    public final List<ClosedDaysRule> sms() {
        return sms;
    }

    /**
     * For responses, this returns true if the service returned a value for the PUSH property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPush() {
        return push != null && !(push instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules for the Push channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPush} method.
     * </p>
     * 
     * @return Rules for the Push channel.
     */
    public final List<ClosedDaysRule> push() {
        return push;
    }

    /**
     * For responses, this returns true if the service returned a value for the VOICE property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasVoice() {
        return voice != null && !(voice instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules for the Voice channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVoice} method.
     * </p>
     * 
     * @return Rules for the Voice channel.
     */
    public final List<ClosedDaysRule> voice() {
        return voice;
    }

    /**
     * For responses, this returns true if the service returned a value for the CUSTOM property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCustom() {
        return custom != null && !(custom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules for the Custom channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustom} method.
     * </p>
     * 
     * @return Rules for the Custom channel.
     */
    public final List<ClosedDaysRule> custom() {
        return custom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEmail() ? email() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSms() ? sms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPush() ? push() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVoice() ? voice() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustom() ? custom() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClosedDays)) {
            return false;
        }
        ClosedDays other = (ClosedDays) obj;
        return hasEmail() == other.hasEmail() && Objects.equals(email(), other.email()) && hasSms() == other.hasSms()
                && Objects.equals(sms(), other.sms()) && hasPush() == other.hasPush() && Objects.equals(push(), other.push())
                && hasVoice() == other.hasVoice() && Objects.equals(voice(), other.voice()) && hasCustom() == other.hasCustom()
                && Objects.equals(custom(), other.custom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClosedDays").add("EMAIL", hasEmail() ? email() : null).add("SMS", hasSms() ? sms() : null)
                .add("PUSH", hasPush() ? push() : null).add("VOICE", hasVoice() ? voice() : null)
                .add("CUSTOM", hasCustom() ? custom() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EMAIL":
            return Optional.ofNullable(clazz.cast(email()));
        case "SMS":
            return Optional.ofNullable(clazz.cast(sms()));
        case "PUSH":
            return Optional.ofNullable(clazz.cast(push()));
        case "VOICE":
            return Optional.ofNullable(clazz.cast(voice()));
        case "CUSTOM":
            return Optional.ofNullable(clazz.cast(custom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EMAIL", EMAIL_FIELD);
        map.put("SMS", SMS_FIELD);
        map.put("PUSH", PUSH_FIELD);
        map.put("VOICE", VOICE_FIELD);
        map.put("CUSTOM", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClosedDays, T> g) {
        return obj -> g.apply((ClosedDays) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClosedDays> {
        /**
         * <p>
         * Rules for the Email channel.
         * </p>
         * 
         * @param email
         *        Rules for the Email channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(Collection<ClosedDaysRule> email);

        /**
         * <p>
         * Rules for the Email channel.
         * </p>
         * 
         * @param email
         *        Rules for the Email channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(ClosedDaysRule... email);

        /**
         * <p>
         * Rules for the Email channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder#build()} is called immediately
         * and its result is passed to {@link #email(List<ClosedDaysRule>)}.
         * 
         * @param email
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(java.util.Collection<ClosedDaysRule>)
         */
        Builder email(Consumer<ClosedDaysRule.Builder>... email);

        /**
         * <p>
         * Rules for the SMS channel.
         * </p>
         * 
         * @param sms
         *        Rules for the SMS channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(Collection<ClosedDaysRule> sms);

        /**
         * <p>
         * Rules for the SMS channel.
         * </p>
         * 
         * @param sms
         *        Rules for the SMS channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sms(ClosedDaysRule... sms);

        /**
         * <p>
         * Rules for the SMS channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder#build()} is called immediately
         * and its result is passed to {@link #sms(List<ClosedDaysRule>)}.
         * 
         * @param sms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sms(java.util.Collection<ClosedDaysRule>)
         */
        Builder sms(Consumer<ClosedDaysRule.Builder>... sms);

        /**
         * <p>
         * Rules for the Push channel.
         * </p>
         * 
         * @param push
         *        Rules for the Push channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder push(Collection<ClosedDaysRule> push);

        /**
         * <p>
         * Rules for the Push channel.
         * </p>
         * 
         * @param push
         *        Rules for the Push channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder push(ClosedDaysRule... push);

        /**
         * <p>
         * Rules for the Push channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder#build()} is called immediately
         * and its result is passed to {@link #push(List<ClosedDaysRule>)}.
         * 
         * @param push
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #push(java.util.Collection<ClosedDaysRule>)
         */
        Builder push(Consumer<ClosedDaysRule.Builder>... push);

        /**
         * <p>
         * Rules for the Voice channel.
         * </p>
         * 
         * @param voice
         *        Rules for the Voice channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voice(Collection<ClosedDaysRule> voice);

        /**
         * <p>
         * Rules for the Voice channel.
         * </p>
         * 
         * @param voice
         *        Rules for the Voice channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voice(ClosedDaysRule... voice);

        /**
         * <p>
         * Rules for the Voice channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder#build()} is called immediately
         * and its result is passed to {@link #voice(List<ClosedDaysRule>)}.
         * 
         * @param voice
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voice(java.util.Collection<ClosedDaysRule>)
         */
        Builder voice(Consumer<ClosedDaysRule.Builder>... voice);

        /**
         * <p>
         * Rules for the Custom channel.
         * </p>
         * 
         * @param custom
         *        Rules for the Custom channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(Collection<ClosedDaysRule> custom);

        /**
         * <p>
         * Rules for the Custom channel.
         * </p>
         * 
         * @param custom
         *        Rules for the Custom channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(ClosedDaysRule... custom);

        /**
         * <p>
         * Rules for the Custom channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder#build()} is called immediately
         * and its result is passed to {@link #custom(List<ClosedDaysRule>)}.
         * 
         * @param custom
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.ClosedDaysRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(java.util.Collection<ClosedDaysRule>)
         */
        Builder custom(Consumer<ClosedDaysRule.Builder>... custom);
    }

    static final class BuilderImpl implements Builder {
        private List<ClosedDaysRule> email = DefaultSdkAutoConstructList.getInstance();

        private List<ClosedDaysRule> sms = DefaultSdkAutoConstructList.getInstance();

        private List<ClosedDaysRule> push = DefaultSdkAutoConstructList.getInstance();

        private List<ClosedDaysRule> voice = DefaultSdkAutoConstructList.getInstance();

        private List<ClosedDaysRule> custom = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClosedDays model) {
            email(model.email);
            sms(model.sms);
            push(model.push);
            voice(model.voice);
            custom(model.custom);
        }

        public final List<ClosedDaysRule.Builder> getEmail() {
            List<ClosedDaysRule.Builder> result = ListOfClosedDaysRulesCopier.copyToBuilder(this.email);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmail(Collection<ClosedDaysRule.BuilderImpl> email) {
            this.email = ListOfClosedDaysRulesCopier.copyFromBuilder(email);
        }

        @Override
        public final Builder email(Collection<ClosedDaysRule> email) {
            this.email = ListOfClosedDaysRulesCopier.copy(email);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder email(ClosedDaysRule... email) {
            email(Arrays.asList(email));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder email(Consumer<ClosedDaysRule.Builder>... email) {
            email(Stream.of(email).map(c -> ClosedDaysRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClosedDaysRule.Builder> getSms() {
            List<ClosedDaysRule.Builder> result = ListOfClosedDaysRulesCopier.copyToBuilder(this.sms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSms(Collection<ClosedDaysRule.BuilderImpl> sms) {
            this.sms = ListOfClosedDaysRulesCopier.copyFromBuilder(sms);
        }

        @Override
        public final Builder sms(Collection<ClosedDaysRule> sms) {
            this.sms = ListOfClosedDaysRulesCopier.copy(sms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sms(ClosedDaysRule... sms) {
            sms(Arrays.asList(sms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sms(Consumer<ClosedDaysRule.Builder>... sms) {
            sms(Stream.of(sms).map(c -> ClosedDaysRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClosedDaysRule.Builder> getPush() {
            List<ClosedDaysRule.Builder> result = ListOfClosedDaysRulesCopier.copyToBuilder(this.push);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPush(Collection<ClosedDaysRule.BuilderImpl> push) {
            this.push = ListOfClosedDaysRulesCopier.copyFromBuilder(push);
        }

        @Override
        public final Builder push(Collection<ClosedDaysRule> push) {
            this.push = ListOfClosedDaysRulesCopier.copy(push);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder push(ClosedDaysRule... push) {
            push(Arrays.asList(push));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder push(Consumer<ClosedDaysRule.Builder>... push) {
            push(Stream.of(push).map(c -> ClosedDaysRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClosedDaysRule.Builder> getVoice() {
            List<ClosedDaysRule.Builder> result = ListOfClosedDaysRulesCopier.copyToBuilder(this.voice);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVoice(Collection<ClosedDaysRule.BuilderImpl> voice) {
            this.voice = ListOfClosedDaysRulesCopier.copyFromBuilder(voice);
        }

        @Override
        public final Builder voice(Collection<ClosedDaysRule> voice) {
            this.voice = ListOfClosedDaysRulesCopier.copy(voice);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voice(ClosedDaysRule... voice) {
            voice(Arrays.asList(voice));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder voice(Consumer<ClosedDaysRule.Builder>... voice) {
            voice(Stream.of(voice).map(c -> ClosedDaysRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClosedDaysRule.Builder> getCustom() {
            List<ClosedDaysRule.Builder> result = ListOfClosedDaysRulesCopier.copyToBuilder(this.custom);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustom(Collection<ClosedDaysRule.BuilderImpl> custom) {
            this.custom = ListOfClosedDaysRulesCopier.copyFromBuilder(custom);
        }

        @Override
        public final Builder custom(Collection<ClosedDaysRule> custom) {
            this.custom = ListOfClosedDaysRulesCopier.copy(custom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder custom(ClosedDaysRule... custom) {
            custom(Arrays.asList(custom));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder custom(Consumer<ClosedDaysRule.Builder>... custom) {
            custom(Stream.of(custom).map(c -> ClosedDaysRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClosedDays build() {
            return new ClosedDays(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
