/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Default button configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultButtonConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultButtonConfiguration.Builder, DefaultButtonConfiguration> {
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundColor").getter(getter(DefaultButtonConfiguration::backgroundColor))
            .setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()).build();

    private static final SdkField<Integer> BORDER_RADIUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BorderRadius").getter(getter(DefaultButtonConfiguration::borderRadius))
            .setter(setter(Builder::borderRadius))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderRadius").build()).build();

    private static final SdkField<String> BUTTON_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ButtonAction").getter(getter(DefaultButtonConfiguration::buttonActionAsString))
            .setter(setter(Builder::buttonAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ButtonAction").build()).build();

    private static final SdkField<String> LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Link")
            .getter(getter(DefaultButtonConfiguration::link)).setter(setter(Builder::link))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(DefaultButtonConfiguration::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> TEXT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextColor").getter(getter(DefaultButtonConfiguration::textColor)).setter(setter(Builder::textColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextColor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKGROUND_COLOR_FIELD,
            BORDER_RADIUS_FIELD, BUTTON_ACTION_FIELD, LINK_FIELD, TEXT_FIELD, TEXT_COLOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backgroundColor;

    private final Integer borderRadius;

    private final String buttonAction;

    private final String link;

    private final String text;

    private final String textColor;

    private DefaultButtonConfiguration(BuilderImpl builder) {
        this.backgroundColor = builder.backgroundColor;
        this.borderRadius = builder.borderRadius;
        this.buttonAction = builder.buttonAction;
        this.link = builder.link;
        this.text = builder.text;
        this.textColor = builder.textColor;
    }

    /**
     * <p>
     * The background color of the button.
     * </p>
     * 
     * @return The background color of the button.
     */
    public final String backgroundColor() {
        return backgroundColor;
    }

    /**
     * <p>
     * The border radius of the button.
     * </p>
     * 
     * @return The border radius of the button.
     */
    public final Integer borderRadius() {
        return borderRadius;
    }

    /**
     * <p>
     * Action triggered by the button.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buttonAction} will
     * return {@link ButtonAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buttonActionAsString}.
     * </p>
     * 
     * @return Action triggered by the button.
     * @see ButtonAction
     */
    public final ButtonAction buttonAction() {
        return ButtonAction.fromValue(buttonAction);
    }

    /**
     * <p>
     * Action triggered by the button.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buttonAction} will
     * return {@link ButtonAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #buttonActionAsString}.
     * </p>
     * 
     * @return Action triggered by the button.
     * @see ButtonAction
     */
    public final String buttonActionAsString() {
        return buttonAction;
    }

    /**
     * <p>
     * Button destination.
     * </p>
     * 
     * @return Button destination.
     */
    public final String link() {
        return link;
    }

    /**
     * <p>
     * Button text.
     * </p>
     * 
     * @return Button text.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The text color of the button.
     * </p>
     * 
     * @return The text color of the button.
     */
    public final String textColor() {
        return textColor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(borderRadius());
        hashCode = 31 * hashCode + Objects.hashCode(buttonActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(link());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(textColor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultButtonConfiguration)) {
            return false;
        }
        DefaultButtonConfiguration other = (DefaultButtonConfiguration) obj;
        return Objects.equals(backgroundColor(), other.backgroundColor()) && Objects.equals(borderRadius(), other.borderRadius())
                && Objects.equals(buttonActionAsString(), other.buttonActionAsString()) && Objects.equals(link(), other.link())
                && Objects.equals(text(), other.text()) && Objects.equals(textColor(), other.textColor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultButtonConfiguration").add("BackgroundColor", backgroundColor())
                .add("BorderRadius", borderRadius()).add("ButtonAction", buttonActionAsString()).add("Link", link())
                .add("Text", text()).add("TextColor", textColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColor()));
        case "BorderRadius":
            return Optional.ofNullable(clazz.cast(borderRadius()));
        case "ButtonAction":
            return Optional.ofNullable(clazz.cast(buttonActionAsString()));
        case "Link":
            return Optional.ofNullable(clazz.cast(link()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "TextColor":
            return Optional.ofNullable(clazz.cast(textColor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("BorderRadius", BORDER_RADIUS_FIELD);
        map.put("ButtonAction", BUTTON_ACTION_FIELD);
        map.put("Link", LINK_FIELD);
        map.put("Text", TEXT_FIELD);
        map.put("TextColor", TEXT_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultButtonConfiguration, T> g) {
        return obj -> g.apply((DefaultButtonConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultButtonConfiguration> {
        /**
         * <p>
         * The background color of the button.
         * </p>
         * 
         * @param backgroundColor
         *        The background color of the button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundColor(String backgroundColor);

        /**
         * <p>
         * The border radius of the button.
         * </p>
         * 
         * @param borderRadius
         *        The border radius of the button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder borderRadius(Integer borderRadius);

        /**
         * <p>
         * Action triggered by the button.
         * </p>
         * 
         * @param buttonAction
         *        Action triggered by the button.
         * @see ButtonAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ButtonAction
         */
        Builder buttonAction(String buttonAction);

        /**
         * <p>
         * Action triggered by the button.
         * </p>
         * 
         * @param buttonAction
         *        Action triggered by the button.
         * @see ButtonAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ButtonAction
         */
        Builder buttonAction(ButtonAction buttonAction);

        /**
         * <p>
         * Button destination.
         * </p>
         * 
         * @param link
         *        Button destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder link(String link);

        /**
         * <p>
         * Button text.
         * </p>
         * 
         * @param text
         *        Button text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The text color of the button.
         * </p>
         * 
         * @param textColor
         *        The text color of the button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textColor(String textColor);
    }

    static final class BuilderImpl implements Builder {
        private String backgroundColor;

        private Integer borderRadius;

        private String buttonAction;

        private String link;

        private String text;

        private String textColor;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultButtonConfiguration model) {
            backgroundColor(model.backgroundColor);
            borderRadius(model.borderRadius);
            buttonAction(model.buttonAction);
            link(model.link);
            text(model.text);
            textColor(model.textColor);
        }

        public final String getBackgroundColor() {
            return backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final Integer getBorderRadius() {
            return borderRadius;
        }

        public final void setBorderRadius(Integer borderRadius) {
            this.borderRadius = borderRadius;
        }

        @Override
        public final Builder borderRadius(Integer borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        public final String getButtonAction() {
            return buttonAction;
        }

        public final void setButtonAction(String buttonAction) {
            this.buttonAction = buttonAction;
        }

        @Override
        public final Builder buttonAction(String buttonAction) {
            this.buttonAction = buttonAction;
            return this;
        }

        @Override
        public final Builder buttonAction(ButtonAction buttonAction) {
            this.buttonAction(buttonAction == null ? null : buttonAction.toString());
            return this;
        }

        public final String getLink() {
            return link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getTextColor() {
            return textColor;
        }

        public final void setTextColor(String textColor) {
            this.textColor = textColor;
        }

        @Override
        public final Builder textColor(String textColor) {
            this.textColor = textColor;
            return this;
        }

        @Override
        public DefaultButtonConfiguration build() {
            return new DefaultButtonConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
