/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default settings and content for a one-time email message that's sent directly to an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailMessage implements SdkPojo, Serializable, ToCopyableBuilder<EmailMessage.Builder, EmailMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(EmailMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> FEEDBACK_FORWARDING_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackForwardingAddress").getter(getter(EmailMessage::feedbackForwardingAddress))
            .setter(setter(Builder::feedbackForwardingAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackForwardingAddress").build())
            .build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromAddress").getter(getter(EmailMessage::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<RawEmail> RAW_EMAIL_FIELD = SdkField.<RawEmail> builder(MarshallingType.SDK_POJO)
            .memberName("RawEmail").getter(getter(EmailMessage::rawEmail)).setter(setter(Builder::rawEmail))
            .constructor(RawEmail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawEmail").build()).build();

    private static final SdkField<List<String>> REPLY_TO_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplyToAddresses")
            .getter(getter(EmailMessage::replyToAddresses))
            .setter(setter(Builder::replyToAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SimpleEmail> SIMPLE_EMAIL_FIELD = SdkField.<SimpleEmail> builder(MarshallingType.SDK_POJO)
            .memberName("SimpleEmail").getter(getter(EmailMessage::simpleEmail)).setter(setter(Builder::simpleEmail))
            .constructor(SimpleEmail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleEmail").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Substitutions")
            .getter(getter(EmailMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            FEEDBACK_FORWARDING_ADDRESS_FIELD, FROM_ADDRESS_FIELD, RAW_EMAIL_FIELD, REPLY_TO_ADDRESSES_FIELD, SIMPLE_EMAIL_FIELD,
            SUBSTITUTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String feedbackForwardingAddress;

    private final String fromAddress;

    private final RawEmail rawEmail;

    private final List<String> replyToAddresses;

    private final SimpleEmail simpleEmail;

    private final Map<String, List<String>> substitutions;

    private EmailMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.feedbackForwardingAddress = builder.feedbackForwardingAddress;
        this.fromAddress = builder.fromAddress;
        this.rawEmail = builder.rawEmail;
        this.replyToAddresses = builder.replyToAddresses;
        this.simpleEmail = builder.simpleEmail;
        this.substitutions = builder.substitutions;
    }

    /**
     * <p>
     * The body of the email message.
     * </p>
     * 
     * @return The body of the email message.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * The email address to forward bounces and complaints to, if feedback forwarding is enabled.
     * </p>
     * 
     * @return The email address to forward bounces and complaints to, if feedback forwarding is enabled.
     */
    public final String feedbackForwardingAddress() {
        return feedbackForwardingAddress;
    }

    /**
     * <p>
     * The verified email address to send the email message from. The default value is the FromAddress specified for the
     * email channel.
     * </p>
     * 
     * @return The verified email address to send the email message from. The default value is the FromAddress specified
     *         for the email channel.
     */
    public final String fromAddress() {
        return fromAddress;
    }

    /**
     * <p>
     * The email message, represented as a raw MIME message.
     * </p>
     * 
     * @return The email message, represented as a raw MIME message.
     */
    public final RawEmail rawEmail() {
        return rawEmail;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplyToAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplyToAddresses() {
        return replyToAddresses != null && !(replyToAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reply-to email address(es) for the email message. If a recipient replies to the email, each reply-to address
     * receives the reply.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplyToAddresses} method.
     * </p>
     * 
     * @return The reply-to email address(es) for the email message. If a recipient replies to the email, each reply-to
     *         address receives the reply.
     */
    public final List<String> replyToAddresses() {
        return replyToAddresses;
    }

    /**
     * <p>
     * The email message, composed of a subject, a text part, and an HTML part.
     * </p>
     * 
     * @return The email message, composed of a subject, a text part, and an HTML part.
     */
    public final SimpleEmail simpleEmail() {
        return simpleEmail;
    }

    /**
     * For responses, this returns true if the service returned a value for the Substitutions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubstitutions() {
        return substitutions != null && !(substitutions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The default message variables to use in the email message. You can override the default variables with individual
     * address variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubstitutions} method.
     * </p>
     * 
     * @return The default message variables to use in the email message. You can override the default variables with
     *         individual address variables.
     */
    public final Map<String, List<String>> substitutions() {
        return substitutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackForwardingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(rawEmail());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplyToAddresses() ? replyToAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(simpleEmail());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubstitutions() ? substitutions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailMessage)) {
            return false;
        }
        EmailMessage other = (EmailMessage) obj;
        return Objects.equals(body(), other.body())
                && Objects.equals(feedbackForwardingAddress(), other.feedbackForwardingAddress())
                && Objects.equals(fromAddress(), other.fromAddress()) && Objects.equals(rawEmail(), other.rawEmail())
                && hasReplyToAddresses() == other.hasReplyToAddresses()
                && Objects.equals(replyToAddresses(), other.replyToAddresses())
                && Objects.equals(simpleEmail(), other.simpleEmail()) && hasSubstitutions() == other.hasSubstitutions()
                && Objects.equals(substitutions(), other.substitutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailMessage").add("Body", body()).add("FeedbackForwardingAddress", feedbackForwardingAddress())
                .add("FromAddress", fromAddress()).add("RawEmail", rawEmail())
                .add("ReplyToAddresses", hasReplyToAddresses() ? replyToAddresses() : null).add("SimpleEmail", simpleEmail())
                .add("Substitutions", hasSubstitutions() ? substitutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "FeedbackForwardingAddress":
            return Optional.ofNullable(clazz.cast(feedbackForwardingAddress()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "RawEmail":
            return Optional.ofNullable(clazz.cast(rawEmail()));
        case "ReplyToAddresses":
            return Optional.ofNullable(clazz.cast(replyToAddresses()));
        case "SimpleEmail":
            return Optional.ofNullable(clazz.cast(simpleEmail()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Body", BODY_FIELD);
        map.put("FeedbackForwardingAddress", FEEDBACK_FORWARDING_ADDRESS_FIELD);
        map.put("FromAddress", FROM_ADDRESS_FIELD);
        map.put("RawEmail", RAW_EMAIL_FIELD);
        map.put("ReplyToAddresses", REPLY_TO_ADDRESSES_FIELD);
        map.put("SimpleEmail", SIMPLE_EMAIL_FIELD);
        map.put("Substitutions", SUBSTITUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailMessage, T> g) {
        return obj -> g.apply((EmailMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailMessage> {
        /**
         * <p>
         * The body of the email message.
         * </p>
         * 
         * @param body
         *        The body of the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The email address to forward bounces and complaints to, if feedback forwarding is enabled.
         * </p>
         * 
         * @param feedbackForwardingAddress
         *        The email address to forward bounces and complaints to, if feedback forwarding is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackForwardingAddress(String feedbackForwardingAddress);

        /**
         * <p>
         * The verified email address to send the email message from. The default value is the FromAddress specified for
         * the email channel.
         * </p>
         * 
         * @param fromAddress
         *        The verified email address to send the email message from. The default value is the FromAddress
         *        specified for the email channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * <p>
         * The email message, represented as a raw MIME message.
         * </p>
         * 
         * @param rawEmail
         *        The email message, represented as a raw MIME message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawEmail(RawEmail rawEmail);

        /**
         * <p>
         * The email message, represented as a raw MIME message.
         * </p>
         * This is a convenience method that creates an instance of the {@link RawEmail.Builder} avoiding the need to
         * create one manually via {@link RawEmail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RawEmail.Builder#build()} is called immediately and its result is
         * passed to {@link #rawEmail(RawEmail)}.
         * 
         * @param rawEmail
         *        a consumer that will call methods on {@link RawEmail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rawEmail(RawEmail)
         */
        default Builder rawEmail(Consumer<RawEmail.Builder> rawEmail) {
            return rawEmail(RawEmail.builder().applyMutation(rawEmail).build());
        }

        /**
         * <p>
         * The reply-to email address(es) for the email message. If a recipient replies to the email, each reply-to
         * address receives the reply.
         * </p>
         * 
         * @param replyToAddresses
         *        The reply-to email address(es) for the email message. If a recipient replies to the email, each
         *        reply-to address receives the reply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToAddresses(Collection<String> replyToAddresses);

        /**
         * <p>
         * The reply-to email address(es) for the email message. If a recipient replies to the email, each reply-to
         * address receives the reply.
         * </p>
         * 
         * @param replyToAddresses
         *        The reply-to email address(es) for the email message. If a recipient replies to the email, each
         *        reply-to address receives the reply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replyToAddresses(String... replyToAddresses);

        /**
         * <p>
         * The email message, composed of a subject, a text part, and an HTML part.
         * </p>
         * 
         * @param simpleEmail
         *        The email message, composed of a subject, a text part, and an HTML part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleEmail(SimpleEmail simpleEmail);

        /**
         * <p>
         * The email message, composed of a subject, a text part, and an HTML part.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimpleEmail.Builder} avoiding the need to
         * create one manually via {@link SimpleEmail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SimpleEmail.Builder#build()} is called immediately and its result
         * is passed to {@link #simpleEmail(SimpleEmail)}.
         * 
         * @param simpleEmail
         *        a consumer that will call methods on {@link SimpleEmail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleEmail(SimpleEmail)
         */
        default Builder simpleEmail(Consumer<SimpleEmail.Builder> simpleEmail) {
            return simpleEmail(SimpleEmail.builder().applyMutation(simpleEmail).build());
        }

        /**
         * <p>
         * The default message variables to use in the email message. You can override the default variables with
         * individual address variables.
         * </p>
         * 
         * @param substitutions
         *        The default message variables to use in the email message. You can override the default variables with
         *        individual address variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String feedbackForwardingAddress;

        private String fromAddress;

        private RawEmail rawEmail;

        private List<String> replyToAddresses = DefaultSdkAutoConstructList.getInstance();

        private SimpleEmail simpleEmail;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailMessage model) {
            body(model.body);
            feedbackForwardingAddress(model.feedbackForwardingAddress);
            fromAddress(model.fromAddress);
            rawEmail(model.rawEmail);
            replyToAddresses(model.replyToAddresses);
            simpleEmail(model.simpleEmail);
            substitutions(model.substitutions);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getFeedbackForwardingAddress() {
            return feedbackForwardingAddress;
        }

        public final void setFeedbackForwardingAddress(String feedbackForwardingAddress) {
            this.feedbackForwardingAddress = feedbackForwardingAddress;
        }

        @Override
        public final Builder feedbackForwardingAddress(String feedbackForwardingAddress) {
            this.feedbackForwardingAddress = feedbackForwardingAddress;
            return this;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final RawEmail.Builder getRawEmail() {
            return rawEmail != null ? rawEmail.toBuilder() : null;
        }

        public final void setRawEmail(RawEmail.BuilderImpl rawEmail) {
            this.rawEmail = rawEmail != null ? rawEmail.build() : null;
        }

        @Override
        public final Builder rawEmail(RawEmail rawEmail) {
            this.rawEmail = rawEmail;
            return this;
        }

        public final Collection<String> getReplyToAddresses() {
            if (replyToAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return replyToAddresses;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = ListOf__stringCopier.copy(replyToAddresses);
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = ListOf__stringCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String... replyToAddresses) {
            replyToAddresses(Arrays.asList(replyToAddresses));
            return this;
        }

        public final SimpleEmail.Builder getSimpleEmail() {
            return simpleEmail != null ? simpleEmail.toBuilder() : null;
        }

        public final void setSimpleEmail(SimpleEmail.BuilderImpl simpleEmail) {
            this.simpleEmail = simpleEmail != null ? simpleEmail.build() : null;
        }

        @Override
        public final Builder simpleEmail(SimpleEmail simpleEmail) {
            this.simpleEmail = simpleEmail;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return substitutions;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        @Override
        public EmailMessage build() {
            return new EmailMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
