/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the content and settings for a message template that can be used in messages that are sent
 * through the email channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailTemplateResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailTemplateResponse.Builder, EmailTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(EmailTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(EmailTemplateResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> DEFAULT_SUBSTITUTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultSubstitutions").getter(getter(EmailTemplateResponse::defaultSubstitutions))
            .setter(setter(Builder::defaultSubstitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubstitutions").build())
            .build();

    private static final SdkField<String> HTML_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HtmlPart").getter(getter(EmailTemplateResponse::htmlPart)).setter(setter(Builder::htmlPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(EmailTemplateResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> RECOMMENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommenderId").getter(getter(EmailTemplateResponse::recommenderId))
            .setter(setter(Builder::recommenderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderId").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(EmailTemplateResponse::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<List<MessageHeader>> HEADERS_FIELD = SdkField
            .<List<MessageHeader>> builder(MarshallingType.LIST)
            .memberName("Headers")
            .getter(getter(EmailTemplateResponse::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageHeader> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageHeader::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(EmailTemplateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TEMPLATE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateDescription").getter(getter(EmailTemplateResponse::templateDescription))
            .setter(setter(Builder::templateDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateDescription").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(EmailTemplateResponse::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(EmailTemplateResponse::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final SdkField<String> TEXT_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextPart").getter(getter(EmailTemplateResponse::textPart)).setter(setter(Builder::textPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(EmailTemplateResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_DATE_FIELD, DEFAULT_SUBSTITUTIONS_FIELD, HTML_PART_FIELD, LAST_MODIFIED_DATE_FIELD, RECOMMENDER_ID_FIELD,
            SUBJECT_FIELD, HEADERS_FIELD, TAGS_FIELD, TEMPLATE_DESCRIPTION_FIELD, TEMPLATE_NAME_FIELD, TEMPLATE_TYPE_FIELD,
            TEXT_PART_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String creationDate;

    private final String defaultSubstitutions;

    private final String htmlPart;

    private final String lastModifiedDate;

    private final String recommenderId;

    private final String subject;

    private final List<MessageHeader> headers;

    private final Map<String, String> tags;

    private final String templateDescription;

    private final String templateName;

    private final String templateType;

    private final String textPart;

    private final String version;

    private EmailTemplateResponse(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.defaultSubstitutions = builder.defaultSubstitutions;
        this.htmlPart = builder.htmlPart;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.recommenderId = builder.recommenderId;
        this.subject = builder.subject;
        this.headers = builder.headers;
        this.tags = builder.tags;
        this.templateDescription = builder.templateDescription;
        this.templateName = builder.templateName;
        this.templateType = builder.templateType;
        this.textPart = builder.textPart;
        this.version = builder.version;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the message template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the message template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the message template was created.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the message template was created.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The JSON object that specifies the default values that are used for message variables in the message template.
     * This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding
     * value defines the default value for that variable.
     * </p>
     * 
     * @return The JSON object that specifies the default values that are used for message variables in the message
     *         template. This object is a set of key-value pairs. Each key defines a message variable in the template.
     *         The corresponding value defines the default value for that variable.
     */
    public final String defaultSubstitutions() {
        return defaultSubstitutions;
    }

    /**
     * <p>
     * The message body, in HTML format, that's used in email messages that are based on the message template.
     * </p>
     * 
     * @return The message body, in HTML format, that's used in email messages that are based on the message template.
     */
    public final String htmlPart() {
        return htmlPart;
    }

    /**
     * <p>
     * The date, in ISO 8601 format, when the message template was last modified.
     * </p>
     * 
     * @return The date, in ISO 8601 format, when the message template was last modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The unique identifier for the recommender model that's used by the message template.
     * </p>
     * 
     * @return The unique identifier for the recommender model that's used by the message template.
     */
    public final String recommenderId() {
        return recommenderId;
    }

    /**
     * <p>
     * The subject line, or title, that's used in email messages that are based on the message template.
     * </p>
     * 
     * @return The subject line, or title, that's used in email messages that are based on the message template.
     */
    public final String subject() {
        return subject;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a href=
     * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
     * >MessageHeaders</a> for the email. You can have up to 15 Headers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The list of <a href=
     *         "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
     *         >MessageHeaders</a> for the email. You can have up to 15 Headers.
     */
    public final List<MessageHeader> headers() {
        return headers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string-to-string map of key-value pairs that identifies the tags that are associated with the message template.
     * Each tag consists of a required tag key and an associated tag value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A string-to-string map of key-value pairs that identifies the tags that are associated with the message
     *         template. Each tag consists of a required tag key and an associated tag value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The custom description of the message template.
     * </p>
     * 
     * @return The custom description of the message template.
     */
    public final String templateDescription() {
        return templateDescription;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The type of channel that the message template is designed for. For an email template, this value is EMAIL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of channel that the message template is designed for. For an email template, this value is
     *         EMAIL.
     * @see TemplateType
     */
    public final TemplateType templateType() {
        return TemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of channel that the message template is designed for. For an email template, this value is EMAIL.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of channel that the message template is designed for. For an email template, this value is
     *         EMAIL.
     * @see TemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * The message body, in plain text format, that's used in email messages that are based on the message template.
     * </p>
     * 
     * @return The message body, in plain text format, that's used in email messages that are based on the message
     *         template.
     */
    public final String textPart() {
        return textPart;
    }

    /**
     * <p>
     * The unique identifier, as an integer, for the active version of the message template, or the version of the
     * template that you specified by using the version parameter in your request.
     * </p>
     * 
     * @return The unique identifier, as an integer, for the active version of the message template, or the version of
     *         the template that you specified by using the version parameter in your request.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubstitutions());
        hashCode = 31 * hashCode + Objects.hashCode(htmlPart());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(recommenderId());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(templateDescription());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(textPart());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateResponse)) {
            return false;
        }
        EmailTemplateResponse other = (EmailTemplateResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(defaultSubstitutions(), other.defaultSubstitutions())
                && Objects.equals(htmlPart(), other.htmlPart()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(recommenderId(), other.recommenderId()) && Objects.equals(subject(), other.subject())
                && hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(templateDescription(), other.templateDescription())
                && Objects.equals(templateName(), other.templateName())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(textPart(), other.textPart()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailTemplateResponse").add("Arn", arn()).add("CreationDate", creationDate())
                .add("DefaultSubstitutions", defaultSubstitutions()).add("HtmlPart", htmlPart())
                .add("LastModifiedDate", lastModifiedDate()).add("RecommenderId", recommenderId()).add("Subject", subject())
                .add("Headers", hasHeaders() ? headers() : null).add("Tags", hasTags() ? tags() : null)
                .add("TemplateDescription", templateDescription()).add("TemplateName", templateName())
                .add("TemplateType", templateTypeAsString()).add("TextPart", textPart()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "DefaultSubstitutions":
            return Optional.ofNullable(clazz.cast(defaultSubstitutions()));
        case "HtmlPart":
            return Optional.ofNullable(clazz.cast(htmlPart()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "RecommenderId":
            return Optional.ofNullable(clazz.cast(recommenderId()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TemplateDescription":
            return Optional.ofNullable(clazz.cast(templateDescription()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "TextPart":
            return Optional.ofNullable(clazz.cast(textPart()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("DefaultSubstitutions", DEFAULT_SUBSTITUTIONS_FIELD);
        map.put("HtmlPart", HTML_PART_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("RecommenderId", RECOMMENDER_ID_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Headers", HEADERS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("TemplateDescription", TEMPLATE_DESCRIPTION_FIELD);
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateType", TEMPLATE_TYPE_FIELD);
        map.put("TextPart", TEXT_PART_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailTemplateResponse, T> g) {
        return obj -> g.apply((EmailTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailTemplateResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the message template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date, in ISO 8601 format, when the message template was created.
         * </p>
         * 
         * @param creationDate
         *        The date, in ISO 8601 format, when the message template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The JSON object that specifies the default values that are used for message variables in the message
         * template. This object is a set of key-value pairs. Each key defines a message variable in the template. The
         * corresponding value defines the default value for that variable.
         * </p>
         * 
         * @param defaultSubstitutions
         *        The JSON object that specifies the default values that are used for message variables in the message
         *        template. This object is a set of key-value pairs. Each key defines a message variable in the
         *        template. The corresponding value defines the default value for that variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubstitutions(String defaultSubstitutions);

        /**
         * <p>
         * The message body, in HTML format, that's used in email messages that are based on the message template.
         * </p>
         * 
         * @param htmlPart
         *        The message body, in HTML format, that's used in email messages that are based on the message
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlPart(String htmlPart);

        /**
         * <p>
         * The date, in ISO 8601 format, when the message template was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date, in ISO 8601 format, when the message template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The unique identifier for the recommender model that's used by the message template.
         * </p>
         * 
         * @param recommenderId
         *        The unique identifier for the recommender model that's used by the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommenderId(String recommenderId);

        /**
         * <p>
         * The subject line, or title, that's used in email messages that are based on the message template.
         * </p>
         * 
         * @param subject
         *        The subject line, or title, that's used in email messages that are based on the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * </p>
         * 
         * @param headers
         *        The list of <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         *        >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Collection<MessageHeader> headers);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * </p>
         * 
         * @param headers
         *        The list of <a href=
         *        "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         *        >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(MessageHeader... headers);

        /**
         * <p>
         * The list of <a href=
         * "https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader"
         * >MessageHeaders</a> for the email. You can have up to 15 Headers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder#build()} is called immediately
         * and its result is passed to {@link #headers(List<MessageHeader>)}.
         * 
         * @param headers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.MessageHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headers(java.util.Collection<MessageHeader>)
         */
        Builder headers(Consumer<MessageHeader.Builder>... headers);

        /**
         * <p>
         * A string-to-string map of key-value pairs that identifies the tags that are associated with the message
         * template. Each tag consists of a required tag key and an associated tag value.
         * </p>
         * 
         * @param tags
         *        A string-to-string map of key-value pairs that identifies the tags that are associated with the
         *        message template. Each tag consists of a required tag key and an associated tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The custom description of the message template.
         * </p>
         * 
         * @param templateDescription
         *        The custom description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateDescription(String templateDescription);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param templateName
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The type of channel that the message template is designed for. For an email template, this value is EMAIL.
         * </p>
         * 
         * @param templateType
         *        The type of channel that the message template is designed for. For an email template, this value is
         *        EMAIL.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of channel that the message template is designed for. For an email template, this value is EMAIL.
         * </p>
         * 
         * @param templateType
         *        The type of channel that the message template is designed for. For an email template, this value is
         *        EMAIL.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(TemplateType templateType);

        /**
         * <p>
         * The message body, in plain text format, that's used in email messages that are based on the message template.
         * </p>
         * 
         * @param textPart
         *        The message body, in plain text format, that's used in email messages that are based on the message
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPart(String textPart);

        /**
         * <p>
         * The unique identifier, as an integer, for the active version of the message template, or the version of the
         * template that you specified by using the version parameter in your request.
         * </p>
         * 
         * @param version
         *        The unique identifier, as an integer, for the active version of the message template, or the version
         *        of the template that you specified by using the version parameter in your request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String creationDate;

        private String defaultSubstitutions;

        private String htmlPart;

        private String lastModifiedDate;

        private String recommenderId;

        private String subject;

        private List<MessageHeader> headers = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String templateDescription;

        private String templateName;

        private String templateType;

        private String textPart;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailTemplateResponse model) {
            arn(model.arn);
            creationDate(model.creationDate);
            defaultSubstitutions(model.defaultSubstitutions);
            htmlPart(model.htmlPart);
            lastModifiedDate(model.lastModifiedDate);
            recommenderId(model.recommenderId);
            subject(model.subject);
            headers(model.headers);
            tags(model.tags);
            templateDescription(model.templateDescription);
            templateName(model.templateName);
            templateType(model.templateType);
            textPart(model.textPart);
            version(model.version);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDefaultSubstitutions() {
            return defaultSubstitutions;
        }

        public final void setDefaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
        }

        @Override
        public final Builder defaultSubstitutions(String defaultSubstitutions) {
            this.defaultSubstitutions = defaultSubstitutions;
            return this;
        }

        public final String getHtmlPart() {
            return htmlPart;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getRecommenderId() {
            return recommenderId;
        }

        public final void setRecommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
        }

        @Override
        public final Builder recommenderId(String recommenderId) {
            this.recommenderId = recommenderId;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final List<MessageHeader.Builder> getHeaders() {
            List<MessageHeader.Builder> result = ListOfMessageHeaderCopier.copyToBuilder(this.headers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaders(Collection<MessageHeader.BuilderImpl> headers) {
            this.headers = ListOfMessageHeaderCopier.copyFromBuilder(headers);
        }

        @Override
        public final Builder headers(Collection<MessageHeader> headers) {
            this.headers = ListOfMessageHeaderCopier.copy(headers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(MessageHeader... headers) {
            headers(Arrays.asList(headers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headers(Consumer<MessageHeader.Builder>... headers) {
            headers(Stream.of(headers).map(c -> MessageHeader.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTemplateDescription() {
            return templateDescription;
        }

        public final void setTemplateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
        }

        @Override
        public final Builder templateDescription(String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getTextPart() {
            return textPart;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public EmailTemplateResponse build() {
            return new EmailTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
