/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about endpoints and the events that they're associated with.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventsResponse implements SdkPojo, Serializable, ToCopyableBuilder<EventsResponse.Builder, EventsResponse> {
    private static final SdkField<Map<String, ItemResponse>> RESULTS_FIELD = SdkField
            .<Map<String, ItemResponse>> builder(MarshallingType.MAP)
            .memberName("Results")
            .getter(getter(EventsResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ItemResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ItemResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, ItemResponse> results;

    private EventsResponse(BuilderImpl builder) {
        this.results = builder.results;
    }

    /**
     * For responses, this returns true if the service returned a value for the Results property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains a multipart response for each endpoint. For each item in this object, the endpoint ID is the
     * key and the item response is the value. If no item response exists, the value can also be one of the following:
     * 202, the request was processed successfully; or 400, the payload wasn't valid or required fields were missing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResults} method.
     * </p>
     * 
     * @return A map that contains a multipart response for each endpoint. For each item in this object, the endpoint ID
     *         is the key and the item response is the value. If no item response exists, the value can also be one of
     *         the following: 202, the request was processed successfully; or 400, the payload wasn't valid or required
     *         fields were missing.
     */
    public final Map<String, ItemResponse> results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsResponse)) {
            return false;
        }
        EventsResponse other = (EventsResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventsResponse").add("Results", hasResults() ? results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventsResponse, T> g) {
        return obj -> g.apply((EventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventsResponse> {
        /**
         * <p>
         * A map that contains a multipart response for each endpoint. For each item in this object, the endpoint ID is
         * the key and the item response is the value. If no item response exists, the value can also be one of the
         * following: 202, the request was processed successfully; or 400, the payload wasn't valid or required fields
         * were missing.
         * </p>
         * 
         * @param results
         *        A map that contains a multipart response for each endpoint. For each item in this object, the endpoint
         *        ID is the key and the item response is the value. If no item response exists, the value can also be
         *        one of the following: 202, the request was processed successfully; or 400, the payload wasn't valid or
         *        required fields were missing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Map<String, ItemResponse> results);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ItemResponse> results = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsResponse model) {
            results(model.results);
        }

        public final Map<String, ItemResponse.Builder> getResults() {
            Map<String, ItemResponse.Builder> result = MapOfItemResponseCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResults(Map<String, ItemResponse.BuilderImpl> results) {
            this.results = MapOfItemResponseCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Map<String, ItemResponse> results) {
            this.results = MapOfItemResponseCopier.copy(results);
            return this;
        }

        @Override
        public EventsResponse build() {
            return new EventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
