/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send
 * push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GCMChannelRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<GCMChannelRequest.Builder, GCMChannelRequest> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiKey")
            .getter(getter(GCMChannelRequest::apiKey)).setter(setter(Builder::apiKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKey").build()).build();

    private static final SdkField<String> DEFAULT_AUTHENTICATION_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultAuthenticationMethod")
            .getter(getter(GCMChannelRequest::defaultAuthenticationMethod))
            .setter(setter(Builder::defaultAuthenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAuthenticationMethod")
                    .build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(GCMChannelRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> SERVICE_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceJson").getter(getter(GCMChannelRequest::serviceJson)).setter(setter(Builder::serviceJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceJson").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD,
            DEFAULT_AUTHENTICATION_METHOD_FIELD, ENABLED_FIELD, SERVICE_JSON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String apiKey;

    private final String defaultAuthenticationMethod;

    private final Boolean enabled;

    private final String serviceJson;

    private GCMChannelRequest(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.defaultAuthenticationMethod = builder.defaultAuthenticationMethod;
        this.enabled = builder.enabled;
        this.serviceJson = builder.serviceJson;
    }

    /**
     * <p>
     * The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to
     * communicate with Google services.
     * </p>
     * 
     * @return The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from
     *         Google to communicate with Google services.
     */
    public final String apiKey() {
        return apiKey;
    }

    /**
     * <p>
     * The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".
     * </p>
     * 
     * @return The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".
     */
    public final String defaultAuthenticationMethod() {
        return defaultAuthenticationMethod;
    }

    /**
     * <p>
     * Specifies whether to enable the GCM channel for the application.
     * </p>
     * 
     * @return Specifies whether to enable the GCM channel for the application.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The contents of the JSON file provided by Google during registration in order to generate an access token for
     * authentication. For more information see <a
     * href="https://firebase.google.com/docs/cloud-messaging/migrate-v1">Migrate from legacy FCM APIs to HTTP v1</a>.
     * </p>
     * 
     * @return The contents of the JSON file provided by Google during registration in order to generate an access token
     *         for authentication. For more information see <a
     *         href="https://firebase.google.com/docs/cloud-messaging/migrate-v1">Migrate from legacy FCM APIs to HTTP
     *         v1</a>.
     */
    public final String serviceJson() {
        return serviceJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(serviceJson());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GCMChannelRequest)) {
            return false;
        }
        GCMChannelRequest other = (GCMChannelRequest) obj;
        return Objects.equals(apiKey(), other.apiKey())
                && Objects.equals(defaultAuthenticationMethod(), other.defaultAuthenticationMethod())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(serviceJson(), other.serviceJson());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GCMChannelRequest").add("ApiKey", apiKey())
                .add("DefaultAuthenticationMethod", defaultAuthenticationMethod()).add("Enabled", enabled())
                .add("ServiceJson", serviceJson()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiKey":
            return Optional.ofNullable(clazz.cast(apiKey()));
        case "DefaultAuthenticationMethod":
            return Optional.ofNullable(clazz.cast(defaultAuthenticationMethod()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "ServiceJson":
            return Optional.ofNullable(clazz.cast(serviceJson()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApiKey", API_KEY_FIELD);
        map.put("DefaultAuthenticationMethod", DEFAULT_AUTHENTICATION_METHOD_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("ServiceJson", SERVICE_JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GCMChannelRequest, T> g) {
        return obj -> g.apply((GCMChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GCMChannelRequest> {
        /**
         * <p>
         * The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to
         * communicate with Google services.
         * </p>
         * 
         * @param apiKey
         *        The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from
         *        Google to communicate with Google services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKey(String apiKey);

        /**
         * <p>
         * The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".
         * </p>
         * 
         * @param defaultAuthenticationMethod
         *        The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAuthenticationMethod(String defaultAuthenticationMethod);

        /**
         * <p>
         * Specifies whether to enable the GCM channel for the application.
         * </p>
         * 
         * @param enabled
         *        Specifies whether to enable the GCM channel for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The contents of the JSON file provided by Google during registration in order to generate an access token for
         * authentication. For more information see <a
         * href="https://firebase.google.com/docs/cloud-messaging/migrate-v1">Migrate from legacy FCM APIs to HTTP
         * v1</a>.
         * </p>
         * 
         * @param serviceJson
         *        The contents of the JSON file provided by Google during registration in order to generate an access
         *        token for authentication. For more information see <a
         *        href="https://firebase.google.com/docs/cloud-messaging/migrate-v1">Migrate from legacy FCM APIs to
         *        HTTP v1</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceJson(String serviceJson);
    }

    static final class BuilderImpl implements Builder {
        private String apiKey;

        private String defaultAuthenticationMethod;

        private Boolean enabled;

        private String serviceJson;

        private BuilderImpl() {
        }

        private BuilderImpl(GCMChannelRequest model) {
            apiKey(model.apiKey);
            defaultAuthenticationMethod(model.defaultAuthenticationMethod);
            enabled(model.enabled);
            serviceJson(model.serviceJson);
        }

        public final String getApiKey() {
            return apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getDefaultAuthenticationMethod() {
            return defaultAuthenticationMethod;
        }

        public final void setDefaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
        }

        @Override
        public final Builder defaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getServiceJson() {
            return serviceJson;
        }

        public final void setServiceJson(String serviceJson) {
            this.serviceJson = serviceJson;
        }

        @Override
        public final Builder serviceJson(String serviceJson) {
            this.serviceJson = serviceJson;
            return this;
        }

        @Override
        public GCMChannelRequest build() {
            return new GCMChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
