/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3)
 * bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportJobRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportJobRequest.Builder, ImportJobRequest> {
    private static final SdkField<Boolean> DEFINE_SEGMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefineSegment").getter(getter(ImportJobRequest::defineSegment)).setter(setter(Builder::defineSegment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefineSegment").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalId").getter(getter(ImportJobRequest::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(ImportJobRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<Boolean> REGISTER_ENDPOINTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RegisterEndpoints").getter(getter(ImportJobRequest::registerEndpoints))
            .setter(setter(Builder::registerEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisterEndpoints").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ImportJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Url")
            .getter(getter(ImportJobRequest::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()).build();

    private static final SdkField<String> SEGMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentId").getter(getter(ImportJobRequest::segmentId)).setter(setter(Builder::segmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentId").build()).build();

    private static final SdkField<String> SEGMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentName").getter(getter(ImportJobRequest::segmentName)).setter(setter(Builder::segmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINE_SEGMENT_FIELD,
            EXTERNAL_ID_FIELD, FORMAT_FIELD, REGISTER_ENDPOINTS_FIELD, ROLE_ARN_FIELD, S3_URL_FIELD, SEGMENT_ID_FIELD,
            SEGMENT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean defineSegment;

    private final String externalId;

    private final String format;

    private final Boolean registerEndpoints;

    private final String roleArn;

    private final String s3Url;

    private final String segmentId;

    private final String segmentName;

    private ImportJobRequest(BuilderImpl builder) {
        this.defineSegment = builder.defineSegment;
        this.externalId = builder.externalId;
        this.format = builder.format;
        this.registerEndpoints = builder.registerEndpoints;
        this.roleArn = builder.roleArn;
        this.s3Url = builder.s3Url;
        this.segmentId = builder.segmentId;
        this.segmentName = builder.segmentName;
    }

    /**
     * <p>
     * Specifies whether to create a segment that contains the endpoints, when the endpoint definitions are imported.
     * </p>
     * 
     * @return Specifies whether to create a segment that contains the endpoints, when the endpoint definitions are
     *         imported.
     */
    public final Boolean defineSegment() {
        return defineSegment;
    }

    /**
     * <p>
     * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon
     * Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed
     * this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
     * </p>
     * 
     * @return (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon
     *         Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we
     *         removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon
     *         Pinpoint.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
     * comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location stores
     * multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the
     * specified format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
     *         comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location
     *         stores multiple files that use different formats, Amazon Pinpoint imports data only from the files that
     *         use the specified format.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
     * comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location stores
     * multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the
     * specified format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
     *         comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location
     *         stores multiple files that use different formats, Amazon Pinpoint imports data only from the files that
     *         use the specified format.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * Specifies whether to register the endpoints with Amazon Pinpoint, when the endpoint definitions are imported.
     * </p>
     * 
     * @return Specifies whether to register the endpoints with Amazon Pinpoint, when the endpoint definitions are
     *         imported.
     */
    public final Boolean registerEndpoints() {
        return registerEndpoints;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
     * Pinpoint to access the Amazon S3 location to import endpoint definitions from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
     *         Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions to import.
     * This location can be a folder or a single file. If the location is a folder, Amazon Pinpoint imports endpoint
     * definitions from the files in this location, including any subfolders that the folder contains.
     * </p>
     * <p>
     * The URL should be in the following format:
     * s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable
     * >/<replaceable>file-name</replaceable>. The location can end with the key for an individual object or a prefix
     * that qualifies multiple objects.
     * </p>
     * 
     * @return The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions to
     *         import. This location can be a folder or a single file. If the location is a folder, Amazon Pinpoint
     *         imports endpoint definitions from the files in this location, including any subfolders that the folder
     *         contains.</p>
     *         <p>
     *         The URL should be in the following format:
     *         s3://<replaceable>bucket-name</replaceable>/<replaceable>folder
     *         -name</replaceable>/<replaceable>file-name</replaceable>. The location can end with the key for an
     *         individual object or a prefix that qualifies multiple objects.
     */
    public final String s3Url() {
        return s3Url;
    }

    /**
     * <p>
     * The identifier for the segment to update or add the imported endpoint definitions to, if the import job is meant
     * to update an existing segment.
     * </p>
     * 
     * @return The identifier for the segment to update or add the imported endpoint definitions to, if the import job
     *         is meant to update an existing segment.
     */
    public final String segmentId() {
        return segmentId;
    }

    /**
     * <p>
     * A custom name for the segment that's created by the import job, if the value of the DefineSegment property is
     * true.
     * </p>
     * 
     * @return A custom name for the segment that's created by the import job, if the value of the DefineSegment
     *         property is true.
     */
    public final String segmentName() {
        return segmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defineSegment());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(registerEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobRequest)) {
            return false;
        }
        ImportJobRequest other = (ImportJobRequest) obj;
        return Objects.equals(defineSegment(), other.defineSegment()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(registerEndpoints(), other.registerEndpoints()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(s3Url(), other.s3Url()) && Objects.equals(segmentId(), other.segmentId())
                && Objects.equals(segmentName(), other.segmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportJobRequest").add("DefineSegment", defineSegment()).add("ExternalId", externalId())
                .add("Format", formatAsString()).add("RegisterEndpoints", registerEndpoints()).add("RoleArn", roleArn())
                .add("S3Url", s3Url()).add("SegmentId", segmentId()).add("SegmentName", segmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefineSegment":
            return Optional.ofNullable(clazz.cast(defineSegment()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "RegisterEndpoints":
            return Optional.ofNullable(clazz.cast(registerEndpoints()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "S3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        case "SegmentId":
            return Optional.ofNullable(clazz.cast(segmentId()));
        case "SegmentName":
            return Optional.ofNullable(clazz.cast(segmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefineSegment", DEFINE_SEGMENT_FIELD);
        map.put("ExternalId", EXTERNAL_ID_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("RegisterEndpoints", REGISTER_ENDPOINTS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("S3Url", S3_URL_FIELD);
        map.put("SegmentId", SEGMENT_ID_FIELD);
        map.put("SegmentName", SEGMENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportJobRequest, T> g) {
        return obj -> g.apply((ImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportJobRequest> {
        /**
         * <p>
         * Specifies whether to create a segment that contains the endpoints, when the endpoint definitions are
         * imported.
         * </p>
         * 
         * @param defineSegment
         *        Specifies whether to create a segment that contains the endpoints, when the endpoint definitions are
         *        imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defineSegment(Boolean defineSegment);

        /**
         * <p>
         * (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon
         * Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed
         * this requirement. We don't recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.
         * </p>
         * 
         * @param externalId
         *        (Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy.
         *        Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions,
         *        but we removed this requirement. We don't recommend use of external IDs for IAM roles that are assumed
         *        by Amazon Pinpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
         * comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location stores
         * multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the
         * specified format.
         * </p>
         * 
         * @param format
         *        The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
         *        comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location
         *        stores multiple files that use different formats, Amazon Pinpoint imports data only from the files
         *        that use the specified format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
         * comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location stores
         * multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the
         * specified format.
         * </p>
         * 
         * @param format
         *        The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for
         *        comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location
         *        stores multiple files that use different formats, Amazon Pinpoint imports data only from the files
         *        that use the specified format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * Specifies whether to register the endpoints with Amazon Pinpoint, when the endpoint definitions are imported.
         * </p>
         * 
         * @param registerEndpoints
         *        Specifies whether to register the endpoints with Amazon Pinpoint, when the endpoint definitions are
         *        imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registerEndpoints(Boolean registerEndpoints);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon
         * Pinpoint to access the Amazon S3 location to import endpoint definitions from.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes
         *        Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions to
         * import. This location can be a folder or a single file. If the location is a folder, Amazon Pinpoint imports
         * endpoint definitions from the files in this location, including any subfolders that the folder contains.
         * </p>
         * <p>
         * The URL should be in the following format:
         * s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name
         * </replaceable>/<replaceable>file-name</replaceable>. The location can end with the key for an individual
         * object or a prefix that qualifies multiple objects.
         * </p>
         * 
         * @param s3Url
         *        The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions
         *        to import. This location can be a folder or a single file. If the location is a folder, Amazon
         *        Pinpoint imports endpoint definitions from the files in this location, including any subfolders that
         *        the folder contains.</p>
         *        <p>
         *        The URL should be in the following format:
         *        s3://<replaceable>bucket-name</replaceable>/<replaceable>folder
         *        -name</replaceable>/<replaceable>file-name</replaceable>. The location can end with the key for an
         *        individual object or a prefix that qualifies multiple objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);

        /**
         * <p>
         * The identifier for the segment to update or add the imported endpoint definitions to, if the import job is
         * meant to update an existing segment.
         * </p>
         * 
         * @param segmentId
         *        The identifier for the segment to update or add the imported endpoint definitions to, if the import
         *        job is meant to update an existing segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentId(String segmentId);

        /**
         * <p>
         * A custom name for the segment that's created by the import job, if the value of the DefineSegment property is
         * true.
         * </p>
         * 
         * @param segmentName
         *        A custom name for the segment that's created by the import job, if the value of the DefineSegment
         *        property is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentName(String segmentName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean defineSegment;

        private String externalId;

        private String format;

        private Boolean registerEndpoints;

        private String roleArn;

        private String s3Url;

        private String segmentId;

        private String segmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobRequest model) {
            defineSegment(model.defineSegment);
            externalId(model.externalId);
            format(model.format);
            registerEndpoints(model.registerEndpoints);
            roleArn(model.roleArn);
            s3Url(model.s3Url);
            segmentId(model.segmentId);
            segmentName(model.segmentName);
        }

        public final Boolean getDefineSegment() {
            return defineSegment;
        }

        public final void setDefineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
        }

        @Override
        public final Builder defineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Boolean getRegisterEndpoints() {
            return registerEndpoints;
        }

        public final void setRegisterEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
        }

        @Override
        public final Builder registerEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getS3Url() {
            return s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getSegmentId() {
            return segmentId;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final String getSegmentName() {
            return segmentName;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        @Override
        public ImportJobRequest build() {
            return new ImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
