/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of messages that can be sent to an endpoint during the specified timeframe for all journeys.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyTimeframeCap implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyTimeframeCap.Builder, JourneyTimeframeCap> {
    private static final SdkField<Integer> CAP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Cap")
            .getter(getter(JourneyTimeframeCap::cap)).setter(setter(Builder::cap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cap").build()).build();

    private static final SdkField<Integer> DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Days")
            .getter(getter(JourneyTimeframeCap::days)).setter(setter(Builder::days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Days").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAP_FIELD, DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer cap;

    private final Integer days;

    private JourneyTimeframeCap(BuilderImpl builder) {
        this.cap = builder.cap;
        this.days = builder.days;
    }

    /**
     * <p>
     * The maximum number of messages that all journeys can send to an endpoint during the specified timeframe. The
     * maximum value is 100. If set to 0, this limit will not apply.
     * </p>
     * 
     * @return The maximum number of messages that all journeys can send to an endpoint during the specified timeframe.
     *         The maximum value is 100. If set to 0, this limit will not apply.
     */
    public final Integer cap() {
        return cap;
    }

    /**
     * <p>
     * The length of the timeframe in days. The maximum value is 30. If set to 0, this limit will not apply.
     * </p>
     * 
     * @return The length of the timeframe in days. The maximum value is 30. If set to 0, this limit will not apply.
     */
    public final Integer days() {
        return days;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cap());
        hashCode = 31 * hashCode + Objects.hashCode(days());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyTimeframeCap)) {
            return false;
        }
        JourneyTimeframeCap other = (JourneyTimeframeCap) obj;
        return Objects.equals(cap(), other.cap()) && Objects.equals(days(), other.days());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneyTimeframeCap").add("Cap", cap()).add("Days", days()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cap":
            return Optional.ofNullable(clazz.cast(cap()));
        case "Days":
            return Optional.ofNullable(clazz.cast(days()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cap", CAP_FIELD);
        map.put("Days", DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JourneyTimeframeCap, T> g) {
        return obj -> g.apply((JourneyTimeframeCap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyTimeframeCap> {
        /**
         * <p>
         * The maximum number of messages that all journeys can send to an endpoint during the specified timeframe. The
         * maximum value is 100. If set to 0, this limit will not apply.
         * </p>
         * 
         * @param cap
         *        The maximum number of messages that all journeys can send to an endpoint during the specified
         *        timeframe. The maximum value is 100. If set to 0, this limit will not apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cap(Integer cap);

        /**
         * <p>
         * The length of the timeframe in days. The maximum value is 30. If set to 0, this limit will not apply.
         * </p>
         * 
         * @param days
         *        The length of the timeframe in days. The maximum value is 30. If set to 0, this limit will not apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);
    }

    static final class BuilderImpl implements Builder {
        private Integer cap;

        private Integer days;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyTimeframeCap model) {
            cap(model.cap);
            days(model.days);
        }

        public final Integer getCap() {
            return cap;
        }

        public final void setCap(Integer cap) {
            this.cap = cap;
        }

        @Override
        public final Builder cap(Integer cap) {
            this.cap = cap;
            return this;
        }

        public final Integer getDays() {
            return days;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        @Override
        public JourneyTimeframeCap build() {
            return new JourneyTimeframeCap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
