/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveAttributesRequest extends PinpointRequest implements
        ToCopyableBuilder<RemoveAttributesRequest.Builder, RemoveAttributesRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(RemoveAttributesRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()).build();

    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeType").getter(getter(RemoveAttributesRequest::attributeType))
            .setter(setter(Builder::attributeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("attribute-type").build()).build();

    private static final SdkField<UpdateAttributesRequest> UPDATE_ATTRIBUTES_REQUEST_FIELD = SdkField
            .<UpdateAttributesRequest> builder(MarshallingType.SDK_POJO)
            .memberName("UpdateAttributesRequest")
            .getter(getter(RemoveAttributesRequest::updateAttributesRequest))
            .setter(setter(Builder::updateAttributesRequest))
            .constructor(UpdateAttributesRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAttributesRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ATTRIBUTE_TYPE_FIELD, UPDATE_ATTRIBUTES_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationId;

    private final String attributeType;

    private final UpdateAttributesRequest updateAttributesRequest;

    private RemoveAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.attributeType = builder.attributeType;
        this.updateAttributesRequest = builder.updateAttributesRequest;
    }

    /**
     * <p>
     * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon
     * Pinpoint console.
     * </p>
     * 
     * @return The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
     *         Amazon Pinpoint console.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The type of attribute or attributes to remove. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user
     * opted in or out of receiving communications from you through a specific type of channel.
     * </p>
     * </li>
     * <li>
     * <p>
     * endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the
     * number of app sessions or the number of items left in a cart.
     * </p>
     * </li>
     * <li>
     * <p>
     * endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <p>
     *         The type of attribute or attributes to remove. Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an
     *         associated user opted in or out of receiving communications from you through a specific type of channel.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such
     *         as the number of app sessions or the number of items left in a cart.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String attributeType() {
        return attributeType;
    }

    /**
     * Returns the value of the UpdateAttributesRequest property for this object.
     * 
     * @return The value of the UpdateAttributesRequest property for this object.
     */
    public final UpdateAttributesRequest updateAttributesRequest() {
        return updateAttributesRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeType());
        hashCode = 31 * hashCode + Objects.hashCode(updateAttributesRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveAttributesRequest)) {
            return false;
        }
        RemoveAttributesRequest other = (RemoveAttributesRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(attributeType(), other.attributeType())
                && Objects.equals(updateAttributesRequest(), other.updateAttributesRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveAttributesRequest").add("ApplicationId", applicationId())
                .add("AttributeType", attributeType()).add("UpdateAttributesRequest", updateAttributesRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "AttributeType":
            return Optional.ofNullable(clazz.cast(attributeType()));
        case "UpdateAttributesRequest":
            return Optional.ofNullable(clazz.cast(updateAttributesRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("application-id", APPLICATION_ID_FIELD);
        map.put("attribute-type", ATTRIBUTE_TYPE_FIELD);
        map.put("UpdateAttributesRequest", UPDATE_ATTRIBUTES_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveAttributesRequest, T> g) {
        return obj -> g.apply((RemoveAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveAttributesRequest> {
        /**
         * <p>
         * The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the
         * Amazon Pinpoint console.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on
         *        the Amazon Pinpoint console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The type of attribute or attributes to remove. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated
         * user opted in or out of receiving communications from you through a specific type of channel.
         * </p>
         * </li>
         * <li>
         * <p>
         * endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as
         * the number of app sessions or the number of items left in a cart.
         * </p>
         * </li>
         * <li>
         * <p>
         * endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeType
         *        <p>
         *        The type of attribute or attributes to remove. Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an
         *        associated user opted in or out of receiving communications from you through a specific type of
         *        channel.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints,
         *        such as the number of app sessions or the number of items left in a cart.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and
         *        age.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeType(String attributeType);

        /**
         * Sets the value of the UpdateAttributesRequest property for this object.
         *
         * @param updateAttributesRequest
         *        The new value for the UpdateAttributesRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateAttributesRequest(UpdateAttributesRequest updateAttributesRequest);

        /**
         * Sets the value of the UpdateAttributesRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UpdateAttributesRequest.Builder} avoiding
         * the need to create one manually via {@link UpdateAttributesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateAttributesRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #updateAttributesRequest(UpdateAttributesRequest)}.
         * 
         * @param updateAttributesRequest
         *        a consumer that will call methods on {@link UpdateAttributesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateAttributesRequest(UpdateAttributesRequest)
         */
        default Builder updateAttributesRequest(Consumer<UpdateAttributesRequest.Builder> updateAttributesRequest) {
            return updateAttributesRequest(UpdateAttributesRequest.builder().applyMutation(updateAttributesRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String attributeType;

        private UpdateAttributesRequest updateAttributesRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveAttributesRequest model) {
            super(model);
            applicationId(model.applicationId);
            attributeType(model.attributeType);
            updateAttributesRequest(model.updateAttributesRequest);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAttributeType() {
            return attributeType;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public final UpdateAttributesRequest.Builder getUpdateAttributesRequest() {
            return updateAttributesRequest != null ? updateAttributesRequest.toBuilder() : null;
        }

        public final void setUpdateAttributesRequest(UpdateAttributesRequest.BuilderImpl updateAttributesRequest) {
            this.updateAttributesRequest = updateAttributesRequest != null ? updateAttributesRequest.build() : null;
        }

        @Override
        public final Builder updateAttributesRequest(UpdateAttributesRequest updateAttributesRequest) {
            this.updateAttributesRequest = updateAttributesRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveAttributesRequest build() {
            return new RemoveAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
