/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default settings for a one-time SMS message that's sent directly to an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMSMessage implements SdkPojo, Serializable, ToCopyableBuilder<SMSMessage.Builder, SMSMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(SMSMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> KEYWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Keyword")
            .getter(getter(SMSMessage::keyword)).setter(setter(Builder::keyword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()).build();

    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaUrl").getter(getter(SMSMessage::mediaUrl)).setter(setter(Builder::mediaUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()).build();

    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageType").getter(getter(SMSMessage::messageTypeAsString)).setter(setter(Builder::messageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()).build();

    private static final SdkField<String> ORIGINATION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginationNumber").getter(getter(SMSMessage::originationNumber))
            .setter(setter(Builder::originationNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationNumber").build()).build();

    private static final SdkField<String> SENDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderId").getter(getter(SMSMessage::senderId)).setter(setter(Builder::senderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Substitutions")
            .getter(getter(SMSMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(SMSMessage::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(SMSMessage::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, KEYWORD_FIELD,
            MEDIA_URL_FIELD, MESSAGE_TYPE_FIELD, ORIGINATION_NUMBER_FIELD, SENDER_ID_FIELD, SUBSTITUTIONS_FIELD, ENTITY_ID_FIELD,
            TEMPLATE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String keyword;

    private final String mediaUrl;

    private final String messageType;

    private final String originationNumber;

    private final String senderId;

    private final Map<String, List<String>> substitutions;

    private final String entityId;

    private final String templateId;

    private SMSMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.keyword = builder.keyword;
        this.mediaUrl = builder.mediaUrl;
        this.messageType = builder.messageType;
        this.originationNumber = builder.originationNumber;
        this.senderId = builder.senderId;
        this.substitutions = builder.substitutions;
        this.entityId = builder.entityId;
        this.templateId = builder.templateId;
    }

    /**
     * <p>
     * The body of the SMS message.
     * </p>
     * 
     * @return The body of the SMS message.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * The SMS program name that you provided to AWS Support when you requested your dedicated number.
     * </p>
     * 
     * @return The SMS program name that you provided to AWS Support when you requested your dedicated number.
     */
    public final String keyword() {
        return keyword;
    }

    /**
     * <p>
     * This field is reserved for future use.
     * </p>
     * 
     * @return This field is reserved for future use.
     */
    public final String mediaUrl() {
        return mediaUrl;
    }

    /**
     * <p>
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a
     * one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing
     * messages).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive,
     *         such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such
     *         as marketing messages).
     * @see MessageType
     */
    public final MessageType messageType() {
        return MessageType.fromValue(messageType);
    }

    /**
     * <p>
     * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a
     * one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as marketing
     * messages).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageType} will
     * return {@link MessageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageTypeAsString}.
     * </p>
     * 
     * @return The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive,
     *         such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such
     *         as marketing messages).
     * @see MessageType
     */
    public final String messageTypeAsString() {
        return messageType;
    }

    /**
     * <p>
     * The number to send the SMS message from. This value should be one of the dedicated long or short codes that's
     * assigned to your AWS account. If you don't specify a long or short code, Amazon Pinpoint assigns a random long
     * code to the SMS message and sends the message from that code.
     * </p>
     * 
     * @return The number to send the SMS message from. This value should be one of the dedicated long or short codes
     *         that's assigned to your AWS account. If you don't specify a long or short code, Amazon Pinpoint assigns a
     *         random long code to the SMS message and sends the message from that code.
     */
    public final String originationNumber() {
        return originationNumber;
    }

    /**
     * <p>
     * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies by
     * country or region.
     * </p>
     * 
     * @return The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs
     *         varies by country or region.
     */
    public final String senderId() {
        return senderId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Substitutions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubstitutions() {
        return substitutions != null && !(substitutions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The message variables to use in the SMS message. You can override the default variables with individual address
     * variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubstitutions} method.
     * </p>
     * 
     * @return The message variables to use in the SMS message. You can override the default variables with individual
     *         address variables.
     */
    public final Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * <p>
     * The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
     * </p>
     * 
     * @return The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your
     *         country.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The template ID received from the regulatory body for sending SMS in your country.
     * </p>
     * 
     * @return The template ID received from the regulatory body for sending SMS in your country.
     */
    public final String templateId() {
        return templateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(keyword());
        hashCode = 31 * hashCode + Objects.hashCode(mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(senderId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubstitutions() ? substitutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSMessage)) {
            return false;
        }
        SMSMessage other = (SMSMessage) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(keyword(), other.keyword())
                && Objects.equals(mediaUrl(), other.mediaUrl())
                && Objects.equals(messageTypeAsString(), other.messageTypeAsString())
                && Objects.equals(originationNumber(), other.originationNumber()) && Objects.equals(senderId(), other.senderId())
                && hasSubstitutions() == other.hasSubstitutions() && Objects.equals(substitutions(), other.substitutions())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(templateId(), other.templateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SMSMessage").add("Body", body()).add("Keyword", keyword()).add("MediaUrl", mediaUrl())
                .add("MessageType", messageTypeAsString()).add("OriginationNumber", originationNumber())
                .add("SenderId", senderId()).add("Substitutions", hasSubstitutions() ? substitutions() : null)
                .add("EntityId", entityId()).add("TemplateId", templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Keyword":
            return Optional.ofNullable(clazz.cast(keyword()));
        case "MediaUrl":
            return Optional.ofNullable(clazz.cast(mediaUrl()));
        case "MessageType":
            return Optional.ofNullable(clazz.cast(messageTypeAsString()));
        case "OriginationNumber":
            return Optional.ofNullable(clazz.cast(originationNumber()));
        case "SenderId":
            return Optional.ofNullable(clazz.cast(senderId()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Body", BODY_FIELD);
        map.put("Keyword", KEYWORD_FIELD);
        map.put("MediaUrl", MEDIA_URL_FIELD);
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("OriginationNumber", ORIGINATION_NUMBER_FIELD);
        map.put("SenderId", SENDER_ID_FIELD);
        map.put("Substitutions", SUBSTITUTIONS_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("TemplateId", TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SMSMessage, T> g) {
        return obj -> g.apply((SMSMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMSMessage> {
        /**
         * <p>
         * The body of the SMS message.
         * </p>
         * 
         * @param body
         *        The body of the SMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The SMS program name that you provided to AWS Support when you requested your dedicated number.
         * </p>
         * 
         * @param keyword
         *        The SMS program name that you provided to AWS Support when you requested your dedicated number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyword(String keyword);

        /**
         * <p>
         * This field is reserved for future use.
         * </p>
         * 
         * @param mediaUrl
         *        This field is reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUrl(String mediaUrl);

        /**
         * <p>
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such
         * as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as
         * marketing messages).
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or
         *        time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or
         *        time-sensitive, such as marketing messages).
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(String messageType);

        /**
         * <p>
         * The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such
         * as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or time-sensitive, such as
         * marketing messages).
         * </p>
         * 
         * @param messageType
         *        The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or
         *        time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren't critical or
         *        time-sensitive, such as marketing messages).
         * @see MessageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageType
         */
        Builder messageType(MessageType messageType);

        /**
         * <p>
         * The number to send the SMS message from. This value should be one of the dedicated long or short codes that's
         * assigned to your AWS account. If you don't specify a long or short code, Amazon Pinpoint assigns a random
         * long code to the SMS message and sends the message from that code.
         * </p>
         * 
         * @param originationNumber
         *        The number to send the SMS message from. This value should be one of the dedicated long or short codes
         *        that's assigned to your AWS account. If you don't specify a long or short code, Amazon Pinpoint
         *        assigns a random long code to the SMS message and sends the message from that code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originationNumber(String originationNumber);

        /**
         * <p>
         * The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs varies
         * by country or region.
         * </p>
         * 
         * @param senderId
         *        The sender ID to display as the sender of the message on a recipient's device. Support for sender IDs
         *        varies by country or region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderId(String senderId);

        /**
         * <p>
         * The message variables to use in the SMS message. You can override the default variables with individual
         * address variables.
         * </p>
         * 
         * @param substitutions
         *        The message variables to use in the SMS message. You can override the default variables with
         *        individual address variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * <p>
         * The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.
         * </p>
         * 
         * @param entityId
         *        The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your
         *        country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The template ID received from the regulatory body for sending SMS in your country.
         * </p>
         * 
         * @param templateId
         *        The template ID received from the regulatory body for sending SMS in your country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String keyword;

        private String mediaUrl;

        private String messageType;

        private String originationNumber;

        private String senderId;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private String entityId;

        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSMessage model) {
            body(model.body);
            keyword(model.keyword);
            mediaUrl(model.mediaUrl);
            messageType(model.messageType);
            originationNumber(model.originationNumber);
            senderId(model.senderId);
            substitutions(model.substitutions);
            entityId(model.entityId);
            templateId(model.templateId);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getKeyword() {
            return keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final String getMediaUrl() {
            return mediaUrl;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final String getMessageType() {
            return messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final String getOriginationNumber() {
            return originationNumber;
        }

        public final void setOriginationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
        }

        @Override
        public final Builder originationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public final String getSenderId() {
            return senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return substitutions;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @Override
        public SMSMessage build() {
            return new SMSMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
