/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommenderConfigurationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommenderConfigurationResponse> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::attributes)).setter(RecommenderConfigurationResponse.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::creationDate)).setter(RecommenderConfigurationResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::description)).setter(RecommenderConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::id)).setter(RecommenderConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::lastModifiedDate)).setter(RecommenderConfigurationResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::name)).setter(RecommenderConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RECOMMENDATION_PROVIDER_ID_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationProviderIdType").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::recommendationProviderIdType)).setter(RecommenderConfigurationResponse.setter(Builder::recommendationProviderIdType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderIdType").build()}).build();
    private static final SdkField<String> RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationProviderRoleArn").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::recommendationProviderRoleArn)).setter(RecommenderConfigurationResponse.setter(Builder::recommendationProviderRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderRoleArn").build()}).build();
    private static final SdkField<String> RECOMMENDATION_PROVIDER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationProviderUri").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::recommendationProviderUri)).setter(RecommenderConfigurationResponse.setter(Builder::recommendationProviderUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderUri").build()}).build();
    private static final SdkField<String> RECOMMENDATION_TRANSFORMER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationTransformerUri").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::recommendationTransformerUri)).setter(RecommenderConfigurationResponse.setter(Builder::recommendationTransformerUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationTransformerUri").build()}).build();
    private static final SdkField<String> RECOMMENDATIONS_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationsDisplayName").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::recommendationsDisplayName)).setter(RecommenderConfigurationResponse.setter(Builder::recommendationsDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsDisplayName").build()}).build();
    private static final SdkField<Integer> RECOMMENDATIONS_PER_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecommendationsPerMessage").getter(RecommenderConfigurationResponse.getter(RecommenderConfigurationResponse::recommendationsPerMessage)).setter(RecommenderConfigurationResponse.setter(Builder::recommendationsPerMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsPerMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, CREATION_DATE_FIELD, DESCRIPTION_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD, RECOMMENDATION_PROVIDER_ID_TYPE_FIELD, RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD, RECOMMENDATION_PROVIDER_URI_FIELD, RECOMMENDATION_TRANSFORMER_URI_FIELD, RECOMMENDATIONS_DISPLAY_NAME_FIELD, RECOMMENDATIONS_PER_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommenderConfigurationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> attributes;
    private final String creationDate;
    private final String description;
    private final String id;
    private final String lastModifiedDate;
    private final String name;
    private final String recommendationProviderIdType;
    private final String recommendationProviderRoleArn;
    private final String recommendationProviderUri;
    private final String recommendationTransformerUri;
    private final String recommendationsDisplayName;
    private final Integer recommendationsPerMessage;

    private RecommenderConfigurationResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.recommendationProviderIdType = builder.recommendationProviderIdType;
        this.recommendationProviderRoleArn = builder.recommendationProviderRoleArn;
        this.recommendationProviderUri = builder.recommendationProviderUri;
        this.recommendationTransformerUri = builder.recommendationTransformerUri;
        this.recommendationsDisplayName = builder.recommendationsDisplayName;
        this.recommendationsPerMessage = builder.recommendationsPerMessage;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String name() {
        return this.name;
    }

    public final String recommendationProviderIdType() {
        return this.recommendationProviderIdType;
    }

    public final String recommendationProviderRoleArn() {
        return this.recommendationProviderRoleArn;
    }

    public final String recommendationProviderUri() {
        return this.recommendationProviderUri;
    }

    public final String recommendationTransformerUri() {
        return this.recommendationTransformerUri;
    }

    public final String recommendationsDisplayName() {
        return this.recommendationsDisplayName;
    }

    public final Integer recommendationsPerMessage() {
        return this.recommendationsPerMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationProviderIdType());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationProviderRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationProviderUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTransformerUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationsDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationsPerMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommenderConfigurationResponse)) {
            return false;
        }
        RecommenderConfigurationResponse other = (RecommenderConfigurationResponse)obj;
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recommendationProviderIdType(), other.recommendationProviderIdType()) && Objects.equals(this.recommendationProviderRoleArn(), other.recommendationProviderRoleArn()) && Objects.equals(this.recommendationProviderUri(), other.recommendationProviderUri()) && Objects.equals(this.recommendationTransformerUri(), other.recommendationTransformerUri()) && Objects.equals(this.recommendationsDisplayName(), other.recommendationsDisplayName()) && Objects.equals(this.recommendationsPerMessage(), other.recommendationsPerMessage());
    }

    public final String toString() {
        return ToString.builder((String)"RecommenderConfigurationResponse").add("Attributes", this.hasAttributes() ? this.attributes() : null).add("CreationDate", (Object)this.creationDate()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Name", (Object)this.name()).add("RecommendationProviderIdType", (Object)this.recommendationProviderIdType()).add("RecommendationProviderRoleArn", (Object)this.recommendationProviderRoleArn()).add("RecommendationProviderUri", (Object)this.recommendationProviderUri()).add("RecommendationTransformerUri", (Object)this.recommendationTransformerUri()).add("RecommendationsDisplayName", (Object)this.recommendationsDisplayName()).add("RecommendationsPerMessage", (Object)this.recommendationsPerMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RecommendationProviderIdType": {
                return Optional.ofNullable(clazz.cast(this.recommendationProviderIdType()));
            }
            case "RecommendationProviderRoleArn": {
                return Optional.ofNullable(clazz.cast(this.recommendationProviderRoleArn()));
            }
            case "RecommendationProviderUri": {
                return Optional.ofNullable(clazz.cast(this.recommendationProviderUri()));
            }
            case "RecommendationTransformerUri": {
                return Optional.ofNullable(clazz.cast(this.recommendationTransformerUri()));
            }
            case "RecommendationsDisplayName": {
                return Optional.ofNullable(clazz.cast(this.recommendationsDisplayName()));
            }
            case "RecommendationsPerMessage": {
                return Optional.ofNullable(clazz.cast(this.recommendationsPerMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RecommendationProviderIdType", RECOMMENDATION_PROVIDER_ID_TYPE_FIELD);
        map.put("RecommendationProviderRoleArn", RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD);
        map.put("RecommendationProviderUri", RECOMMENDATION_PROVIDER_URI_FIELD);
        map.put("RecommendationTransformerUri", RECOMMENDATION_TRANSFORMER_URI_FIELD);
        map.put("RecommendationsDisplayName", RECOMMENDATIONS_DISPLAY_NAME_FIELD);
        map.put("RecommendationsPerMessage", RECOMMENDATIONS_PER_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommenderConfigurationResponse, T> g) {
        return obj -> g.apply((RecommenderConfigurationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String creationDate;
        private String description;
        private String id;
        private String lastModifiedDate;
        private String name;
        private String recommendationProviderIdType;
        private String recommendationProviderRoleArn;
        private String recommendationProviderUri;
        private String recommendationTransformerUri;
        private String recommendationsDisplayName;
        private Integer recommendationsPerMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommenderConfigurationResponse model) {
            this.attributes(model.attributes);
            this.creationDate(model.creationDate);
            this.description(model.description);
            this.id(model.id);
            this.lastModifiedDate(model.lastModifiedDate);
            this.name(model.name);
            this.recommendationProviderIdType(model.recommendationProviderIdType);
            this.recommendationProviderRoleArn(model.recommendationProviderRoleArn);
            this.recommendationProviderUri(model.recommendationProviderUri);
            this.recommendationTransformerUri(model.recommendationTransformerUri);
            this.recommendationsDisplayName(model.recommendationsDisplayName);
            this.recommendationsPerMessage(model.recommendationsPerMessage);
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecommendationProviderIdType() {
            return this.recommendationProviderIdType;
        }

        public final void setRecommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
        }

        @Override
        public final Builder recommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
            return this;
        }

        public final String getRecommendationProviderRoleArn() {
            return this.recommendationProviderRoleArn;
        }

        public final void setRecommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
        }

        @Override
        public final Builder recommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
            return this;
        }

        public final String getRecommendationProviderUri() {
            return this.recommendationProviderUri;
        }

        public final void setRecommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
        }

        @Override
        public final Builder recommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
            return this;
        }

        public final String getRecommendationTransformerUri() {
            return this.recommendationTransformerUri;
        }

        public final void setRecommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
        }

        @Override
        public final Builder recommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
            return this;
        }

        public final String getRecommendationsDisplayName() {
            return this.recommendationsDisplayName;
        }

        public final void setRecommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
        }

        @Override
        public final Builder recommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
            return this;
        }

        public final Integer getRecommendationsPerMessage() {
            return this.recommendationsPerMessage;
        }

        public final void setRecommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
        }

        @Override
        public final Builder recommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
            return this;
        }

        public RecommenderConfigurationResponse build() {
            return new RecommenderConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommenderConfigurationResponse> {
        public Builder attributes(Map<String, String> var1);

        public Builder creationDate(String var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder name(String var1);

        public Builder recommendationProviderIdType(String var1);

        public Builder recommendationProviderRoleArn(String var1);

        public Builder recommendationProviderUri(String var1);

        public Builder recommendationTransformerUri(String var1);

        public Builder recommendationsDisplayName(String var1);

        public Builder recommendationsPerMessage(Integer var1);
    }
}

