/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a path in a random split activity in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RandomSplitEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<RandomSplitEntry.Builder, RandomSplitEntry> {
    private static final SdkField<String> NEXT_ACTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextActivity").getter(getter(RandomSplitEntry::nextActivity)).setter(setter(Builder::nextActivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextActivity").build()).build();

    private static final SdkField<Integer> PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Percentage").getter(getter(RandomSplitEntry::percentage)).setter(setter(Builder::percentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_ACTIVITY_FIELD,
            PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nextActivity;

    private final Integer percentage;

    private RandomSplitEntry(BuilderImpl builder) {
        this.nextActivity = builder.nextActivity;
        this.percentage = builder.percentage;
    }

    /**
     * <p>
     * The unique identifier for the next activity to perform, after completing the activity for the path.
     * </p>
     * 
     * @return The unique identifier for the next activity to perform, after completing the activity for the path.
     */
    public final String nextActivity() {
        return nextActivity;
    }

    /**
     * <p>
     * The percentage of participants to send down the activity path.
     * </p>
     * <p>
     * To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to
     * the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent
     * down a path may not be equal to the percentage that you specify.
     * </p>
     * 
     * @return The percentage of participants to send down the activity path.</p>
     *         <p>
     *         To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based
     *         algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of
     *         participants who are sent down a path may not be equal to the percentage that you specify.
     */
    public final Integer percentage() {
        return percentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextActivity());
        hashCode = 31 * hashCode + Objects.hashCode(percentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RandomSplitEntry)) {
            return false;
        }
        RandomSplitEntry other = (RandomSplitEntry) obj;
        return Objects.equals(nextActivity(), other.nextActivity()) && Objects.equals(percentage(), other.percentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RandomSplitEntry").add("NextActivity", nextActivity()).add("Percentage", percentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextActivity":
            return Optional.ofNullable(clazz.cast(nextActivity()));
        case "Percentage":
            return Optional.ofNullable(clazz.cast(percentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextActivity", NEXT_ACTIVITY_FIELD);
        map.put("Percentage", PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RandomSplitEntry, T> g) {
        return obj -> g.apply((RandomSplitEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RandomSplitEntry> {
        /**
         * <p>
         * The unique identifier for the next activity to perform, after completing the activity for the path.
         * </p>
         * 
         * @param nextActivity
         *        The unique identifier for the next activity to perform, after completing the activity for the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextActivity(String nextActivity);

        /**
         * <p>
         * The percentage of participants to send down the activity path.
         * </p>
         * <p>
         * To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based
         * algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants
         * who are sent down a path may not be equal to the percentage that you specify.
         * </p>
         * 
         * @param percentage
         *        The percentage of participants to send down the activity path.</p>
         *        <p>
         *        To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based
         *        algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of
         *        participants who are sent down a path may not be equal to the percentage that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentage(Integer percentage);
    }

    static final class BuilderImpl implements Builder {
        private String nextActivity;

        private Integer percentage;

        private BuilderImpl() {
        }

        private BuilderImpl(RandomSplitEntry model) {
            nextActivity(model.nextActivity);
            percentage(model.percentage);
        }

        public final String getNextActivity() {
            return nextActivity;
        }

        public final void setNextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
        }

        @Override
        public final Builder nextActivity(String nextActivity) {
            this.nextActivity = nextActivity;
            return this;
        }

        public final Integer getPercentage() {
            return percentage;
        }

        public final void setPercentage(Integer percentage) {
            this.percentage = percentage;
        }

        @Override
        public final Builder percentage(Integer percentage) {
            this.percentage = percentage;
            return this;
        }

        @Override
        public RandomSplitEntry build() {
            return new RandomSplitEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
