/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status and settings of the email channel for an application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailChannelResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailChannelResponse.Builder, EmailChannelResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(EmailChannelResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> CONFIGURATION_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationSet").getter(getter(EmailChannelResponse::configurationSet))
            .setter(setter(Builder::configurationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(EmailChannelResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(EmailChannelResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromAddress").getter(getter(EmailChannelResponse::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final SdkField<Boolean> HAS_CREDENTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasCredential").getter(getter(EmailChannelResponse::hasCredential))
            .setter(setter(Builder::hasCredential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasCredential").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(EmailChannelResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identity").getter(getter(EmailChannelResponse::identity)).setter(setter(Builder::identity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()).build();

    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsArchived").getter(getter(EmailChannelResponse::isArchived)).setter(setter(Builder::isArchived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsArchived").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedBy").getter(getter(EmailChannelResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedDate").getter(getter(EmailChannelResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<Integer> MESSAGES_PER_SECOND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MessagesPerSecond").getter(getter(EmailChannelResponse::messagesPerSecond))
            .setter(setter(Builder::messagesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagesPerSecond").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(EmailChannelResponse::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(EmailChannelResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> ORCHESTRATION_SENDING_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrchestrationSendingRoleArn")
            .getter(getter(EmailChannelResponse::orchestrationSendingRoleArn))
            .setter(setter(Builder::orchestrationSendingRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrchestrationSendingRoleArn")
                    .build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(EmailChannelResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_SET_FIELD, CREATION_DATE_FIELD, ENABLED_FIELD, FROM_ADDRESS_FIELD, HAS_CREDENTIAL_FIELD, ID_FIELD,
            IDENTITY_FIELD, IS_ARCHIVED_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_DATE_FIELD, MESSAGES_PER_SECOND_FIELD,
            PLATFORM_FIELD, ROLE_ARN_FIELD, ORCHESTRATION_SENDING_ROLE_ARN_FIELD, VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String configurationSet;

    private final String creationDate;

    private final Boolean enabled;

    private final String fromAddress;

    private final Boolean hasCredential;

    private final String id;

    private final String identity;

    private final Boolean isArchived;

    private final String lastModifiedBy;

    private final String lastModifiedDate;

    private final Integer messagesPerSecond;

    private final String platform;

    private final String roleArn;

    private final String orchestrationSendingRoleArn;

    private final Integer version;

    private EmailChannelResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.configurationSet = builder.configurationSet;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.fromAddress = builder.fromAddress;
        this.hasCredential = builder.hasCredential;
        this.id = builder.id;
        this.identity = builder.identity;
        this.isArchived = builder.isArchived;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.messagesPerSecond = builder.messagesPerSecond;
        this.platform = builder.platform;
        this.roleArn = builder.roleArn;
        this.orchestrationSendingRoleArn = builder.orchestrationSendingRoleArn;
        this.version = builder.version;
    }

    /**
     * <p>
     * The unique identifier for the application that the email channel applies to.
     * </p>
     * 
     * @return The unique identifier for the application that the email channel applies to.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
     * configuration set</a> that's applied to messages that are sent through the channel.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
     *         configuration set</a> that's applied to messages that are sent through the channel.
     */
    public final String configurationSet() {
        return configurationSet;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when the email channel was enabled.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when the email channel was enabled.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Specifies whether the email channel is enabled for the application.
     * </p>
     * 
     * @return Specifies whether the email channel is enabled for the application.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The verified email address that email is sent from when you send email through the channel.
     * </p>
     * 
     * @return The verified email address that email is sent from when you send email through the channel.
     */
    public final String fromAddress() {
        return fromAddress;
    }

    /**
     * <p>
     * (Not used) This property is retained only for backward compatibility.
     * </p>
     * 
     * @return (Not used) This property is retained only for backward compatibility.
     */
    public final Boolean hasCredential() {
        return hasCredential;
    }

    /**
     * <p>
     * (Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.
     * </p>
     * 
     * @return (Deprecated) An identifier for the email channel. This property is retained only for backward
     *         compatibility.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that's
     * used when you send email through the channel.
     * </p>
     * 
     * @return <p>
     *         The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES),
     *         that's used when you send email through the channel.
     *         </p>
     */
    public final String identity() {
        return identity;
    }

    /**
     * <p>
     * Specifies whether the email channel is archived.
     * </p>
     * 
     * @return Specifies whether the email channel is archived.
     */
    public final Boolean isArchived() {
        return isArchived;
    }

    /**
     * <p>
     * The user who last modified the email channel.
     * </p>
     * 
     * @return The user who last modified the email channel.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The date and time, in ISO 8601 format, when the email channel was last modified.
     * </p>
     * 
     * @return The date and time, in ISO 8601 format, when the email channel was last modified.
     */
    public final String lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The maximum number of emails that can be sent through the channel each second.
     * </p>
     * 
     * @return The maximum number of emails that can be sent through the channel each second.
     */
    public final Integer messagesPerSecond() {
        return messagesPerSecond;
    }

    /**
     * <p>
     * The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.
     * </p>
     * 
     * @return The type of messaging or notification platform for the channel. For the email channel, this value is
     *         EMAIL.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related
     * event data for the channel.
     * </p>
     * 
     * @return <p>
     *         The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit
     *         email-related event data for the channel.
     *         </p>
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role for Amazon Pinpoint to use to send email from your campaigns or journeys through Amazon
     * SES.
     * </p>
     * 
     * @return The ARN of an IAM role for Amazon Pinpoint to use to send email from your campaigns or journeys through
     *         Amazon SES.
     */
    public final String orchestrationSendingRoleArn() {
        return orchestrationSendingRoleArn;
    }

    /**
     * <p>
     * The current version of the email channel.
     * </p>
     * 
     * @return The current version of the email channel.
     */
    public final Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationSet());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasCredential());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        hashCode = 31 * hashCode + Objects.hashCode(isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(messagesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrationSendingRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelResponse)) {
            return false;
        }
        EmailChannelResponse other = (EmailChannelResponse) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(configurationSet(), other.configurationSet())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(fromAddress(), other.fromAddress()) && Objects.equals(hasCredential(), other.hasCredential())
                && Objects.equals(id(), other.id()) && Objects.equals(identity(), other.identity())
                && Objects.equals(isArchived(), other.isArchived()) && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(messagesPerSecond(), other.messagesPerSecond()) && Objects.equals(platform(), other.platform())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(orchestrationSendingRoleArn(), other.orchestrationSendingRoleArn())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailChannelResponse").add("ApplicationId", applicationId())
                .add("ConfigurationSet", configurationSet()).add("CreationDate", creationDate()).add("Enabled", enabled())
                .add("FromAddress", fromAddress()).add("HasCredential", hasCredential()).add("Id", id())
                .add("Identity", identity()).add("IsArchived", isArchived()).add("LastModifiedBy", lastModifiedBy())
                .add("LastModifiedDate", lastModifiedDate()).add("MessagesPerSecond", messagesPerSecond())
                .add("Platform", platform()).add("RoleArn", roleArn())
                .add("OrchestrationSendingRoleArn", orchestrationSendingRoleArn()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "ConfigurationSet":
            return Optional.ofNullable(clazz.cast(configurationSet()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        case "HasCredential":
            return Optional.ofNullable(clazz.cast(hasCredential()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Identity":
            return Optional.ofNullable(clazz.cast(identity()));
        case "IsArchived":
            return Optional.ofNullable(clazz.cast(isArchived()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "MessagesPerSecond":
            return Optional.ofNullable(clazz.cast(messagesPerSecond()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "OrchestrationSendingRoleArn":
            return Optional.ofNullable(clazz.cast(orchestrationSendingRoleArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ConfigurationSet", CONFIGURATION_SET_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("FromAddress", FROM_ADDRESS_FIELD);
        map.put("HasCredential", HAS_CREDENTIAL_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Identity", IDENTITY_FIELD);
        map.put("IsArchived", IS_ARCHIVED_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("MessagesPerSecond", MESSAGES_PER_SECOND_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("OrchestrationSendingRoleArn", ORCHESTRATION_SENDING_ROLE_ARN_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailChannelResponse, T> g) {
        return obj -> g.apply((EmailChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailChannelResponse> {
        /**
         * <p>
         * The unique identifier for the application that the email channel applies to.
         * </p>
         * 
         * @param applicationId
         *        The unique identifier for the application that the email channel applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
         * configuration set</a> that's applied to messages that are sent through the channel.
         * </p>
         * 
         * @param configurationSet
         *        The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES
         *        configuration set</a> that's applied to messages that are sent through the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(String configurationSet);

        /**
         * <p>
         * The date and time, in ISO 8601 format, when the email channel was enabled.
         * </p>
         * 
         * @param creationDate
         *        The date and time, in ISO 8601 format, when the email channel was enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * Specifies whether the email channel is enabled for the application.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the email channel is enabled for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The verified email address that email is sent from when you send email through the channel.
         * </p>
         * 
         * @param fromAddress
         *        The verified email address that email is sent from when you send email through the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);

        /**
         * <p>
         * (Not used) This property is retained only for backward compatibility.
         * </p>
         * 
         * @param hasCredential
         *        (Not used) This property is retained only for backward compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasCredential(Boolean hasCredential);

        /**
         * <p>
         * (Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.
         * </p>
         * 
         * @param id
         *        (Deprecated) An identifier for the email channel. This property is retained only for backward
         *        compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES),
         * that's used when you send email through the channel.
         * </p>
         * 
         * @param identity
         *        <p>
         *        The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon
         *        SES), that's used when you send email through the channel.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * Specifies whether the email channel is archived.
         * </p>
         * 
         * @param isArchived
         *        Specifies whether the email channel is archived.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isArchived(Boolean isArchived);

        /**
         * <p>
         * The user who last modified the email channel.
         * </p>
         * 
         * @param lastModifiedBy
         *        The user who last modified the email channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The date and time, in ISO 8601 format, when the email channel was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time, in ISO 8601 format, when the email channel was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(String lastModifiedDate);

        /**
         * <p>
         * The maximum number of emails that can be sent through the channel each second.
         * </p>
         * 
         * @param messagesPerSecond
         *        The maximum number of emails that can be sent through the channel each second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagesPerSecond(Integer messagesPerSecond);

        /**
         * <p>
         * The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.
         * </p>
         * 
         * @param platform
         *        The type of messaging or notification platform for the channel. For the email channel, this value is
         *        EMAIL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit
         * email-related event data for the channel.
         * </p>
         * 
         * @param roleArn
         *        <p>
         *        The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit
         *        email-related event data for the channel.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The ARN of an IAM role for Amazon Pinpoint to use to send email from your campaigns or journeys through
         * Amazon SES.
         * </p>
         * 
         * @param orchestrationSendingRoleArn
         *        The ARN of an IAM role for Amazon Pinpoint to use to send email from your campaigns or journeys
         *        through Amazon SES.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrationSendingRoleArn(String orchestrationSendingRoleArn);

        /**
         * <p>
         * The current version of the email channel.
         * </p>
         * 
         * @param version
         *        The current version of the email channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String configurationSet;

        private String creationDate;

        private Boolean enabled;

        private String fromAddress;

        private Boolean hasCredential;

        private String id;

        private String identity;

        private Boolean isArchived;

        private String lastModifiedBy;

        private String lastModifiedDate;

        private Integer messagesPerSecond;

        private String platform;

        private String roleArn;

        private String orchestrationSendingRoleArn;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelResponse model) {
            applicationId(model.applicationId);
            configurationSet(model.configurationSet);
            creationDate(model.creationDate);
            enabled(model.enabled);
            fromAddress(model.fromAddress);
            hasCredential(model.hasCredential);
            id(model.id);
            identity(model.identity);
            isArchived(model.isArchived);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedDate(model.lastModifiedDate);
            messagesPerSecond(model.messagesPerSecond);
            platform(model.platform);
            roleArn(model.roleArn);
            orchestrationSendingRoleArn(model.orchestrationSendingRoleArn);
            version(model.version);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getConfigurationSet() {
            return configurationSet;
        }

        public final void setConfigurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
        }

        @Override
        public final Builder configurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final Boolean getHasCredential() {
            return hasCredential;
        }

        public final void setHasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
        }

        @Override
        public final Builder hasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIdentity() {
            return identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final Boolean getIsArchived() {
            return isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Integer getMessagesPerSecond() {
            return messagesPerSecond;
        }

        public final void setMessagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
        }

        @Override
        public final Builder messagesPerSecond(Integer messagesPerSecond) {
            this.messagesPerSecond = messagesPerSecond;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getOrchestrationSendingRoleArn() {
            return orchestrationSendingRoleArn;
        }

        public final void setOrchestrationSendingRoleArn(String orchestrationSendingRoleArn) {
            this.orchestrationSendingRoleArn = orchestrationSendingRoleArn;
        }

        @Override
        public final Builder orchestrationSendingRoleArn(String orchestrationSendingRoleArn) {
            this.orchestrationSendingRoleArn = orchestrationSendingRoleArn;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        @Override
        public EmailChannelResponse build() {
            return new EmailChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
