/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the message content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppMessageContent implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppMessageContent.Builder, InAppMessageContent> {
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackgroundColor").getter(getter(InAppMessageContent::backgroundColor))
            .setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()).build();

    private static final SdkField<InAppMessageBodyConfig> BODY_CONFIG_FIELD = SdkField
            .<InAppMessageBodyConfig> builder(MarshallingType.SDK_POJO).memberName("BodyConfig")
            .getter(getter(InAppMessageContent::bodyConfig)).setter(setter(Builder::bodyConfig))
            .constructor(InAppMessageBodyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BodyConfig").build()).build();

    private static final SdkField<InAppMessageHeaderConfig> HEADER_CONFIG_FIELD = SdkField
            .<InAppMessageHeaderConfig> builder(MarshallingType.SDK_POJO).memberName("HeaderConfig")
            .getter(getter(InAppMessageContent::headerConfig)).setter(setter(Builder::headerConfig))
            .constructor(InAppMessageHeaderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderConfig").build()).build();

    private static final SdkField<String> IMAGE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageUrl").getter(getter(InAppMessageContent::imageUrl)).setter(setter(Builder::imageUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUrl").build()).build();

    private static final SdkField<InAppMessageButton> PRIMARY_BTN_FIELD = SdkField
            .<InAppMessageButton> builder(MarshallingType.SDK_POJO).memberName("PrimaryBtn")
            .getter(getter(InAppMessageContent::primaryBtn)).setter(setter(Builder::primaryBtn))
            .constructor(InAppMessageButton::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryBtn").build()).build();

    private static final SdkField<InAppMessageButton> SECONDARY_BTN_FIELD = SdkField
            .<InAppMessageButton> builder(MarshallingType.SDK_POJO).memberName("SecondaryBtn")
            .getter(getter(InAppMessageContent::secondaryBtn)).setter(setter(Builder::secondaryBtn))
            .constructor(InAppMessageButton::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryBtn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKGROUND_COLOR_FIELD,
            BODY_CONFIG_FIELD, HEADER_CONFIG_FIELD, IMAGE_URL_FIELD, PRIMARY_BTN_FIELD, SECONDARY_BTN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backgroundColor;

    private final InAppMessageBodyConfig bodyConfig;

    private final InAppMessageHeaderConfig headerConfig;

    private final String imageUrl;

    private final InAppMessageButton primaryBtn;

    private final InAppMessageButton secondaryBtn;

    private InAppMessageContent(BuilderImpl builder) {
        this.backgroundColor = builder.backgroundColor;
        this.bodyConfig = builder.bodyConfig;
        this.headerConfig = builder.headerConfig;
        this.imageUrl = builder.imageUrl;
        this.primaryBtn = builder.primaryBtn;
        this.secondaryBtn = builder.secondaryBtn;
    }

    /**
     * <p>
     * The background color for the message.
     * </p>
     * 
     * @return The background color for the message.
     */
    public final String backgroundColor() {
        return backgroundColor;
    }

    /**
     * <p>
     * The configuration for the message body.
     * </p>
     * 
     * @return The configuration for the message body.
     */
    public final InAppMessageBodyConfig bodyConfig() {
        return bodyConfig;
    }

    /**
     * <p>
     * The configuration for the message header.
     * </p>
     * 
     * @return The configuration for the message header.
     */
    public final InAppMessageHeaderConfig headerConfig() {
        return headerConfig;
    }

    /**
     * <p>
     * The image url for the background of message.
     * </p>
     * 
     * @return The image url for the background of message.
     */
    public final String imageUrl() {
        return imageUrl;
    }

    /**
     * <p>
     * The first button inside the message.
     * </p>
     * 
     * @return The first button inside the message.
     */
    public final InAppMessageButton primaryBtn() {
        return primaryBtn;
    }

    /**
     * <p>
     * The second button inside message.
     * </p>
     * 
     * @return The second button inside message.
     */
    public final InAppMessageButton secondaryBtn() {
        return secondaryBtn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(bodyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(headerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(primaryBtn());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryBtn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageContent)) {
            return false;
        }
        InAppMessageContent other = (InAppMessageContent) obj;
        return Objects.equals(backgroundColor(), other.backgroundColor()) && Objects.equals(bodyConfig(), other.bodyConfig())
                && Objects.equals(headerConfig(), other.headerConfig()) && Objects.equals(imageUrl(), other.imageUrl())
                && Objects.equals(primaryBtn(), other.primaryBtn()) && Objects.equals(secondaryBtn(), other.secondaryBtn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppMessageContent").add("BackgroundColor", backgroundColor()).add("BodyConfig", bodyConfig())
                .add("HeaderConfig", headerConfig()).add("ImageUrl", imageUrl()).add("PrimaryBtn", primaryBtn())
                .add("SecondaryBtn", secondaryBtn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColor()));
        case "BodyConfig":
            return Optional.ofNullable(clazz.cast(bodyConfig()));
        case "HeaderConfig":
            return Optional.ofNullable(clazz.cast(headerConfig()));
        case "ImageUrl":
            return Optional.ofNullable(clazz.cast(imageUrl()));
        case "PrimaryBtn":
            return Optional.ofNullable(clazz.cast(primaryBtn()));
        case "SecondaryBtn":
            return Optional.ofNullable(clazz.cast(secondaryBtn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        map.put("BodyConfig", BODY_CONFIG_FIELD);
        map.put("HeaderConfig", HEADER_CONFIG_FIELD);
        map.put("ImageUrl", IMAGE_URL_FIELD);
        map.put("PrimaryBtn", PRIMARY_BTN_FIELD);
        map.put("SecondaryBtn", SECONDARY_BTN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageContent, T> g) {
        return obj -> g.apply((InAppMessageContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppMessageContent> {
        /**
         * <p>
         * The background color for the message.
         * </p>
         * 
         * @param backgroundColor
         *        The background color for the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundColor(String backgroundColor);

        /**
         * <p>
         * The configuration for the message body.
         * </p>
         * 
         * @param bodyConfig
         *        The configuration for the message body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bodyConfig(InAppMessageBodyConfig bodyConfig);

        /**
         * <p>
         * The configuration for the message body.
         * </p>
         * This is a convenience method that creates an instance of the {@link InAppMessageBodyConfig.Builder} avoiding
         * the need to create one manually via {@link InAppMessageBodyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InAppMessageBodyConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #bodyConfig(InAppMessageBodyConfig)}.
         * 
         * @param bodyConfig
         *        a consumer that will call methods on {@link InAppMessageBodyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bodyConfig(InAppMessageBodyConfig)
         */
        default Builder bodyConfig(Consumer<InAppMessageBodyConfig.Builder> bodyConfig) {
            return bodyConfig(InAppMessageBodyConfig.builder().applyMutation(bodyConfig).build());
        }

        /**
         * <p>
         * The configuration for the message header.
         * </p>
         * 
         * @param headerConfig
         *        The configuration for the message header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerConfig(InAppMessageHeaderConfig headerConfig);

        /**
         * <p>
         * The configuration for the message header.
         * </p>
         * This is a convenience method that creates an instance of the {@link InAppMessageHeaderConfig.Builder}
         * avoiding the need to create one manually via {@link InAppMessageHeaderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InAppMessageHeaderConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #headerConfig(InAppMessageHeaderConfig)}.
         * 
         * @param headerConfig
         *        a consumer that will call methods on {@link InAppMessageHeaderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headerConfig(InAppMessageHeaderConfig)
         */
        default Builder headerConfig(Consumer<InAppMessageHeaderConfig.Builder> headerConfig) {
            return headerConfig(InAppMessageHeaderConfig.builder().applyMutation(headerConfig).build());
        }

        /**
         * <p>
         * The image url for the background of message.
         * </p>
         * 
         * @param imageUrl
         *        The image url for the background of message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUrl(String imageUrl);

        /**
         * <p>
         * The first button inside the message.
         * </p>
         * 
         * @param primaryBtn
         *        The first button inside the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryBtn(InAppMessageButton primaryBtn);

        /**
         * <p>
         * The first button inside the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link InAppMessageButton.Builder} avoiding the
         * need to create one manually via {@link InAppMessageButton#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InAppMessageButton.Builder#build()} is called immediately and its
         * result is passed to {@link #primaryBtn(InAppMessageButton)}.
         * 
         * @param primaryBtn
         *        a consumer that will call methods on {@link InAppMessageButton.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryBtn(InAppMessageButton)
         */
        default Builder primaryBtn(Consumer<InAppMessageButton.Builder> primaryBtn) {
            return primaryBtn(InAppMessageButton.builder().applyMutation(primaryBtn).build());
        }

        /**
         * <p>
         * The second button inside message.
         * </p>
         * 
         * @param secondaryBtn
         *        The second button inside message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryBtn(InAppMessageButton secondaryBtn);

        /**
         * <p>
         * The second button inside message.
         * </p>
         * This is a convenience method that creates an instance of the {@link InAppMessageButton.Builder} avoiding the
         * need to create one manually via {@link InAppMessageButton#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InAppMessageButton.Builder#build()} is called immediately and its
         * result is passed to {@link #secondaryBtn(InAppMessageButton)}.
         * 
         * @param secondaryBtn
         *        a consumer that will call methods on {@link InAppMessageButton.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryBtn(InAppMessageButton)
         */
        default Builder secondaryBtn(Consumer<InAppMessageButton.Builder> secondaryBtn) {
            return secondaryBtn(InAppMessageButton.builder().applyMutation(secondaryBtn).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String backgroundColor;

        private InAppMessageBodyConfig bodyConfig;

        private InAppMessageHeaderConfig headerConfig;

        private String imageUrl;

        private InAppMessageButton primaryBtn;

        private InAppMessageButton secondaryBtn;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageContent model) {
            backgroundColor(model.backgroundColor);
            bodyConfig(model.bodyConfig);
            headerConfig(model.headerConfig);
            imageUrl(model.imageUrl);
            primaryBtn(model.primaryBtn);
            secondaryBtn(model.secondaryBtn);
        }

        public final String getBackgroundColor() {
            return backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final InAppMessageBodyConfig.Builder getBodyConfig() {
            return bodyConfig != null ? bodyConfig.toBuilder() : null;
        }

        public final void setBodyConfig(InAppMessageBodyConfig.BuilderImpl bodyConfig) {
            this.bodyConfig = bodyConfig != null ? bodyConfig.build() : null;
        }

        @Override
        public final Builder bodyConfig(InAppMessageBodyConfig bodyConfig) {
            this.bodyConfig = bodyConfig;
            return this;
        }

        public final InAppMessageHeaderConfig.Builder getHeaderConfig() {
            return headerConfig != null ? headerConfig.toBuilder() : null;
        }

        public final void setHeaderConfig(InAppMessageHeaderConfig.BuilderImpl headerConfig) {
            this.headerConfig = headerConfig != null ? headerConfig.build() : null;
        }

        @Override
        public final Builder headerConfig(InAppMessageHeaderConfig headerConfig) {
            this.headerConfig = headerConfig;
            return this;
        }

        public final String getImageUrl() {
            return imageUrl;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final InAppMessageButton.Builder getPrimaryBtn() {
            return primaryBtn != null ? primaryBtn.toBuilder() : null;
        }

        public final void setPrimaryBtn(InAppMessageButton.BuilderImpl primaryBtn) {
            this.primaryBtn = primaryBtn != null ? primaryBtn.build() : null;
        }

        @Override
        public final Builder primaryBtn(InAppMessageButton primaryBtn) {
            this.primaryBtn = primaryBtn;
            return this;
        }

        public final InAppMessageButton.Builder getSecondaryBtn() {
            return secondaryBtn != null ? secondaryBtn.toBuilder() : null;
        }

        public final void setSecondaryBtn(InAppMessageButton.BuilderImpl secondaryBtn) {
            this.secondaryBtn = secondaryBtn != null ? secondaryBtn.build() : null;
        }

        @Override
        public final Builder secondaryBtn(InAppMessageButton secondaryBtn) {
            this.secondaryBtn = secondaryBtn;
            return this;
        }

        @Override
        public InAppMessageContent build() {
            return new InAppMessageContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
