/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Verify OTP message request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyOTPMessageRequestParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifyOTPMessageRequestParameters.Builder, VerifyOTPMessageRequestParameters> {
    private static final SdkField<String> DESTINATION_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationIdentity").getter(getter(VerifyOTPMessageRequestParameters::destinationIdentity))
            .setter(setter(Builder::destinationIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIdentity").build())
            .build();

    private static final SdkField<String> OTP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Otp")
            .getter(getter(VerifyOTPMessageRequestParameters::otp)).setter(setter(Builder::otp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Otp").build()).build();

    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceId").getter(getter(VerifyOTPMessageRequestParameters::referenceId))
            .setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_IDENTITY_FIELD,
            OTP_FIELD, REFERENCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationIdentity;

    private final String otp;

    private final String referenceId;

    private VerifyOTPMessageRequestParameters(BuilderImpl builder) {
        this.destinationIdentity = builder.destinationIdentity;
        this.otp = builder.otp;
        this.referenceId = builder.referenceId;
    }

    /**
     * <p>
     * The destination identity to send OTP to.
     * </p>
     * 
     * @return The destination identity to send OTP to.
     */
    public final String destinationIdentity() {
        return destinationIdentity;
    }

    /**
     * <p>
     * The OTP the end user provided for verification.
     * </p>
     * 
     * @return The OTP the end user provided for verification.
     */
    public final String otp() {
        return otp;
    }

    /**
     * <p>
     * The reference identifier provided when the OTP was previously sent.
     * </p>
     * 
     * @return The reference identifier provided when the OTP was previously sent.
     */
    public final String referenceId() {
        return referenceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(otp());
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyOTPMessageRequestParameters)) {
            return false;
        }
        VerifyOTPMessageRequestParameters other = (VerifyOTPMessageRequestParameters) obj;
        return Objects.equals(destinationIdentity(), other.destinationIdentity()) && Objects.equals(otp(), other.otp())
                && Objects.equals(referenceId(), other.referenceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyOTPMessageRequestParameters").add("DestinationIdentity", destinationIdentity())
                .add("Otp", otp()).add("ReferenceId", referenceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationIdentity":
            return Optional.ofNullable(clazz.cast(destinationIdentity()));
        case "Otp":
            return Optional.ofNullable(clazz.cast(otp()));
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationIdentity", DESTINATION_IDENTITY_FIELD);
        map.put("Otp", OTP_FIELD);
        map.put("ReferenceId", REFERENCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifyOTPMessageRequestParameters, T> g) {
        return obj -> g.apply((VerifyOTPMessageRequestParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifyOTPMessageRequestParameters> {
        /**
         * <p>
         * The destination identity to send OTP to.
         * </p>
         * 
         * @param destinationIdentity
         *        The destination identity to send OTP to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIdentity(String destinationIdentity);

        /**
         * <p>
         * The OTP the end user provided for verification.
         * </p>
         * 
         * @param otp
         *        The OTP the end user provided for verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otp(String otp);

        /**
         * <p>
         * The reference identifier provided when the OTP was previously sent.
         * </p>
         * 
         * @param referenceId
         *        The reference identifier provided when the OTP was previously sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);
    }

    static final class BuilderImpl implements Builder {
        private String destinationIdentity;

        private String otp;

        private String referenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyOTPMessageRequestParameters model) {
            destinationIdentity(model.destinationIdentity);
            otp(model.otp);
            referenceId(model.referenceId);
        }

        public final String getDestinationIdentity() {
            return destinationIdentity;
        }

        public final void setDestinationIdentity(String destinationIdentity) {
            this.destinationIdentity = destinationIdentity;
        }

        @Override
        public final Builder destinationIdentity(String destinationIdentity) {
            this.destinationIdentity = destinationIdentity;
            return this;
        }

        public final String getOtp() {
            return otp;
        }

        public final void setOtp(String otp) {
            this.otp = otp;
        }

        @Override
        public final Builder otp(String otp) {
            this.otp = otp;
            return this;
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Override
        public VerifyOTPMessageRequestParameters build() {
            return new VerifyOTPMessageRequestParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
