/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status of a campaign.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CampaignState implements SdkPojo, Serializable, ToCopyableBuilder<CampaignState.Builder, CampaignState> {
    private static final SdkField<String> CAMPAIGN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignStatus").getter(getter(CampaignState::campaignStatusAsString))
            .setter(setter(Builder::campaignStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String campaignStatus;

    private CampaignState(BuilderImpl builder) {
        this.campaignStatus = builder.campaignStatus;
    }

    /**
     * <p>
     * The current status of the campaign, or the current status of a treatment that belongs to an A/B test campaign.
     * </p>
     * <p>
     * If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a
     * status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has a
     * status of DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #campaignStatus}
     * will return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #campaignStatusAsString}.
     * </p>
     * 
     * @return The current status of the campaign, or the current status of a treatment that belongs to an A/B test
     *         campaign.</p>
     *         <p>
     *         If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments
     *         have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign
     *         fails and has a status of DELETED.
     * @see CampaignStatus
     */
    public final CampaignStatus campaignStatus() {
        return CampaignStatus.fromValue(campaignStatus);
    }

    /**
     * <p>
     * The current status of the campaign, or the current status of a treatment that belongs to an A/B test campaign.
     * </p>
     * <p>
     * If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a
     * status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has a
     * status of DELETED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #campaignStatus}
     * will return {@link CampaignStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #campaignStatusAsString}.
     * </p>
     * 
     * @return The current status of the campaign, or the current status of a treatment that belongs to an A/B test
     *         campaign.</p>
     *         <p>
     *         If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments
     *         have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign
     *         fails and has a status of DELETED.
     * @see CampaignStatus
     */
    public final String campaignStatusAsString() {
        return campaignStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignState)) {
            return false;
        }
        CampaignState other = (CampaignState) obj;
        return Objects.equals(campaignStatusAsString(), other.campaignStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CampaignState").add("CampaignStatus", campaignStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignStatus":
            return Optional.ofNullable(clazz.cast(campaignStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CampaignStatus", CAMPAIGN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignState, T> g) {
        return obj -> g.apply((CampaignState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CampaignState> {
        /**
         * <p>
         * The current status of the campaign, or the current status of a treatment that belongs to an A/B test
         * campaign.
         * </p>
         * <p>
         * If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a
         * status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has
         * a status of DELETED.
         * </p>
         * 
         * @param campaignStatus
         *        The current status of the campaign, or the current status of a treatment that belongs to an A/B test
         *        campaign.</p>
         *        <p>
         *        If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments
         *        have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign
         *        fails and has a status of DELETED.
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder campaignStatus(String campaignStatus);

        /**
         * <p>
         * The current status of the campaign, or the current status of a treatment that belongs to an A/B test
         * campaign.
         * </p>
         * <p>
         * If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a
         * status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign fails and has
         * a status of DELETED.
         * </p>
         * 
         * @param campaignStatus
         *        The current status of the campaign, or the current status of a treatment that belongs to an A/B test
         *        campaign.</p>
         *        <p>
         *        If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments
         *        have a status of COMPLETED. If you delete the segment that's associated with a campaign, the campaign
         *        fails and has a status of DELETED.
         * @see CampaignStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CampaignStatus
         */
        Builder campaignStatus(CampaignStatus campaignStatus);
    }

    static final class BuilderImpl implements Builder {
        private String campaignStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignState model) {
            campaignStatus(model.campaignStatus);
        }

        public final String getCampaignStatus() {
            return campaignStatus;
        }

        public final void setCampaignStatus(String campaignStatus) {
            this.campaignStatus = campaignStatus;
        }

        @Override
        public final Builder campaignStatus(String campaignStatus) {
            this.campaignStatus = campaignStatus;
            return this;
        }

        @Override
        public final Builder campaignStatus(CampaignStatus campaignStatus) {
            this.campaignStatus(campaignStatus == null ? null : campaignStatus.toString());
            return this;
        }

        @Override
        public CampaignState build() {
            return new CampaignState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
