/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the default message for all channels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultMessage implements SdkPojo, Serializable, ToCopyableBuilder<DefaultMessage.Builder, DefaultMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(DefaultMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Substitutions")
            .getter(getter(DefaultMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            SUBSTITUTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String body;

    private final Map<String, List<String>> substitutions;

    private DefaultMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.substitutions = builder.substitutions;
    }

    /**
     * <p>
     * The default body of the message.
     * </p>
     * 
     * @return The default body of the message.
     */
    public final String body() {
        return body;
    }

    /**
     * For responses, this returns true if the service returned a value for the Substitutions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubstitutions() {
        return substitutions != null && !(substitutions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The default message variables to use in the message. You can override these default variables with individual
     * address variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubstitutions} method.
     * </p>
     * 
     * @return The default message variables to use in the message. You can override these default variables with
     *         individual address variables.
     */
    public final Map<String, List<String>> substitutions() {
        return substitutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubstitutions() ? substitutions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage) obj;
        return Objects.equals(body(), other.body()) && hasSubstitutions() == other.hasSubstitutions()
                && Objects.equals(substitutions(), other.substitutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultMessage").add("Body", body())
                .add("Substitutions", hasSubstitutions() ? substitutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Body", BODY_FIELD);
        map.put("Substitutions", SUBSTITUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultMessage, T> g) {
        return obj -> g.apply((DefaultMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultMessage> {
        /**
         * <p>
         * The default body of the message.
         * </p>
         * 
         * @param body
         *        The default body of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The default message variables to use in the message. You can override these default variables with individual
         * address variables.
         * </p>
         * 
         * @param substitutions
         *        The default message variables to use in the message. You can override these default variables with
         *        individual address variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultMessage model) {
            body(model.body);
            substitutions(model.substitutions);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return substitutions;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        @Override
        public DefaultMessage build() {
            return new DefaultMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
